% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bipartite.from.probability.R
\name{bipartite.from.probability}
\alias{bipartite.from.probability}
\title{Generates a bipartite network with given edge probability}
\usage{
bipartite.from.probability(R, C, P = 0, class = "matrix")
}
\arguments{
\item{R}{integer: number of rows}

\item{C}{integer: number of columns}

\item{P}{numeric: probability of an edge; if P = 0 a probability will be chosen randomly}

\item{class}{string: the class of the returned backbone graph, one of c("matrix", "Matrix", "sparseMatrix", "igraph", "network").}
}
\description{
\code{bipartite.from.probability} returns a bipartite graph, as an object of the requested class,
in which each edge has a given probability and where no node is an isolate or maximally connected.
}
\examples{
B <- bipartite.from.probability(R = 10, C = 10)
B <- bipartite.from.probability(R = 10, C = 10, P = .5)
B <- bipartite.from.probability(R = 10, C = 10, P = .5, class = "igraph")
}
