% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{tomatrix}
\alias{tomatrix}
\title{Converts an input graph object to an adjacency/incidence matrix and identifies its characteristics}
\usage{
tomatrix(graph)
}
\arguments{
\item{graph}{A graph object of class "matrix", "sparseMatrix", "dataframe", \link[igraph]{igraph}.}
}
\value{
a list(summary, G, attribs)
\code{summary} is a dataframe containing characteristics of the supplied object
\code{G} is an adjacency/incidence matrix
\code{attribs} is a dataframe containing node characteristics if present in \code{graph}
}
\description{
Converts an input graph object to an adjacency/incidence matrix and identifies its characteristics
}
\examples{
M <- matrix(rbinom(5*5,1,.5),5,5)
test <- backbone:::tomatrix(M)
}
\keyword{internal}
