% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backbone.R
\name{backbone}
\alias{backbone}
\title{Extract the backbone from a network}
\usage{
backbone(N, ...)
}
\arguments{
\item{N}{A network represented as a matrix, \link[Matrix]{Matrix}, or \link[igraph]{igraph} object}

\item{...}{Optional arguments}
}
\value{
A backbone in the same class as \code{N}
}
\description{
\code{backbone()} extracts the backbone from a weighted or unweighted network
}
\details{
Given a weighted and/or dense network, the backbone is an sparse and unweighted subgraph
that contains only the most "important" edges.

\code{backbone()} is a wrapper that detects the type of network in \code{N}, then extracts the backbone
using the appropriate \verb{backbone_from_*()} function:
\itemize{
\item If \code{N} is a weighted network, \code{\link[=backbone_from_weighted]{backbone_from_weighted()}}
\item If \code{N} is a bipartite network or hypergraph, \code{\link[=backbone_from_projection]{backbone_from_projection()}}
\item If \code{N} is an unweighted network, \code{\link[=backbone_from_unweighted]{backbone_from_unweighted()}}
}

Designed as a user-friendly wrapper, \code{backbone()} uses the defaults for the underlying functions,
which should work in many cases, and which can be modified by passing optional arguments. Unlike
the underlying functions, by default \code{backbone()} displays narrative text describing what it did
so that you know.

For details about the backbone models, see the documentation for the underlying functions above. For
an overview of the package with examples, please see the \href{../doc/backbone.html}{Introduction to
Backbone} using \code{vignette("backbone")}. For a detailed empirical example, please see the
\href{../doc/senate.html}{U.S. Senate Example} using \code{vignette("senate108")}.
}
\examples{
N <- igraph::sample_gnp(100, .3)  #A random unweighted network
backbone(N)

}
\references{
package: {Neal, Z. P. (2025). backbone: An R Package to Extract Network Backbones. CRAN. \doi{10.32614/CRAN.package.backbone}}
}
