% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_methods.R
\name{plot.baclava}
\alias{plot.baclava}
\title{Plot Posterior Distribution Parameters}
\usage{
\method{plot}{baclava}(
  x,
  y,
  ...,
  type = c("density", "trace", "acf", "hazard"),
  burnin = 0L,
  max_age = 90L,
  trace_var = c("psi", "rate_H", "rate_P", "beta")
)
}
\arguments{
\item{x}{An object of class \code{baclava}.}

\item{y}{Ignored}

\item{...}{Ignored}

\item{type}{A character object. One of \{"density", "trace", "acf", "hazard"\}. The
type of plot to generate}

\item{burnin}{An integer object. Optional. The number of burn-in samples.
Used only for \code{type = "trace"}. One trace plot is generated for
the burnin iterations; a second for the post-burnin iterations. Note, this
refers to the number of kept (thinned) samples.}

\item{max_age}{A numeric object. For \code{type = "hazard"}, the maximum
age at which to evaluate the hazard.}

\item{trace_var}{A character object. The parameter for which trace plots
are to be generated. Must be one of \{"psi", "rate_H", "rate_P", "beta"\}}
}
\value{
A gg object
}
\description{
Convenience function to facilitate exploration of posterior distributions through
  trace plots, autocorrelations, and densities, as well as plotting the 
  estimated hazard for transitioning to the preclinical compartment.
}
\examples{
data(screen_data)

theta_0 <- list("rate_H" = 7e-4, "shape_H" = 2.0,
                "rate_P" = 0.5  , "shape_P" = 1.0,
                "beta" = 0.9, psi = 0.4)
prior <- list("rate_H" = 0.01, "shape_H" = 1,
              "rate_P" = 0.01, "shape_P" = 1,
              "a_psi" = 1/2 , "b_psi" = 1/2,
              "a_beta" = 38.5, "b_beta" = 5.8)

# This is for illustration only -- the number of Gibbs samples should be
# significantly larger and the epsilon values should be tuned.
example <- fit_baclava(data.assess = data.screen,
                       data.clinical = data.clinical,
                       t0 = 30.0,
                       theta_0 = theta_0,
                       prior = prior)
                       
plot(example)
plot(example, type = "trace", trace_var = "psi", burnin = 0L) 
plot(example, type = "trace", trace_var = "rate_H", burnin = 0L) 
plot(example, type = "trace", trace_var = "rate_P", burnin = 0L) 
plot(example, type = "trace", trace_var = "beta", burnin = 0L) 
plot(example, type = "acf")
plot(example, type = "hazard", max_age = 70)

}
