% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bage_mod-functions.R
\name{set_var_age}
\alias{set_var_age}
\title{Specify Age Variable}
\usage{
set_var_age(mod, name)
}
\arguments{
\item{mod}{An object of class \code{"bage_mod"},
created with \code{\link[=mod_pois]{mod_pois()}},
\code{\link[=mod_binom]{mod_binom()}}, or \code{\link[=mod_norm]{mod_norm()}}.}

\item{name}{The name of the age variable.}
}
\value{
A \code{bage_mod} object
}
\description{
Specify which variable (if any) represents age.
Functions \code{\link[=mod_pois]{mod_pois()}}, \code{\link[=mod_binom]{mod_binom()}},
and \code{\link[=mod_norm]{mod_norm()}} try to infer the age variable
from variable names, but do not always get it right.
}
\details{
In an R \code{\link{formula}}, a 'variable' is different
from a 'term'. For instance,

\code{~ age + region + age:region}

contains variables \code{age} and \code{region},
and terms \code{age}, \code{region}, and \code{age:region}.

By default, \strong{bage} gives a term involving age a
(\code{\link[=RW]{RW()}}) prior. Changing the age variable
via \code{set_var_age()} can change priors:
see below for an example.

If \code{set_var_age()} is applied to
a fitted model, it 'unfits'
the model, deleting existing estimates.
}
\examples{
## rename 'age' variable to something unusual
injuries2 <- injuries
injuries2$age_last_birthday <- injuries2$age

## mod_pois does not recognize age variable
mod <- mod_pois(injuries ~ age_last_birthday * ethnicity + year,
                data = injuries2,
                exposure = popn)
mod

## so we set the age variable explicitly
## (which, as a side effect, changes the prior on
## the age main effect)
mod |>
  set_var_age(name = "age_last_birthday")
}
\seealso{
\itemize{
\item \code{\link[=set_var_sexgender]{set_var_sexgender()}} Set sex or gender variable
\item \code{\link[=set_var_time]{set_var_time()}} Set time variable
\item \code{\link[=is_fitted]{is_fitted()}} Test whether a model is fitted
\item internally, \strong{bage} uses \code{\link[poputils:find_var_age]{poputils::find_var_age()}}
to locate age variables
}
}
