% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loocv.R
\name{loocv}
\alias{loocv}
\title{Leave one group out cross-validation for \code{baggr} models}
\usage{
loocv(data, return_models = FALSE, ...)
}
\arguments{
\item{data}{Input data frame - same as for \link{baggr} function.}

\item{return_models}{logical; if FALSE, summary statistics will be returned and the
models discarded;
if TRUE, a list of models will be returned alongside summaries}

\item{...}{Additional arguments passed to \link{baggr}.}
}
\value{
log predictive density value, an object of class \code{baggr_cv};
full model, prior values and \emph{lpd} of each model are also returned.
These can be examined by using \code{attributes()} function.
}
\description{
Performs exact leave-one-group-out cross-validation on a baggr model.
}
\details{
The values returned by \code{loocv()} can be used to understand how any
one group affects the overall result, as well as how well the model
predicts the omitted group.

This function automatically runs K baggr models, leaving out one group at a time,
and then calculates expected log predictive density (ELPD) for
that group (see Gelman et al 2013). The main output is the cross-validation
information criterion, or -2 times the ELPD averaged over 'K' models.
This is related to, and often approximated by, the Watanabe-Akaike
Information Criterion. A value closer to zero (i.e. a smaller number in magnitude)
means a better fit. For more information on cross-validation see
\href{http://www.stat.columbia.edu/~gelman/research/published/waic_understand3.pdf}{this overview article}

For running more computation-intensive models, consider setting the
\code{mc.cores} option before running loocv, e.g. \code{options(mc.cores = 4)}
(by default baggr runs 4 MCMC chains in parallel).
As a default, rstan runs "silently" (\code{refresh=0}).
To see sampling progress, please set e.g. \code{loocv(data, refresh = 500)}.
}
\examples{
\donttest{
# even simple examples may take a while
cv <- loocv(schools, pooling = "partial")
print(cv)      # returns the lpd value
attributes(cv) # more information is included in the object
}

}
\references{
Gelman, Andrew, Jessica Hwang, and Aki Vehtari.
“Understanding Predictive Information Criteria for Bayesian Models.”
Statistics and Computing 24, no. 6 (November 2014): 997–1016. https://doi.org/10.1007/s11222-013-9416-2.
}
\author{
Witold Wiecek
}
