% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fixed_effects.R
\name{fixed_effects}
\alias{fixed_effects}
\title{Effects of covariates on outcome in baggr models}
\usage{
fixed_effects(bg, summary = FALSE, transform = NULL, interval = 0.95)
}
\arguments{
\item{bg}{a \link{baggr} model}

\item{summary}{logical; if \code{TRUE} returns summary statistic instead of all MCMC samples}

\item{transform}{a transformation (R function) to apply to the result;
(this is commonly used when calling from other
plotting or printing functions)}

\item{interval}{uncertainty interval width (numeric between 0 and 1), if \code{summary=TRUE}}
}
\value{
A list with 2 vectors (corresponding to MCMC samples)
\code{tau} (mean effect) and \code{sigma_tau} (SD). If \code{summary=TRUE},
both vectors are summarised as mean and lower/upper bounds according to
\code{interval}
}
\description{
Effects of covariates on outcome in baggr models
}
\seealso{
\link{treatment_effect} for overall treatment effect across groups,
\link{group_effects} for effects within each group,
\link{effect_draw} and \link{effect_plot} for predicted treatment effect in new group
}
