% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binary_to_individual.R
\name{binary_to_individual}
\alias{binary_to_individual}
\title{Generate individual-level binary outcome data from an aggregate statistics}
\usage{
binary_to_individual(data, group = "group", rename_group = TRUE)
}
\arguments{
\item{data}{A data frame with columns \code{a}, \code{c} and \code{b}/\code{n1}, \code{d}/\code{n2}.
(You can also use \code{ai}, \code{ci}, \code{n1i}, \code{n2i} instead.)}

\item{group}{Column name storing group}

\item{rename_group}{If \code{TRUE} (default), this will rename the grouping variable
to \code{"group"}, making it easier to work with \link{baggr}

See \code{vignette("baggr_binary")} for an example of use and notation details.}
}
\value{
A data frame with columns \code{group}, \code{outcome} and \code{treatment}.
}
\description{
This is a helper function that is typically used automatically by some of \emph{baggr} functions,
such as when running \code{model="logit"} in \link{baggr}, when summary-level data are supplied.
}
\examples{
df_yusuf <- read.table(text="
  trial        a n1i  c n2i
  Balcon      14  56 15  58
  Clausen     18  66 19  64
  Multicentre 15 100 12  95
  Barber      10  52 12  47
  Norris      21 226 24 228
  Kahler       3  38  6  31
  Ledwich      2  20  3  20
  ", header=TRUE)
bti <- binary_to_individual(df_yusuf, group = "trial")
head(bti)
# to go back to summary-level data
prepare_ma(bti, effect = "logOR")
# the last operation is equivalent to simply doing
prepare_ma(df_yusuf, group="trial", effect="logOR")

}
\seealso{
\link{prepare_ma} uses this function
}
