// Generated by rstantools.  Do not edit by hand.

/*
    baggr is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    baggr is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with baggr.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#ifndef USE_STANC3
#define USE_STANC3
#endif
#include <rstan/rstaninc.hpp>
// Code generated by stanc v2.32.2
#include <stan/model/model_header.hpp>
namespace model_mutau_namespace {
using stan::model::model_base_crtp;
using namespace stan::math;
stan::math::profile_map profiles__;
static constexpr std::array<const char*, 114> locations_array__ =
  {" (found before start of program)",
  " (in 'string', line 48, column 2 to column 40)",
  " (in 'string', line 49, column 2 to column 59)",
  " (in 'string', line 50, column 2 to column 54)",
  " (in 'string', line 51, column 2 to column 43)",
  " (in 'string', line 54, column 2 to column 47)",
  " (in 'string', line 55, column 2 to column 43)",
  " (in 'string', line 104, column 2 to column 31)",
  " (in 'string', line 57, column 4 to column 24)",
  " (in 'string', line 56, column 2 to line 57, column 24)",
  " (in 'string', line 64, column 4 to column 55)",
  " (in 'string', line 68, column 6 to column 74)",
  " (in 'string', line 66, column 6 to column 58)",
  " (in 'string', line 65, column 4 to line 68, column 74)",
  " (in 'string', line 58, column 23 to line 69, column 3)",
  " (in 'string', line 58, column 2 to line 69, column 3)",
  " (in 'string', line 106, column 4 to column 17)",
  " (in 'string', line 110, column 8 to line 111, column 78)",
  " (in 'string', line 109, column 8 to line 111, column 78)",
  " (in 'string', line 113, column 8 to line 114, column 62)",
  " (in 'string', line 112, column 8 to line 114, column 62)",
  " (in 'string', line 108, column 20 to line 115, column 7)",
  " (in 'string', line 108, column 6 to line 115, column 7)",
  " (in 'string', line 107, column 22 to line 116, column 5)",
  " (in 'string', line 107, column 4 to line 116, column 5)",
  " (in 'string', line 105, column 17 to line 117, column 3)",
  " (in 'string', line 105, column 2 to line 117, column 3)",
  " (in 'string', line 81, column 6 to column 77)",
  " (in 'string', line 80, column 4 to line 81, column 77)",
  " (in 'string', line 79, column 9 to line 82, column 3)",
  " (in 'string', line 78, column 6 to column 72)",
  " (in 'string', line 77, column 4 to line 78, column 72)",
  " (in 'string', line 76, column 24 to line 79, column 3)",
  " (in 'string', line 76, column 2 to line 82, column 3)",
  " (in 'string', line 85, column 4 to column 37)",
  " (in 'string', line 87, column 6 to column 70)",
  " (in 'string', line 86, column 4 to line 87, column 70)",
  " (in 'string', line 89, column 4 to column 55)",
  " (in 'string', line 84, column 24 to line 90, column 3)",
  " (in 'string', line 84, column 2 to line 90, column 3)",
  " (in 'string', line 95, column 8 to column 68)",
  " (in 'string', line 94, column 6 to line 95, column 68)",
  " (in 'string', line 92, column 19 to line 96, column 5)",
  " (in 'string', line 92, column 4 to line 96, column 5)",
  " (in 'string', line 91, column 33 to line 97, column 3)",
  " (in 'string', line 91, column 2 to line 97, column 3)",
  " (in 'string', line 101, column 8 to column 61)",
  " (in 'string', line 100, column 6 to line 101, column 61)",
  " (in 'string', line 99, column 4 to line 101, column 61)",
  " (in 'string', line 98, column 2 to line 101, column 61)",
  " (in 'string', line 24, column 2 to column 17)",
  " (in 'string', line 25, column 2 to column 17)",
  " (in 'string', line 26, column 8 to column 9)",
  " (in 'string', line 26, column 10 to column 11)",
  " (in 'string', line 26, column 2 to column 30)",
  " (in 'string', line 27, column 8 to column 9)",
  " (in 'string', line 27, column 10 to column 11)",
  " (in 'string', line 27, column 2 to column 38)",
  " (in 'string', line 28, column 2 to column 19)",
  " (in 'string', line 29, column 2 to column 31)",
  " (in 'string', line 32, column 2 to column 26)",
  " (in 'string', line 33, column 9 to column 10)",
  " (in 'string', line 33, column 2 to column 33)",
  " (in 'string', line 34, column 18 to column 19)",
  " (in 'string', line 34, column 21 to column 22)",
  " (in 'string', line 34, column 2 to column 46)",
  " (in 'string', line 35, column 2 to column 24)",
  " (in 'string', line 36, column 2 to column 30)",
  " (in 'string', line 37, column 2 to column 25)",
  " (in 'string', line 38, column 2 to column 26)",
  " (in 'string', line 40, column 2 to column 22)",
  " (in 'string', line 41, column 8 to column 9)",
  " (in 'string', line 41, column 10 to column 16)",
  " (in 'string', line 41, column 2 to column 40)",
  " (in 'string', line 42, column 8 to column 9)",
  " (in 'string', line 42, column 10 to column 16)",
  " (in 'string', line 42, column 2 to column 48)",
  " (in 'string', line 45, column 2 to column 43)",
  " (in 'string', line 48, column 8 to column 25)",
  " (in 'string', line 48, column 34 to column 35)",
  " (in 'string', line 49, column 8 to column 25)",
  " (in 'string', line 49, column 48 to column 49)",
  " (in 'string', line 50, column 8 to column 25)",
  " (in 'string', line 50, column 43 to column 44)",
  " (in 'string', line 51, column 8 to column 25)",
  " (in 'string', line 51, column 34 to column 35)",
  " (in 'string', line 51, column 36 to column 37)",
  " (in 'string', line 54, column 8 to column 25)",
  " (in 'string', line 54, column 34 to column 35)",
  " (in 'string', line 54, column 36 to column 37)",
  " (in 'string', line 55, column 8 to column 25)",
  " (in 'string', line 55, column 34 to column 35)",
  " (in 'string', line 55, column 36 to column 37)",
  " (in 'string', line 104, column 8 to column 18)",
  " (in 'string', line 11, column 9 to column 66)",
  " (in 'string', line 9, column 25 to column 73)",
  " (in 'string', line 9, column 9 to line 11, column 66)",
  " (in 'string', line 6, column 25 to column 70)",
  " (in 'string', line 6, column 9 to line 11, column 66)",
  " (in 'string', line 5, column 25 to column 70)",
  " (in 'string', line 5, column 9 to line 11, column 66)",
  " (in 'string', line 4, column 20 to column 66)",
  " (in 'string', line 4, column 4 to line 11, column 66)",
  " (in 'string', line 3, column 60 to line 12, column 3)",
  " (in 'string', line 20, column 9 to column 66)",
  " (in 'string', line 18, column 25 to column 73)",
  " (in 'string', line 18, column 9 to line 20, column 66)",
  " (in 'string', line 17, column 25 to column 70)",
  " (in 'string', line 17, column 9 to line 20, column 66)",
  " (in 'string', line 16, column 25 to column 70)",
  " (in 'string', line 16, column 9 to line 20, column 66)",
  " (in 'string', line 15, column 20 to column 66)",
  " (in 'string', line 15, column 4 to line 20, column 66)",
  " (in 'string', line 14, column 61 to line 21, column 3)"};
template <bool propto__, typename T0__, typename T2__,
          stan::require_all_t<stan::is_stan_scalar<T0__>,
                              stan::is_col_vector<T2__>,
                              stan::is_vt_not_complex<T2__>>* = nullptr>
stan::promote_args_t<T0__, stan::base_type_t<T2__>>
realprior_lpdf(const T0__& theta, const int& family, const T2__& pars_arg__,
               std::ostream* pstream__);
template <bool propto__, typename T0__, typename T2__,
          stan::require_all_t<stan::is_col_vector<T0__>,
                              stan::is_vt_not_complex<T0__>,
                              stan::is_col_vector<T2__>,
                              stan::is_vt_not_complex<T2__>>* = nullptr>
stan::promote_args_t<stan::base_type_t<T0__>, stan::base_type_t<T2__>>
vecprior_lpdf(const T0__& theta_arg__, const int& family, const T2__&
              pars_arg__, std::ostream* pstream__);
template <bool propto__, typename T0__, typename T2__,
          stan::require_all_t<stan::is_stan_scalar<T0__>,
                              stan::is_col_vector<T2__>,
                              stan::is_vt_not_complex<T2__>>*>
stan::promote_args_t<T0__, stan::base_type_t<T2__>>
realprior_lpdf(const T0__& theta, const int& family, const T2__& pars_arg__,
               std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<T0__,
                             stan::base_type_t<T2__>>;
  int current_statement__ = 0;
  const auto& pars = stan::math::to_ref(pars_arg__);
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  // suppress unused var warning
  (void) DUMMY_VAR__;
  try {
    current_statement__ = 102;
    if (stan::math::logical_eq(family, 0)) {
      current_statement__ = 101;
      return stan::math::uniform_lpdf<false>(theta,
               stan::model::rvalue(pars, "pars", stan::model::index_uni(1)),
               stan::model::rvalue(pars, "pars", stan::model::index_uni(2)));
    } else {
      current_statement__ = 100;
      if (stan::math::logical_eq(family, 1)) {
        current_statement__ = 99;
        return stan::math::normal_lpdf<false>(theta,
                 stan::model::rvalue(pars, "pars", stan::model::index_uni(1)),
                 stan::model::rvalue(pars, "pars", stan::model::index_uni(2)));
      } else {
        current_statement__ = 98;
        if (stan::math::logical_eq(family, 2)) {
          current_statement__ = 97;
          return stan::math::cauchy_lpdf<false>(theta,
                   stan::model::rvalue(pars, "pars",
                     stan::model::index_uni(1)),
                   stan::model::rvalue(pars, "pars",
                     stan::model::index_uni(2)));
        } else {
          current_statement__ = 96;
          if (stan::math::logical_eq(family, 5)) {
            current_statement__ = 95;
            return stan::math::lognormal_lpdf<false>(theta,
                     stan::model::rvalue(pars, "pars",
                       stan::model::index_uni(1)),
                     stan::model::rvalue(pars, "pars",
                       stan::model::index_uni(2)));
          } else {
            current_statement__ = 94;
            return stan::math::student_t_lpdf<false>(theta,
                     stan::model::rvalue(pars, "pars",
                       stan::model::index_uni(1)),
                     stan::model::rvalue(pars, "pars",
                       stan::model::index_uni(2)),
                     stan::model::rvalue(pars, "pars",
                       stan::model::index_uni(3)));
          }
        }
      }
    }
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
  }
}
template <bool propto__, typename T0__, typename T2__,
          stan::require_all_t<stan::is_col_vector<T0__>,
                              stan::is_vt_not_complex<T0__>,
                              stan::is_col_vector<T2__>,
                              stan::is_vt_not_complex<T2__>>*>
stan::promote_args_t<stan::base_type_t<T0__>, stan::base_type_t<T2__>>
vecprior_lpdf(const T0__& theta_arg__, const int& family, const T2__&
              pars_arg__, std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<stan::base_type_t<T0__>,
                             stan::base_type_t<T2__>>;
  int current_statement__ = 0;
  const auto& theta = stan::math::to_ref(theta_arg__);
  const auto& pars = stan::math::to_ref(pars_arg__);
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  // suppress unused var warning
  (void) DUMMY_VAR__;
  try {
    current_statement__ = 112;
    if (stan::math::logical_eq(family, 0)) {
      current_statement__ = 111;
      return stan::math::uniform_lpdf<false>(theta,
               stan::model::rvalue(pars, "pars", stan::model::index_uni(1)),
               stan::model::rvalue(pars, "pars", stan::model::index_uni(2)));
    } else {
      current_statement__ = 110;
      if (stan::math::logical_eq(family, 1)) {
        current_statement__ = 109;
        return stan::math::normal_lpdf<false>(theta,
                 stan::model::rvalue(pars, "pars", stan::model::index_uni(1)),
                 stan::model::rvalue(pars, "pars", stan::model::index_uni(2)));
      } else {
        current_statement__ = 108;
        if (stan::math::logical_eq(family, 2)) {
          current_statement__ = 107;
          return stan::math::cauchy_lpdf<false>(theta,
                   stan::model::rvalue(pars, "pars",
                     stan::model::index_uni(1)),
                   stan::model::rvalue(pars, "pars",
                     stan::model::index_uni(2)));
        } else {
          current_statement__ = 106;
          if (stan::math::logical_eq(family, 5)) {
            current_statement__ = 105;
            return stan::math::lognormal_lpdf<false>(theta,
                     stan::model::rvalue(pars, "pars",
                       stan::model::index_uni(1)),
                     stan::model::rvalue(pars, "pars",
                       stan::model::index_uni(2)));
          } else {
            current_statement__ = 104;
            return stan::math::student_t_lpdf<false>(theta,
                     stan::model::rvalue(pars, "pars",
                       stan::model::index_uni(1)),
                     stan::model::rvalue(pars, "pars",
                       stan::model::index_uni(2)),
                     stan::model::rvalue(pars, "pars",
                       stan::model::index_uni(3)));
          }
        }
      }
    }
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
  }
}
#include <stan_meta_header.hpp>
class model_mutau final : public model_base_crtp<model_mutau> {
private:
  int K;
  int P;
  std::vector<std::vector<double>> theta_hat_k;
  std::vector<std::vector<double>> se_theta_k;
  int pooling_type;
  int cumsum;
  int prior_hypermean_fam;
  Eigen::Matrix<double,-1,1> prior_hypermean_mean_data__;
  Eigen::Matrix<double,-1,-1> prior_hypermean_scale_data__;
  int prior_hypersd_fam;
  Eigen::Matrix<double,-1,1> prior_hypersd_val_data__;
  int prior_hypercor_fam;
  double prior_hypercor_val;
  int K_test;
  std::vector<std::vector<double>> test_theta_hat_k;
  std::vector<std::vector<double>> test_se_theta_k;
  int K_pooled;
  int mu_1dim__;
  int L_Omega_1dim__;
  int hypersd_1dim__;
  int eta_1dim__;
  int theta_k_1dim__;
  int tau_1dim__;
  int logpd_1dim__;
  Eigen::Map<Eigen::Matrix<double,-1,1>> prior_hypermean_mean{nullptr, 0};
  Eigen::Map<Eigen::Matrix<double,-1,-1>>
    prior_hypermean_scale{nullptr, 0, 0};
  Eigen::Map<Eigen::Matrix<double,-1,1>> prior_hypersd_val{nullptr, 0};
public:
  ~model_mutau() {}
  model_mutau(stan::io::var_context& context__, unsigned int
              random_seed__ = 0, std::ostream* pstream__ = nullptr)
      : model_base_crtp(0) {
    int current_statement__ = 0;
    using local_scalar_t__ = double;
    boost::ecuyer1988 base_rng__ =
      stan::services::util::create_rng(random_seed__, 0);
    // suppress unused var warning
    (void) base_rng__;
    static constexpr const char* function__ =
      "model_mutau_namespace::model_mutau";
    // suppress unused var warning
    (void) function__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      current_statement__ = 50;
      context__.validate_dims("data initialization", "K", "int",
        std::vector<size_t>{});
      K = std::numeric_limits<int>::min();
      current_statement__ = 50;
      K = context__.vals_i("K")[(1 - 1)];
      current_statement__ = 50;
      stan::math::check_greater_or_equal(function__, "K", K, 0);
      current_statement__ = 51;
      context__.validate_dims("data initialization", "P", "int",
        std::vector<size_t>{});
      P = std::numeric_limits<int>::min();
      current_statement__ = 51;
      P = context__.vals_i("P")[(1 - 1)];
      current_statement__ = 51;
      stan::math::check_greater_or_equal(function__, "P", P, 2);
      current_statement__ = 52;
      stan::math::validate_non_negative_index("theta_hat_k", "P", P);
      current_statement__ = 53;
      stan::math::validate_non_negative_index("theta_hat_k", "K", K);
      current_statement__ = 54;
      context__.validate_dims("data initialization", "theta_hat_k", "double",
        std::vector<size_t>{static_cast<size_t>(P), static_cast<size_t>(K)});
      theta_hat_k = std::vector<std::vector<double>>(P,
                      std::vector<double>(K,
                        std::numeric_limits<double>::quiet_NaN()));
      {
        std::vector<local_scalar_t__> theta_hat_k_flat__;
        current_statement__ = 54;
        theta_hat_k_flat__ = context__.vals_r("theta_hat_k");
        current_statement__ = 54;
        pos__ = 1;
        current_statement__ = 54;
        for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
          current_statement__ = 54;
          for (int sym2__ = 1; sym2__ <= P; ++sym2__) {
            current_statement__ = 54;
            stan::model::assign(theta_hat_k, theta_hat_k_flat__[(pos__ - 1)],
              "assigning variable theta_hat_k",
              stan::model::index_uni(sym2__), stan::model::index_uni(sym1__));
            current_statement__ = 54;
            pos__ = (pos__ + 1);
          }
        }
      }
      current_statement__ = 55;
      stan::math::validate_non_negative_index("se_theta_k", "P", P);
      current_statement__ = 56;
      stan::math::validate_non_negative_index("se_theta_k", "K", K);
      current_statement__ = 57;
      context__.validate_dims("data initialization", "se_theta_k", "double",
        std::vector<size_t>{static_cast<size_t>(P), static_cast<size_t>(K)});
      se_theta_k = std::vector<std::vector<double>>(P,
                     std::vector<double>(K,
                       std::numeric_limits<double>::quiet_NaN()));
      {
        std::vector<local_scalar_t__> se_theta_k_flat__;
        current_statement__ = 57;
        se_theta_k_flat__ = context__.vals_r("se_theta_k");
        current_statement__ = 57;
        pos__ = 1;
        current_statement__ = 57;
        for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
          current_statement__ = 57;
          for (int sym2__ = 1; sym2__ <= P; ++sym2__) {
            current_statement__ = 57;
            stan::model::assign(se_theta_k, se_theta_k_flat__[(pos__ - 1)],
              "assigning variable se_theta_k",
              stan::model::index_uni(sym2__), stan::model::index_uni(sym1__));
            current_statement__ = 57;
            pos__ = (pos__ + 1);
          }
        }
      }
      current_statement__ = 57;
      stan::math::check_greater_or_equal(function__, "se_theta_k",
        se_theta_k, 0);
      current_statement__ = 58;
      context__.validate_dims("data initialization", "pooling_type", "int",
        std::vector<size_t>{});
      pooling_type = std::numeric_limits<int>::min();
      current_statement__ = 58;
      pooling_type = context__.vals_i("pooling_type")[(1 - 1)];
      current_statement__ = 59;
      context__.validate_dims("data initialization", "cumsum", "int",
        std::vector<size_t>{});
      cumsum = std::numeric_limits<int>::min();
      current_statement__ = 59;
      cumsum = context__.vals_i("cumsum")[(1 - 1)];
      current_statement__ = 59;
      stan::math::check_greater_or_equal(function__, "cumsum", cumsum, 0);
      current_statement__ = 59;
      stan::math::check_less_or_equal(function__, "cumsum", cumsum, 1);
      current_statement__ = 60;
      context__.validate_dims("data initialization", "prior_hypermean_fam",
        "int", std::vector<size_t>{});
      prior_hypermean_fam = std::numeric_limits<int>::min();
      current_statement__ = 60;
      prior_hypermean_fam = context__.vals_i("prior_hypermean_fam")[(1 - 1)];
      current_statement__ = 61;
      stan::math::validate_non_negative_index("prior_hypermean_mean", "P", P);
      current_statement__ = 62;
      context__.validate_dims("data initialization", "prior_hypermean_mean",
        "double", std::vector<size_t>{static_cast<size_t>(P)});
      prior_hypermean_mean_data__ = Eigen::Matrix<double,-1,1>::Constant(P,
                                      std::numeric_limits<double>::quiet_NaN());
      new (&prior_hypermean_mean)
        Eigen::Map<Eigen::Matrix<double,-1,1>>(prior_hypermean_mean_data__.data(),
        P);
      {
        std::vector<local_scalar_t__> prior_hypermean_mean_flat__;
        current_statement__ = 62;
        prior_hypermean_mean_flat__ = context__.vals_r("prior_hypermean_mean");
        current_statement__ = 62;
        pos__ = 1;
        current_statement__ = 62;
        for (int sym1__ = 1; sym1__ <= P; ++sym1__) {
          current_statement__ = 62;
          stan::model::assign(prior_hypermean_mean,
            prior_hypermean_mean_flat__[(pos__ - 1)],
            "assigning variable prior_hypermean_mean",
            stan::model::index_uni(sym1__));
          current_statement__ = 62;
          pos__ = (pos__ + 1);
        }
      }
      current_statement__ = 63;
      stan::math::validate_non_negative_index("prior_hypermean_scale", "P", P);
      current_statement__ = 64;
      stan::math::validate_non_negative_index("prior_hypermean_scale", "P", P);
      current_statement__ = 65;
      context__.validate_dims("data initialization", "prior_hypermean_scale",
        "double",
        std::vector<size_t>{static_cast<size_t>(P), static_cast<size_t>(P)});
      prior_hypermean_scale_data__ = Eigen::Matrix<double,-1,-1>::Constant(P,
                                       P,
                                       std::numeric_limits<double>::quiet_NaN());
      new (&prior_hypermean_scale)
        Eigen::Map<Eigen::Matrix<double,-1,-1>>(prior_hypermean_scale_data__.data(),
        P, P);
      {
        std::vector<local_scalar_t__> prior_hypermean_scale_flat__;
        current_statement__ = 65;
        prior_hypermean_scale_flat__ = context__.vals_r("prior_hypermean_scale");
        current_statement__ = 65;
        pos__ = 1;
        current_statement__ = 65;
        for (int sym1__ = 1; sym1__ <= P; ++sym1__) {
          current_statement__ = 65;
          for (int sym2__ = 1; sym2__ <= P; ++sym2__) {
            current_statement__ = 65;
            stan::model::assign(prior_hypermean_scale,
              prior_hypermean_scale_flat__[(pos__ - 1)],
              "assigning variable prior_hypermean_scale",
              stan::model::index_uni(sym2__), stan::model::index_uni(sym1__));
            current_statement__ = 65;
            pos__ = (pos__ + 1);
          }
        }
      }
      current_statement__ = 65;
      stan::math::check_greater_or_equal(function__, "prior_hypermean_scale",
        prior_hypermean_scale, 0);
      current_statement__ = 66;
      context__.validate_dims("data initialization", "prior_hypersd_fam",
        "int", std::vector<size_t>{});
      prior_hypersd_fam = std::numeric_limits<int>::min();
      current_statement__ = 66;
      prior_hypersd_fam = context__.vals_i("prior_hypersd_fam")[(1 - 1)];
      current_statement__ = 67;
      context__.validate_dims("data initialization", "prior_hypersd_val",
        "double", std::vector<size_t>{static_cast<size_t>(3)});
      prior_hypersd_val_data__ = Eigen::Matrix<double,-1,1>::Constant(3,
                                   std::numeric_limits<double>::quiet_NaN());
      new (&prior_hypersd_val)
        Eigen::Map<Eigen::Matrix<double,-1,1>>(prior_hypersd_val_data__.data(),
        3);
      {
        std::vector<local_scalar_t__> prior_hypersd_val_flat__;
        current_statement__ = 67;
        prior_hypersd_val_flat__ = context__.vals_r("prior_hypersd_val");
        current_statement__ = 67;
        pos__ = 1;
        current_statement__ = 67;
        for (int sym1__ = 1; sym1__ <= 3; ++sym1__) {
          current_statement__ = 67;
          stan::model::assign(prior_hypersd_val,
            prior_hypersd_val_flat__[(pos__ - 1)],
            "assigning variable prior_hypersd_val",
            stan::model::index_uni(sym1__));
          current_statement__ = 67;
          pos__ = (pos__ + 1);
        }
      }
      current_statement__ = 68;
      context__.validate_dims("data initialization", "prior_hypercor_fam",
        "int", std::vector<size_t>{});
      prior_hypercor_fam = std::numeric_limits<int>::min();
      current_statement__ = 68;
      prior_hypercor_fam = context__.vals_i("prior_hypercor_fam")[(1 - 1)];
      current_statement__ = 69;
      context__.validate_dims("data initialization", "prior_hypercor_val",
        "double", std::vector<size_t>{});
      prior_hypercor_val = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 69;
      prior_hypercor_val = context__.vals_r("prior_hypercor_val")[(1 - 1)];
      current_statement__ = 70;
      context__.validate_dims("data initialization", "K_test", "int",
        std::vector<size_t>{});
      K_test = std::numeric_limits<int>::min();
      current_statement__ = 70;
      K_test = context__.vals_i("K_test")[(1 - 1)];
      current_statement__ = 70;
      stan::math::check_greater_or_equal(function__, "K_test", K_test, 0);
      current_statement__ = 71;
      stan::math::validate_non_negative_index("test_theta_hat_k", "P", P);
      current_statement__ = 72;
      stan::math::validate_non_negative_index("test_theta_hat_k", "K_test",
        K_test);
      current_statement__ = 73;
      context__.validate_dims("data initialization", "test_theta_hat_k",
        "double",
        std::vector<size_t>{static_cast<size_t>(P),
          static_cast<size_t>(K_test)});
      test_theta_hat_k = std::vector<std::vector<double>>(P,
                           std::vector<double>(K_test,
                             std::numeric_limits<double>::quiet_NaN()));
      {
        std::vector<local_scalar_t__> test_theta_hat_k_flat__;
        current_statement__ = 73;
        test_theta_hat_k_flat__ = context__.vals_r("test_theta_hat_k");
        current_statement__ = 73;
        pos__ = 1;
        current_statement__ = 73;
        for (int sym1__ = 1; sym1__ <= K_test; ++sym1__) {
          current_statement__ = 73;
          for (int sym2__ = 1; sym2__ <= P; ++sym2__) {
            current_statement__ = 73;
            stan::model::assign(test_theta_hat_k,
              test_theta_hat_k_flat__[(pos__ - 1)],
              "assigning variable test_theta_hat_k",
              stan::model::index_uni(sym2__), stan::model::index_uni(sym1__));
            current_statement__ = 73;
            pos__ = (pos__ + 1);
          }
        }
      }
      current_statement__ = 74;
      stan::math::validate_non_negative_index("test_se_theta_k", "P", P);
      current_statement__ = 75;
      stan::math::validate_non_negative_index("test_se_theta_k", "K_test",
        K_test);
      current_statement__ = 76;
      context__.validate_dims("data initialization", "test_se_theta_k",
        "double",
        std::vector<size_t>{static_cast<size_t>(P),
          static_cast<size_t>(K_test)});
      test_se_theta_k = std::vector<std::vector<double>>(P,
                          std::vector<double>(K_test,
                            std::numeric_limits<double>::quiet_NaN()));
      {
        std::vector<local_scalar_t__> test_se_theta_k_flat__;
        current_statement__ = 76;
        test_se_theta_k_flat__ = context__.vals_r("test_se_theta_k");
        current_statement__ = 76;
        pos__ = 1;
        current_statement__ = 76;
        for (int sym1__ = 1; sym1__ <= K_test; ++sym1__) {
          current_statement__ = 76;
          for (int sym2__ = 1; sym2__ <= P; ++sym2__) {
            current_statement__ = 76;
            stan::model::assign(test_se_theta_k,
              test_se_theta_k_flat__[(pos__ - 1)],
              "assigning variable test_se_theta_k",
              stan::model::index_uni(sym2__), stan::model::index_uni(sym1__));
            current_statement__ = 76;
            pos__ = (pos__ + 1);
          }
        }
      }
      current_statement__ = 76;
      stan::math::check_greater_or_equal(function__, "test_se_theta_k",
        test_se_theta_k, 0);
      current_statement__ = 77;
      K_pooled = std::numeric_limits<int>::min();
      current_statement__ = 77;
      K_pooled = (stan::math::logical_eq(pooling_type, 2) ? 0 : K);
      current_statement__ = 78;
      mu_1dim__ = std::numeric_limits<int>::min();
      current_statement__ = 78;
      mu_1dim__ = stan::math::logical_neq(pooling_type, 0);
      current_statement__ = 78;
      stan::math::validate_non_negative_index("mu", "pooling_type != 0",
        mu_1dim__);
      current_statement__ = 79;
      stan::math::validate_non_negative_index("mu", "P", P);
      current_statement__ = 80;
      L_Omega_1dim__ = std::numeric_limits<int>::min();
      current_statement__ = 80;
      L_Omega_1dim__ = stan::math::logical_eq(pooling_type, 1);
      current_statement__ = 80;
      stan::math::validate_non_negative_index("L_Omega", "pooling_type == 1",
        L_Omega_1dim__);
      current_statement__ = 81;
      stan::math::validate_non_negative_index("L_Omega", "P", P);
      current_statement__ = 81;
      stan::math::validate_non_negative_index("L_Omega", "P", P);
      current_statement__ = 82;
      hypersd_1dim__ = std::numeric_limits<int>::min();
      current_statement__ = 82;
      hypersd_1dim__ = stan::math::logical_eq(pooling_type, 1);
      current_statement__ = 82;
      stan::math::validate_non_negative_index("hypersd", "pooling_type == 1",
        hypersd_1dim__);
      current_statement__ = 83;
      stan::math::validate_non_negative_index("hypersd", "P", P);
      current_statement__ = 84;
      eta_1dim__ = std::numeric_limits<int>::min();
      current_statement__ = 84;
      eta_1dim__ = stan::math::logical_neq(pooling_type, 2);
      current_statement__ = 84;
      stan::math::validate_non_negative_index("eta", "pooling_type != 2",
        eta_1dim__);
      current_statement__ = 85;
      stan::math::validate_non_negative_index("eta", "P", P);
      current_statement__ = 86;
      stan::math::validate_non_negative_index("eta", "K", K);
      current_statement__ = 87;
      theta_k_1dim__ = std::numeric_limits<int>::min();
      current_statement__ = 87;
      theta_k_1dim__ = stan::math::logical_neq(pooling_type, 2);
      current_statement__ = 87;
      stan::math::validate_non_negative_index("theta_k", "pooling_type != 2",
        theta_k_1dim__);
      current_statement__ = 88;
      stan::math::validate_non_negative_index("theta_k", "P", P);
      current_statement__ = 89;
      stan::math::validate_non_negative_index("theta_k", "K", K);
      current_statement__ = 90;
      tau_1dim__ = std::numeric_limits<int>::min();
      current_statement__ = 90;
      tau_1dim__ = stan::math::logical_eq(pooling_type, 1);
      current_statement__ = 90;
      stan::math::validate_non_negative_index("tau", "pooling_type == 1",
        tau_1dim__);
      current_statement__ = 91;
      stan::math::validate_non_negative_index("tau", "P", P);
      current_statement__ = 92;
      stan::math::validate_non_negative_index("tau", "P", P);
      current_statement__ = 93;
      logpd_1dim__ = std::numeric_limits<int>::min();
      current_statement__ = 93;
      logpd_1dim__ = stan::math::logical_gt(K_test, 0);
      current_statement__ = 93;
      stan::math::validate_non_negative_index("logpd", "K_test > 0",
        logpd_1dim__);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
    num_params_r__ = (mu_1dim__ * P) + (L_Omega_1dim__ * ((P * (P - 1)) / 2))
      + (hypersd_1dim__ * P) + (eta_1dim__ * P * K);
  }
  inline std::string model_name() const final {
    return "model_mutau";
  }
  inline std::vector<std::string> model_compile_info() const noexcept {
    return std::vector<std::string>{"stanc_version = stanc3 v2.32.2",
             "stancflags = --allow-undefined"};
  }
  template <bool propto__, bool jacobian__, typename VecR, typename VecI,
            stan::require_vector_like_t<VecR>* = nullptr,
            stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline stan::scalar_type_t<VecR>
  log_prob_impl(VecR& params_r__, VecI& params_i__, std::ostream*
                pstream__ = nullptr) const {
    using T__ = stan::scalar_type_t<VecR>;
    using local_scalar_t__ = T__;
    T__ lp__(0.0);
    stan::math::accumulator<T__> lp_accum__;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    static constexpr const char* function__ =
      "model_mutau_namespace::log_prob";
    // suppress unused var warning
    (void) function__;
    try {
      std::vector<Eigen::Matrix<local_scalar_t__,-1,1>> mu =
        std::vector<Eigen::Matrix<local_scalar_t__,-1,1>>(mu_1dim__,
          Eigen::Matrix<local_scalar_t__,-1,1>::Constant(P, DUMMY_VAR__));
      current_statement__ = 1;
      mu = in__.template read<
             std::vector<Eigen::Matrix<local_scalar_t__,-1,1>>>(mu_1dim__, P);
      std::vector<Eigen::Matrix<local_scalar_t__,-1,-1>> L_Omega =
        std::vector<Eigen::Matrix<local_scalar_t__,-1,-1>>(L_Omega_1dim__,
          Eigen::Matrix<local_scalar_t__,-1,-1>::Constant(P, P, DUMMY_VAR__));
      current_statement__ = 2;
      L_Omega = in__.template read_constrain_cholesky_factor_corr<
                  std::vector<Eigen::Matrix<local_scalar_t__,-1,-1>>,
                  jacobian__>(lp__, L_Omega_1dim__, P);
      std::vector<Eigen::Matrix<local_scalar_t__,-1,1>> hypersd =
        std::vector<Eigen::Matrix<local_scalar_t__,-1,1>>(hypersd_1dim__,
          Eigen::Matrix<local_scalar_t__,-1,1>::Constant(P, DUMMY_VAR__));
      current_statement__ = 3;
      hypersd = in__.template read_constrain_lb<
                  std::vector<Eigen::Matrix<local_scalar_t__,-1,1>>,
                  jacobian__>(0, lp__, hypersd_1dim__, P);
      std::vector<Eigen::Matrix<local_scalar_t__,-1,-1>> eta =
        std::vector<Eigen::Matrix<local_scalar_t__,-1,-1>>(eta_1dim__,
          Eigen::Matrix<local_scalar_t__,-1,-1>::Constant(P, K, DUMMY_VAR__));
      current_statement__ = 4;
      eta = in__.template read<
              std::vector<Eigen::Matrix<local_scalar_t__,-1,-1>>>(eta_1dim__,
              P, K);
      std::vector<Eigen::Matrix<local_scalar_t__,-1,-1>> theta_k =
        std::vector<Eigen::Matrix<local_scalar_t__,-1,-1>>(theta_k_1dim__,
          Eigen::Matrix<local_scalar_t__,-1,-1>::Constant(P, K, DUMMY_VAR__));
      std::vector<Eigen::Matrix<local_scalar_t__,-1,-1>> tau =
        std::vector<Eigen::Matrix<local_scalar_t__,-1,-1>>(tau_1dim__,
          Eigen::Matrix<local_scalar_t__,-1,-1>::Constant(P, P, DUMMY_VAR__));
      current_statement__ = 9;
      if (stan::math::logical_eq(pooling_type, 0)) {
        current_statement__ = 8;
        stan::model::assign(theta_k,
          stan::model::rvalue(eta, "eta", stan::model::index_uni(1)),
          "assigning variable theta_k", stan::model::index_uni(1));
      }
      current_statement__ = 15;
      if (stan::math::logical_eq(pooling_type, 1)) {
        current_statement__ = 10;
        stan::model::assign(tau,
          stan::math::diag_pre_multiply(
            stan::model::rvalue(hypersd, "hypersd", stan::model::index_uni(1)),
            stan::model::rvalue(L_Omega, "L_Omega", stan::model::index_uni(1))),
          "assigning variable tau", stan::model::index_uni(1));
        current_statement__ = 13;
        if (stan::math::logical_eq(cumsum, 1)) {
          current_statement__ = 12;
          stan::model::assign(theta_k,
            stan::math::add(
              stan::math::rep_matrix(
                stan::model::rvalue(mu, "mu", stan::model::index_uni(1)), K),
              stan::math::multiply(
                stan::model::rvalue(tau, "tau", stan::model::index_uni(1)),
                stan::model::rvalue(eta, "eta", stan::model::index_uni(1)))),
            "assigning variable theta_k", stan::model::index_uni(1));
        } else {
          current_statement__ = 11;
          stan::model::assign(theta_k,
            stan::math::add(
              stan::math::rep_matrix(
                stan::math::cumulative_sum(
                  stan::model::rvalue(mu, "mu", stan::model::index_uni(1))),
                K),
              stan::math::multiply(
                stan::model::rvalue(tau, "tau", stan::model::index_uni(1)),
                stan::model::rvalue(eta, "eta", stan::model::index_uni(1)))),
            "assigning variable theta_k", stan::model::index_uni(1));
        }
      }
      {
        current_statement__ = 33;
        if (stan::math::logical_neq(pooling_type, 0)) {
          current_statement__ = 31;
          if (stan::math::logical_eq(prior_hypermean_fam, 3)) {
            current_statement__ = 30;
            lp_accum__.add(stan::math::multi_normal_lpdf<propto__>(
                             stan::model::rvalue(mu, "mu",
                               stan::model::index_uni(1)),
                             prior_hypermean_mean, prior_hypermean_scale));
          }
        } else {
          current_statement__ = 28;
          for (int k = 1; k <= K; ++k) {
            current_statement__ = 27;
            lp_accum__.add(stan::math::multi_normal_lpdf<propto__>(
                             stan::model::rvalue(
                               stan::model::rvalue(eta, "eta",
                                 stan::model::index_uni(1)), "eta[1]",
                               stan::model::index_omni(),
                               stan::model::index_uni(k)),
                             prior_hypermean_mean, prior_hypermean_scale));
          }
        }
        current_statement__ = 39;
        if (stan::math::logical_eq(pooling_type, 1)) {
          current_statement__ = 34;
          lp_accum__.add(stan::math::std_normal_lpdf<propto__>(
                           stan::math::to_vector(
                             stan::model::rvalue(eta, "eta",
                               stan::model::index_uni(1)))));
          current_statement__ = 36;
          for (int p = 1; p <= P; ++p) {
            current_statement__ = 35;
            lp_accum__.add(realprior_lpdf<propto__>(
                             stan::model::rvalue(
                               stan::model::rvalue(hypersd, "hypersd",
                                 stan::model::index_uni(1)), "hypersd[1]",
                               stan::model::index_uni(p)), prior_hypersd_fam,
                             prior_hypersd_val, pstream__));
          }
          current_statement__ = 37;
          lp_accum__.add(stan::math::lkj_corr_cholesky_lpdf<propto__>(
                           stan::model::rvalue(L_Omega, "L_Omega",
                             stan::model::index_uni(1)), prior_hypercor_val));
        }
        current_statement__ = 45;
        if ((stan::math::primitive_value(
               stan::math::logical_eq(pooling_type, 1))
            && stan::math::primitive_value(stan::math::logical_gt(K, 0)))) {
          current_statement__ = 43;
          for (int k = 1; k <= K; ++k) {
            current_statement__ = 41;
            for (int p = 1; p <= P; ++p) {
              current_statement__ = 40;
              lp_accum__.add(stan::math::normal_lpdf<propto__>(
                               stan::model::rvalue(theta_hat_k,
                                 "theta_hat_k", stan::model::index_uni(p),
                                 stan::model::index_uni(k)),
                               stan::model::rvalue(
                                 stan::model::rvalue(theta_k, "theta_k",
                                   stan::model::index_uni(1)), "theta_k[1]",
                                 stan::model::index_uni(p),
                                 stan::model::index_uni(k)),
                               stan::model::rvalue(se_theta_k, "se_theta_k",
                                 stan::model::index_uni(p),
                                 stan::model::index_uni(k))));
            }
          }
        }
        current_statement__ = 49;
        if ((stan::math::primitive_value(
               stan::math::logical_eq(pooling_type, 2))
            && stan::math::primitive_value(stan::math::logical_gt(K, 0)))) {
          current_statement__ = 48;
          for (int k = 1; k <= K; ++k) {
            current_statement__ = 47;
            for (int p = 1; p <= P; ++p) {
              current_statement__ = 46;
              lp_accum__.add(stan::math::normal_lpdf<propto__>(
                               stan::model::rvalue(theta_hat_k,
                                 "theta_hat_k", stan::model::index_uni(p),
                                 stan::model::index_uni(k)),
                               stan::model::rvalue(
                                 stan::model::rvalue(mu, "mu",
                                   stan::model::index_uni(1)), "mu[1]",
                                 stan::model::index_uni(p)),
                               stan::model::rvalue(se_theta_k, "se_theta_k",
                                 stan::model::index_uni(p),
                                 stan::model::index_uni(k))));
            }
          }
        }
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
    lp_accum__.add(lp__);
    return lp_accum__.sum();
  }
  template <typename RNG, typename VecR, typename VecI, typename VecVar,
            stan::require_vector_like_vt<std::is_floating_point,
            VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral,
            VecI>* = nullptr, stan::require_vector_vt<std::is_floating_point,
            VecVar>* = nullptr>
  inline void
  write_array_impl(RNG& base_rng__, VecR& params_r__, VecI& params_i__,
                   VecVar& vars__, const bool
                   emit_transformed_parameters__ = true, const bool
                   emit_generated_quantities__ = true, std::ostream*
                   pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    stan::io::serializer<local_scalar_t__> out__(vars__);
    static constexpr bool propto__ = true;
    // suppress unused var warning
    (void) propto__;
    double lp__ = 0.0;
    // suppress unused var warning
    (void) lp__;
    int current_statement__ = 0;
    stan::math::accumulator<double> lp_accum__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    constexpr bool jacobian__ = false;
    static constexpr const char* function__ =
      "model_mutau_namespace::write_array";
    // suppress unused var warning
    (void) function__;
    try {
      std::vector<Eigen::Matrix<double,-1,1>> mu =
        std::vector<Eigen::Matrix<double,-1,1>>(mu_1dim__,
          Eigen::Matrix<double,-1,1>::Constant(P,
            std::numeric_limits<double>::quiet_NaN()));
      current_statement__ = 1;
      mu = in__.template read<
             std::vector<Eigen::Matrix<local_scalar_t__,-1,1>>>(mu_1dim__, P);
      std::vector<Eigen::Matrix<double,-1,-1>> L_Omega =
        std::vector<Eigen::Matrix<double,-1,-1>>(L_Omega_1dim__,
          Eigen::Matrix<double,-1,-1>::Constant(P, P,
            std::numeric_limits<double>::quiet_NaN()));
      current_statement__ = 2;
      L_Omega = in__.template read_constrain_cholesky_factor_corr<
                  std::vector<Eigen::Matrix<local_scalar_t__,-1,-1>>,
                  jacobian__>(lp__, L_Omega_1dim__, P);
      std::vector<Eigen::Matrix<double,-1,1>> hypersd =
        std::vector<Eigen::Matrix<double,-1,1>>(hypersd_1dim__,
          Eigen::Matrix<double,-1,1>::Constant(P,
            std::numeric_limits<double>::quiet_NaN()));
      current_statement__ = 3;
      hypersd = in__.template read_constrain_lb<
                  std::vector<Eigen::Matrix<local_scalar_t__,-1,1>>,
                  jacobian__>(0, lp__, hypersd_1dim__, P);
      std::vector<Eigen::Matrix<double,-1,-1>> eta =
        std::vector<Eigen::Matrix<double,-1,-1>>(eta_1dim__,
          Eigen::Matrix<double,-1,-1>::Constant(P, K,
            std::numeric_limits<double>::quiet_NaN()));
      current_statement__ = 4;
      eta = in__.template read<
              std::vector<Eigen::Matrix<local_scalar_t__,-1,-1>>>(eta_1dim__,
              P, K);
      std::vector<Eigen::Matrix<double,-1,-1>> theta_k =
        std::vector<Eigen::Matrix<double,-1,-1>>(theta_k_1dim__,
          Eigen::Matrix<double,-1,-1>::Constant(P, K,
            std::numeric_limits<double>::quiet_NaN()));
      std::vector<Eigen::Matrix<double,-1,-1>> tau =
        std::vector<Eigen::Matrix<double,-1,-1>>(tau_1dim__,
          Eigen::Matrix<double,-1,-1>::Constant(P, P,
            std::numeric_limits<double>::quiet_NaN()));
      for (int sym1__ = 1; sym1__ <= P; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= mu_1dim__; ++sym2__) {
          out__.write(mu[(sym2__ - 1)][(sym1__ - 1)]);
        }
      }
      for (int sym1__ = 1; sym1__ <= P; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= P; ++sym2__) {
          for (int sym3__ = 1; sym3__ <= L_Omega_1dim__; ++sym3__) {
            out__.write(stan::model::rvalue(L_Omega, "L_Omega",
                          stan::model::index_uni(sym3__),
                          stan::model::index_uni(sym2__),
                          stan::model::index_uni(sym1__)));
          }
        }
      }
      for (int sym1__ = 1; sym1__ <= P; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= hypersd_1dim__; ++sym2__) {
          out__.write(hypersd[(sym2__ - 1)][(sym1__ - 1)]);
        }
      }
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= P; ++sym2__) {
          for (int sym3__ = 1; sym3__ <= eta_1dim__; ++sym3__) {
            out__.write(stan::model::rvalue(eta, "eta",
                          stan::model::index_uni(sym3__),
                          stan::model::index_uni(sym2__),
                          stan::model::index_uni(sym1__)));
          }
        }
      }
      if (stan::math::logical_negation(
            (stan::math::primitive_value(emit_transformed_parameters__) ||
            stan::math::primitive_value(emit_generated_quantities__)))) {
        return ;
      }
      current_statement__ = 9;
      if (stan::math::logical_eq(pooling_type, 0)) {
        current_statement__ = 8;
        stan::model::assign(theta_k,
          stan::model::rvalue(eta, "eta", stan::model::index_uni(1)),
          "assigning variable theta_k", stan::model::index_uni(1));
      }
      current_statement__ = 15;
      if (stan::math::logical_eq(pooling_type, 1)) {
        current_statement__ = 10;
        stan::model::assign(tau,
          stan::math::diag_pre_multiply(
            stan::model::rvalue(hypersd, "hypersd", stan::model::index_uni(1)),
            stan::model::rvalue(L_Omega, "L_Omega", stan::model::index_uni(1))),
          "assigning variable tau", stan::model::index_uni(1));
        current_statement__ = 13;
        if (stan::math::logical_eq(cumsum, 1)) {
          current_statement__ = 12;
          stan::model::assign(theta_k,
            stan::math::add(
              stan::math::rep_matrix(
                stan::model::rvalue(mu, "mu", stan::model::index_uni(1)), K),
              stan::math::multiply(
                stan::model::rvalue(tau, "tau", stan::model::index_uni(1)),
                stan::model::rvalue(eta, "eta", stan::model::index_uni(1)))),
            "assigning variable theta_k", stan::model::index_uni(1));
        } else {
          current_statement__ = 11;
          stan::model::assign(theta_k,
            stan::math::add(
              stan::math::rep_matrix(
                stan::math::cumulative_sum(
                  stan::model::rvalue(mu, "mu", stan::model::index_uni(1))),
                K),
              stan::math::multiply(
                stan::model::rvalue(tau, "tau", stan::model::index_uni(1)),
                stan::model::rvalue(eta, "eta", stan::model::index_uni(1)))),
            "assigning variable theta_k", stan::model::index_uni(1));
        }
      }
      if (emit_transformed_parameters__) {
        for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
          for (int sym2__ = 1; sym2__ <= P; ++sym2__) {
            for (int sym3__ = 1; sym3__ <= theta_k_1dim__; ++sym3__) {
              out__.write(stan::model::rvalue(theta_k, "theta_k",
                            stan::model::index_uni(sym3__),
                            stan::model::index_uni(sym2__),
                            stan::model::index_uni(sym1__)));
            }
          }
        }
        for (int sym1__ = 1; sym1__ <= P; ++sym1__) {
          for (int sym2__ = 1; sym2__ <= P; ++sym2__) {
            for (int sym3__ = 1; sym3__ <= tau_1dim__; ++sym3__) {
              out__.write(stan::model::rvalue(tau, "tau",
                            stan::model::index_uni(sym3__),
                            stan::model::index_uni(sym2__),
                            stan::model::index_uni(sym1__)));
            }
          }
        }
      }
      if (stan::math::logical_negation(emit_generated_quantities__)) {
        return ;
      }
      std::vector<double> logpd =
        std::vector<double>(logpd_1dim__,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 26;
      if (stan::math::logical_gt(K_test, 0)) {
        current_statement__ = 16;
        stan::model::assign(logpd, 0, "assigning variable logpd",
          stan::model::index_uni(1));
        current_statement__ = 24;
        for (int k = 1; k <= K_test; ++k) {
          current_statement__ = 22;
          for (int p = 1; p <= P; ++p) {
            current_statement__ = 18;
            if (stan::math::logical_eq(pooling_type, 1)) {
              current_statement__ = 17;
              stan::model::assign(logpd,
                (stan::model::rvalue(logpd, "logpd",
                   stan::model::index_uni(1)) +
                stan::math::normal_lpdf<false>(
                  stan::model::rvalue(test_theta_hat_k, "test_theta_hat_k",
                    stan::model::index_uni(p), stan::model::index_uni(k)),
                  stan::model::rvalue(mu, "mu", stan::model::index_uni(1)),
                  stan::math::sqrt(
                    (stan::math::pow(
                       stan::model::rvalue(
                         stan::model::rvalue(tau, "tau",
                           stan::model::index_uni(1)), "tau[1]",
                         stan::model::index_uni(p), stan::model::index_uni(p)),
                       2) +
                    stan::math::pow(
                      stan::model::rvalue(test_se_theta_k, "test_se_theta_k",
                        stan::model::index_uni(p), stan::model::index_uni(k)),
                      2))))), "assigning variable logpd",
                stan::model::index_uni(1));
            }
            current_statement__ = 20;
            if (stan::math::logical_eq(pooling_type, 2)) {
              current_statement__ = 19;
              stan::model::assign(logpd,
                (stan::model::rvalue(logpd, "logpd",
                   stan::model::index_uni(1)) +
                stan::math::normal_lpdf<false>(
                  stan::model::rvalue(test_theta_hat_k, "test_theta_hat_k",
                    stan::model::index_uni(p), stan::model::index_uni(k)),
                  stan::model::rvalue(mu, "mu", stan::model::index_uni(1)),
                  stan::math::sqrt(
                    stan::math::pow(
                      stan::model::rvalue(test_se_theta_k, "test_se_theta_k",
                        stan::model::index_uni(p), stan::model::index_uni(k)),
                      2)))), "assigning variable logpd",
                stan::model::index_uni(1));
            }
          }
        }
      }
      out__.write(logpd);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  template <typename VecVar, typename VecI,
            stan::require_vector_t<VecVar>* = nullptr,
            stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline void
  unconstrain_array_impl(const VecVar& params_r__, const VecI& params_i__,
                         VecVar& vars__, std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    stan::io::serializer<local_scalar_t__> out__(vars__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      std::vector<Eigen::Matrix<local_scalar_t__,-1,1>> mu =
        std::vector<Eigen::Matrix<local_scalar_t__,-1,1>>(mu_1dim__,
          Eigen::Matrix<local_scalar_t__,-1,1>::Constant(P, DUMMY_VAR__));
      current_statement__ = 1;
      for (int sym1__ = 1; sym1__ <= P; ++sym1__) {
        current_statement__ = 1;
        for (int sym2__ = 1; sym2__ <= mu_1dim__; ++sym2__) {
          current_statement__ = 1;
          stan::model::assign(mu, in__.read<local_scalar_t__>(),
            "assigning variable mu", stan::model::index_uni(sym2__),
            stan::model::index_uni(sym1__));
        }
      }
      out__.write(mu);
      std::vector<Eigen::Matrix<local_scalar_t__,-1,-1>> L_Omega =
        std::vector<Eigen::Matrix<local_scalar_t__,-1,-1>>(L_Omega_1dim__,
          Eigen::Matrix<local_scalar_t__,-1,-1>::Constant(P, P, DUMMY_VAR__));
      current_statement__ = 2;
      for (int sym1__ = 1; sym1__ <= P; ++sym1__) {
        current_statement__ = 2;
        for (int sym2__ = 1; sym2__ <= P; ++sym2__) {
          current_statement__ = 2;
          for (int sym3__ = 1; sym3__ <= L_Omega_1dim__; ++sym3__) {
            current_statement__ = 2;
            stan::model::assign(L_Omega, in__.read<local_scalar_t__>(),
              "assigning variable L_Omega", stan::model::index_uni(sym3__),
              stan::model::index_uni(sym2__), stan::model::index_uni(sym1__));
          }
        }
      }
      out__.write_free_cholesky_factor_corr(L_Omega);
      std::vector<Eigen::Matrix<local_scalar_t__,-1,1>> hypersd =
        std::vector<Eigen::Matrix<local_scalar_t__,-1,1>>(hypersd_1dim__,
          Eigen::Matrix<local_scalar_t__,-1,1>::Constant(P, DUMMY_VAR__));
      current_statement__ = 3;
      for (int sym1__ = 1; sym1__ <= P; ++sym1__) {
        current_statement__ = 3;
        for (int sym2__ = 1; sym2__ <= hypersd_1dim__; ++sym2__) {
          current_statement__ = 3;
          stan::model::assign(hypersd, in__.read<local_scalar_t__>(),
            "assigning variable hypersd", stan::model::index_uni(sym2__),
            stan::model::index_uni(sym1__));
        }
      }
      out__.write_free_lb(0, hypersd);
      std::vector<Eigen::Matrix<local_scalar_t__,-1,-1>> eta =
        std::vector<Eigen::Matrix<local_scalar_t__,-1,-1>>(eta_1dim__,
          Eigen::Matrix<local_scalar_t__,-1,-1>::Constant(P, K, DUMMY_VAR__));
      current_statement__ = 4;
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        current_statement__ = 4;
        for (int sym2__ = 1; sym2__ <= P; ++sym2__) {
          current_statement__ = 4;
          for (int sym3__ = 1; sym3__ <= eta_1dim__; ++sym3__) {
            current_statement__ = 4;
            stan::model::assign(eta, in__.read<local_scalar_t__>(),
              "assigning variable eta", stan::model::index_uni(sym3__),
              stan::model::index_uni(sym2__), stan::model::index_uni(sym1__));
          }
        }
      }
      out__.write(eta);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  template <typename VecVar, stan::require_vector_t<VecVar>* = nullptr>
  inline void
  transform_inits_impl(const stan::io::var_context& context__, VecVar&
                       vars__, std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::serializer<local_scalar_t__> out__(vars__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      current_statement__ = 1;
      context__.validate_dims("parameter initialization", "mu", "double",
        std::vector<size_t>{static_cast<size_t>(mu_1dim__),
          static_cast<size_t>(P)});
      current_statement__ = 2;
      context__.validate_dims("parameter initialization", "L_Omega",
        "double",
        std::vector<size_t>{static_cast<size_t>(L_Omega_1dim__),
          static_cast<size_t>(P), static_cast<size_t>(P)});
      current_statement__ = 3;
      context__.validate_dims("parameter initialization", "hypersd",
        "double",
        std::vector<size_t>{static_cast<size_t>(hypersd_1dim__),
          static_cast<size_t>(P)});
      current_statement__ = 4;
      context__.validate_dims("parameter initialization", "eta", "double",
        std::vector<size_t>{static_cast<size_t>(eta_1dim__),
          static_cast<size_t>(P), static_cast<size_t>(K)});
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      std::vector<Eigen::Matrix<local_scalar_t__,-1,1>> mu =
        std::vector<Eigen::Matrix<local_scalar_t__,-1,1>>(mu_1dim__,
          Eigen::Matrix<local_scalar_t__,-1,1>::Constant(P, DUMMY_VAR__));
      {
        std::vector<local_scalar_t__> mu_flat__;
        current_statement__ = 1;
        mu_flat__ = context__.vals_r("mu");
        current_statement__ = 1;
        pos__ = 1;
        current_statement__ = 1;
        for (int sym1__ = 1; sym1__ <= P; ++sym1__) {
          current_statement__ = 1;
          for (int sym2__ = 1; sym2__ <= mu_1dim__; ++sym2__) {
            current_statement__ = 1;
            stan::model::assign(mu, mu_flat__[(pos__ - 1)],
              "assigning variable mu", stan::model::index_uni(sym2__),
              stan::model::index_uni(sym1__));
            current_statement__ = 1;
            pos__ = (pos__ + 1);
          }
        }
      }
      out__.write(mu);
      std::vector<Eigen::Matrix<local_scalar_t__,-1,-1>> L_Omega =
        std::vector<Eigen::Matrix<local_scalar_t__,-1,-1>>(L_Omega_1dim__,
          Eigen::Matrix<local_scalar_t__,-1,-1>::Constant(P, P, DUMMY_VAR__));
      {
        std::vector<local_scalar_t__> L_Omega_flat__;
        current_statement__ = 2;
        L_Omega_flat__ = context__.vals_r("L_Omega");
        current_statement__ = 2;
        pos__ = 1;
        current_statement__ = 2;
        for (int sym1__ = 1; sym1__ <= P; ++sym1__) {
          current_statement__ = 2;
          for (int sym2__ = 1; sym2__ <= P; ++sym2__) {
            current_statement__ = 2;
            for (int sym3__ = 1; sym3__ <= L_Omega_1dim__; ++sym3__) {
              current_statement__ = 2;
              stan::model::assign(L_Omega, L_Omega_flat__[(pos__ - 1)],
                "assigning variable L_Omega", stan::model::index_uni(sym3__),
                stan::model::index_uni(sym2__),
                stan::model::index_uni(sym1__));
              current_statement__ = 2;
              pos__ = (pos__ + 1);
            }
          }
        }
      }
      out__.write_free_cholesky_factor_corr(L_Omega);
      std::vector<Eigen::Matrix<local_scalar_t__,-1,1>> hypersd =
        std::vector<Eigen::Matrix<local_scalar_t__,-1,1>>(hypersd_1dim__,
          Eigen::Matrix<local_scalar_t__,-1,1>::Constant(P, DUMMY_VAR__));
      {
        std::vector<local_scalar_t__> hypersd_flat__;
        current_statement__ = 3;
        hypersd_flat__ = context__.vals_r("hypersd");
        current_statement__ = 3;
        pos__ = 1;
        current_statement__ = 3;
        for (int sym1__ = 1; sym1__ <= P; ++sym1__) {
          current_statement__ = 3;
          for (int sym2__ = 1; sym2__ <= hypersd_1dim__; ++sym2__) {
            current_statement__ = 3;
            stan::model::assign(hypersd, hypersd_flat__[(pos__ - 1)],
              "assigning variable hypersd", stan::model::index_uni(sym2__),
              stan::model::index_uni(sym1__));
            current_statement__ = 3;
            pos__ = (pos__ + 1);
          }
        }
      }
      out__.write_free_lb(0, hypersd);
      std::vector<Eigen::Matrix<local_scalar_t__,-1,-1>> eta =
        std::vector<Eigen::Matrix<local_scalar_t__,-1,-1>>(eta_1dim__,
          Eigen::Matrix<local_scalar_t__,-1,-1>::Constant(P, K, DUMMY_VAR__));
      {
        std::vector<local_scalar_t__> eta_flat__;
        current_statement__ = 4;
        eta_flat__ = context__.vals_r("eta");
        current_statement__ = 4;
        pos__ = 1;
        current_statement__ = 4;
        for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
          current_statement__ = 4;
          for (int sym2__ = 1; sym2__ <= P; ++sym2__) {
            current_statement__ = 4;
            for (int sym3__ = 1; sym3__ <= eta_1dim__; ++sym3__) {
              current_statement__ = 4;
              stan::model::assign(eta, eta_flat__[(pos__ - 1)],
                "assigning variable eta", stan::model::index_uni(sym3__),
                stan::model::index_uni(sym2__),
                stan::model::index_uni(sym1__));
              current_statement__ = 4;
              pos__ = (pos__ + 1);
            }
          }
        }
      }
      out__.write(eta);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  inline void
  get_param_names(std::vector<std::string>& names__, const bool
                  emit_transformed_parameters__ = true, const bool
                  emit_generated_quantities__ = true) const {
    names__ = std::vector<std::string>{"mu", "L_Omega", "hypersd", "eta"};
    if (emit_transformed_parameters__) {
      std::vector<std::string> temp{"theta_k", "tau"};
      names__.reserve(names__.size() + temp.size());
      names__.insert(names__.end(), temp.begin(), temp.end());
    }
    if (emit_generated_quantities__) {
      std::vector<std::string> temp{"logpd"};
      names__.reserve(names__.size() + temp.size());
      names__.insert(names__.end(), temp.begin(), temp.end());
    }
  }
  inline void
  get_dims(std::vector<std::vector<size_t>>& dimss__, const bool
           emit_transformed_parameters__ = true, const bool
           emit_generated_quantities__ = true) const {
    dimss__ = std::vector<std::vector<size_t>>{std::vector<size_t>{static_cast<
                                                                    size_t>(
                                                                    mu_1dim__),
                                                 static_cast<size_t>(P)},
                std::vector<size_t>{static_cast<size_t>(L_Omega_1dim__),
                  static_cast<size_t>(P), static_cast<size_t>(P)},
                std::vector<size_t>{static_cast<size_t>(hypersd_1dim__),
                  static_cast<size_t>(P)},
                std::vector<size_t>{static_cast<size_t>(eta_1dim__),
                  static_cast<size_t>(P), static_cast<size_t>(K)}};
    if (emit_transformed_parameters__) {
      std::vector<std::vector<size_t>>
        temp{std::vector<size_t>{static_cast<size_t>(theta_k_1dim__),
               static_cast<size_t>(P), static_cast<size_t>(K)},
             std::vector<size_t>{static_cast<size_t>(tau_1dim__),
               static_cast<size_t>(P), static_cast<size_t>(P)}};
      dimss__.reserve(dimss__.size() + temp.size());
      dimss__.insert(dimss__.end(), temp.begin(), temp.end());
    }
    if (emit_generated_quantities__) {
      std::vector<std::vector<size_t>>
        temp{std::vector<size_t>{static_cast<size_t>(logpd_1dim__)}};
      dimss__.reserve(dimss__.size() + temp.size());
      dimss__.insert(dimss__.end(), temp.begin(), temp.end());
    }
  }
  inline void
  constrained_param_names(std::vector<std::string>& param_names__, bool
                          emit_transformed_parameters__ = true, bool
                          emit_generated_quantities__ = true) const final {
    for (int sym1__ = 1; sym1__ <= P; ++sym1__) {
      for (int sym2__ = 1; sym2__ <= mu_1dim__; ++sym2__) {
        param_names__.emplace_back(std::string() + "mu" + '.' +
          std::to_string(sym2__) + '.' + std::to_string(sym1__));
      }
    }
    for (int sym1__ = 1; sym1__ <= P; ++sym1__) {
      for (int sym2__ = 1; sym2__ <= P; ++sym2__) {
        for (int sym3__ = 1; sym3__ <= L_Omega_1dim__; ++sym3__) {
          param_names__.emplace_back(std::string() + "L_Omega" + '.' +
            std::to_string(sym3__) + '.' + std::to_string(sym2__) + '.' +
            std::to_string(sym1__));
        }
      }
    }
    for (int sym1__ = 1; sym1__ <= P; ++sym1__) {
      for (int sym2__ = 1; sym2__ <= hypersd_1dim__; ++sym2__) {
        param_names__.emplace_back(std::string() + "hypersd" + '.' +
          std::to_string(sym2__) + '.' + std::to_string(sym1__));
      }
    }
    for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
      for (int sym2__ = 1; sym2__ <= P; ++sym2__) {
        for (int sym3__ = 1; sym3__ <= eta_1dim__; ++sym3__) {
          param_names__.emplace_back(std::string() + "eta" + '.' +
            std::to_string(sym3__) + '.' + std::to_string(sym2__) + '.' +
            std::to_string(sym1__));
        }
      }
    }
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= P; ++sym2__) {
          for (int sym3__ = 1; sym3__ <= theta_k_1dim__; ++sym3__) {
            param_names__.emplace_back(std::string() + "theta_k" + '.' +
              std::to_string(sym3__) + '.' + std::to_string(sym2__) + '.' +
              std::to_string(sym1__));
          }
        }
      }
      for (int sym1__ = 1; sym1__ <= P; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= P; ++sym2__) {
          for (int sym3__ = 1; sym3__ <= tau_1dim__; ++sym3__) {
            param_names__.emplace_back(std::string() + "tau" + '.' +
              std::to_string(sym3__) + '.' + std::to_string(sym2__) + '.' +
              std::to_string(sym1__));
          }
        }
      }
    }
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= logpd_1dim__; ++sym1__) {
        param_names__.emplace_back(std::string() + "logpd" + '.' +
          std::to_string(sym1__));
      }
    }
  }
  inline void
  unconstrained_param_names(std::vector<std::string>& param_names__, bool
                            emit_transformed_parameters__ = true, bool
                            emit_generated_quantities__ = true) const final {
    for (int sym1__ = 1; sym1__ <= P; ++sym1__) {
      for (int sym2__ = 1; sym2__ <= mu_1dim__; ++sym2__) {
        param_names__.emplace_back(std::string() + "mu" + '.' +
          std::to_string(sym2__) + '.' + std::to_string(sym1__));
      }
    }
    for (int sym1__ = 1; sym1__ <= ((P * (P - 1)) / 2); ++sym1__) {
      for (int sym2__ = 1; sym2__ <= L_Omega_1dim__; ++sym2__) {
        param_names__.emplace_back(std::string() + "L_Omega" + '.' +
          std::to_string(sym2__) + '.' + std::to_string(sym1__));
      }
    }
    for (int sym1__ = 1; sym1__ <= P; ++sym1__) {
      for (int sym2__ = 1; sym2__ <= hypersd_1dim__; ++sym2__) {
        param_names__.emplace_back(std::string() + "hypersd" + '.' +
          std::to_string(sym2__) + '.' + std::to_string(sym1__));
      }
    }
    for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
      for (int sym2__ = 1; sym2__ <= P; ++sym2__) {
        for (int sym3__ = 1; sym3__ <= eta_1dim__; ++sym3__) {
          param_names__.emplace_back(std::string() + "eta" + '.' +
            std::to_string(sym3__) + '.' + std::to_string(sym2__) + '.' +
            std::to_string(sym1__));
        }
      }
    }
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= P; ++sym2__) {
          for (int sym3__ = 1; sym3__ <= theta_k_1dim__; ++sym3__) {
            param_names__.emplace_back(std::string() + "theta_k" + '.' +
              std::to_string(sym3__) + '.' + std::to_string(sym2__) + '.' +
              std::to_string(sym1__));
          }
        }
      }
      for (int sym1__ = 1; sym1__ <= P; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= P; ++sym2__) {
          for (int sym3__ = 1; sym3__ <= tau_1dim__; ++sym3__) {
            param_names__.emplace_back(std::string() + "tau" + '.' +
              std::to_string(sym3__) + '.' + std::to_string(sym2__) + '.' +
              std::to_string(sym1__));
          }
        }
      }
    }
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= logpd_1dim__; ++sym1__) {
        param_names__.emplace_back(std::string() + "logpd" + '.' +
          std::to_string(sym1__));
      }
    }
  }
  inline std::string get_constrained_sizedtypes() const {
    return std::string("[{\"name\":\"mu\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(mu_1dim__) + ",\"element_type\":{\"name\":\"vector\",\"length\":" + std::to_string(P) + "}},\"block\":\"parameters\"},{\"name\":\"L_Omega\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(L_Omega_1dim__) + ",\"element_type\":{\"name\":\"matrix\",\"rows\":" + std::to_string(P) + ",\"cols\":" + std::to_string(P) + "}},\"block\":\"parameters\"},{\"name\":\"hypersd\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(hypersd_1dim__) + ",\"element_type\":{\"name\":\"vector\",\"length\":" + std::to_string(P) + "}},\"block\":\"parameters\"},{\"name\":\"eta\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(eta_1dim__) + ",\"element_type\":{\"name\":\"matrix\",\"rows\":" + std::to_string(P) + ",\"cols\":" + std::to_string(K) + "}},\"block\":\"parameters\"},{\"name\":\"theta_k\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(theta_k_1dim__) + ",\"element_type\":{\"name\":\"matrix\",\"rows\":" + std::to_string(P) + ",\"cols\":" + std::to_string(K) + "}},\"block\":\"transformed_parameters\"},{\"name\":\"tau\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(tau_1dim__) + ",\"element_type\":{\"name\":\"matrix\",\"rows\":" + std::to_string(P) + ",\"cols\":" + std::to_string(P) + "}},\"block\":\"transformed_parameters\"},{\"name\":\"logpd\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(logpd_1dim__) + ",\"element_type\":{\"name\":\"real\"}},\"block\":\"generated_quantities\"}]");
  }
  inline std::string get_unconstrained_sizedtypes() const {
    return std::string("[{\"name\":\"mu\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(mu_1dim__) + ",\"element_type\":{\"name\":\"vector\",\"length\":" + std::to_string(P) + "}},\"block\":\"parameters\"},{\"name\":\"L_Omega\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(L_Omega_1dim__) + ",\"element_type\":{\"name\":\"vector\",\"length\":" + std::to_string(((P * (P - 1)) /2)) + "}},\"block\":\"parameters\"},{\"name\":\"hypersd\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(hypersd_1dim__) + ",\"element_type\":{\"name\":\"vector\",\"length\":" + std::to_string(P) + "}},\"block\":\"parameters\"},{\"name\":\"eta\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(eta_1dim__) + ",\"element_type\":{\"name\":\"matrix\",\"rows\":" + std::to_string(P) + ",\"cols\":" + std::to_string(K) + "}},\"block\":\"parameters\"},{\"name\":\"theta_k\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(theta_k_1dim__) + ",\"element_type\":{\"name\":\"matrix\",\"rows\":" + std::to_string(P) + ",\"cols\":" + std::to_string(K) + "}},\"block\":\"transformed_parameters\"},{\"name\":\"tau\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(tau_1dim__) + ",\"element_type\":{\"name\":\"matrix\",\"rows\":" + std::to_string(P) + ",\"cols\":" + std::to_string(P) + "}},\"block\":\"transformed_parameters\"},{\"name\":\"logpd\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(logpd_1dim__) + ",\"element_type\":{\"name\":\"real\"}},\"block\":\"generated_quantities\"}]");
  }
  // Begin method overload boilerplate
  template <typename RNG> inline void
  write_array(RNG& base_rng, Eigen::Matrix<double,-1,1>& params_r,
              Eigen::Matrix<double,-1,1>& vars, const bool
              emit_transformed_parameters = true, const bool
              emit_generated_quantities = true, std::ostream*
              pstream = nullptr) const {
    const size_t num_params__ = ((((mu_1dim__ * P) + ((L_Omega_1dim__ * P) *
      P)) + (hypersd_1dim__ * P)) + ((eta_1dim__ * P) * K));
    const size_t num_transformed = emit_transformed_parameters *
      ((((theta_k_1dim__ * P) * K) + ((tau_1dim__ * P) * P)));
    const size_t num_gen_quantities = emit_generated_quantities *
      (logpd_1dim__);
    const size_t num_to_write = num_params__ + num_transformed +
      num_gen_quantities;
    std::vector<int> params_i;
    vars = Eigen::Matrix<double,-1,1>::Constant(num_to_write,
             std::numeric_limits<double>::quiet_NaN());
    write_array_impl(base_rng, params_r, params_i, vars,
      emit_transformed_parameters, emit_generated_quantities, pstream);
  }
  template <typename RNG> inline void
  write_array(RNG& base_rng, std::vector<double>& params_r, std::vector<int>&
              params_i, std::vector<double>& vars, bool
              emit_transformed_parameters = true, bool
              emit_generated_quantities = true, std::ostream*
              pstream = nullptr) const {
    const size_t num_params__ = ((((mu_1dim__ * P) + ((L_Omega_1dim__ * P) *
      P)) + (hypersd_1dim__ * P)) + ((eta_1dim__ * P) * K));
    const size_t num_transformed = emit_transformed_parameters *
      ((((theta_k_1dim__ * P) * K) + ((tau_1dim__ * P) * P)));
    const size_t num_gen_quantities = emit_generated_quantities *
      (logpd_1dim__);
    const size_t num_to_write = num_params__ + num_transformed +
      num_gen_quantities;
    vars = std::vector<double>(num_to_write,
             std::numeric_limits<double>::quiet_NaN());
    write_array_impl(base_rng, params_r, params_i, vars,
      emit_transformed_parameters, emit_generated_quantities, pstream);
  }
  template <bool propto__, bool jacobian__, typename T_> inline T_
  log_prob(Eigen::Matrix<T_,-1,1>& params_r, std::ostream* pstream = nullptr) const {
    Eigen::Matrix<int,-1,1> params_i;
    return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
  }
  template <bool propto__, bool jacobian__, typename T_> inline T_
  log_prob(std::vector<T_>& params_r, std::vector<int>& params_i,
           std::ostream* pstream = nullptr) const {
    return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
  }
  inline void
  transform_inits(const stan::io::var_context& context,
                  Eigen::Matrix<double,-1,1>& params_r, std::ostream*
                  pstream = nullptr) const final {
    std::vector<double> params_r_vec(params_r.size());
    std::vector<int> params_i;
    transform_inits(context, params_i, params_r_vec, pstream);
    params_r = Eigen::Map<Eigen::Matrix<double,-1,1>>(params_r_vec.data(),
                 params_r_vec.size());
  }
  inline void
  transform_inits(const stan::io::var_context& context, std::vector<int>&
                  params_i, std::vector<double>& vars, std::ostream*
                  pstream__ = nullptr) const {
    vars.resize(num_params_r__);
    transform_inits_impl(context, vars, pstream__);
  }
  inline void
  unconstrain_array(const std::vector<double>& params_constrained,
                    std::vector<double>& params_unconstrained, std::ostream*
                    pstream = nullptr) const {
    const std::vector<int> params_i;
    params_unconstrained = std::vector<double>(num_params_r__,
                             std::numeric_limits<double>::quiet_NaN());
    unconstrain_array_impl(params_constrained, params_i,
      params_unconstrained, pstream);
  }
  inline void
  unconstrain_array(const Eigen::Matrix<double,-1,1>& params_constrained,
                    Eigen::Matrix<double,-1,1>& params_unconstrained,
                    std::ostream* pstream = nullptr) const {
    const std::vector<int> params_i;
    params_unconstrained = Eigen::Matrix<double,-1,1>::Constant(num_params_r__,
                             std::numeric_limits<double>::quiet_NaN());
    unconstrain_array_impl(params_constrained, params_i,
      params_unconstrained, pstream);
  }
};
}
using stan_model = model_mutau_namespace::model_mutau;
#ifndef USING_R
// Boilerplate
stan::model::model_base&
new_model(stan::io::var_context& data_context, unsigned int seed,
          std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
stan::math::profile_map& get_stan_profile_data() {
  return model_mutau_namespace::profiles__;
}
#endif
#endif
