% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{filterCovariance}
\alias{filterCovariance}
\title{Compute the BAHC covariance matrix.}
\usage{
filterCovariance(x, k = 1, Nboot = 100)
}
\arguments{
\item{x}{A matrix: $x_{i,f}$ is feature $f$ of object $i$}

\item{k}{The order of filtering. $k=1$ corresponds to BAHC.}

\item{Nboot}{The number of bootstrap copies}
}
\value{
The BAHC-filtered correlation matrix of \code{x}.
}
\description{
Compute the BAHC covariance matrix.
}
\examples{
r=matrix(rnorm(1000),nrow=20)   # 20 objects, 50 features each
sigma=exp(runif(20))
rs=t(sigma \%*\% r) \%*\% sigma
Cov_bahc=filterCovariance(rs)
}
