% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bain_methods.R
\name{bain}
\alias{bain}
\title{Bayes factors for informative hypotheses}
\usage{
bain(x, hypothesis, fraction = 1, ...)
}
\arguments{
\item{x}{An R object containing the outcome of a statistical analysis.
Currently, the following objects can be processed: \code{lm()},
\code{t_test()}, \code{lavaan} objects created with the
\code{sem()}, \code{cfa()}, and \code{growth()} functions, and named
vector objects. See the vignette for elaborations.}

\item{hypothesis}{A character string containing the informative hypotheses
to evaluate. See the vignette for elaborations.}

\item{fraction}{A number representing the fraction of information
in the data used to construct the prior distribution.
The default value 1 denotes the
minimal fraction, 2 denotes twice the minimal fraction, etc. See the
vignette for elaborations.}

\item{...}{Additional arguments. See the vignette for elaborations.}
}
\value{
The main output resulting from analyses with \code{bain} are
Bayes factors and posterior model probabilities associated with the
hypotheses that are evaluated. See the \strong{tutorial} and the
\strong{vignette} for further elaborations.
}
\description{
\code{bain} is an acronym for "Bayesian informative hypotheses evaluation".
It uses the Bayes factor to evaluate hypotheses specified using equality and
inequality constraints among (linear combinations of) parameters in a wide
range of statistical models. A \strong{tutorial} by Hoijtink, Mulder, van Lissa,
and Gu (2018), was published in Psychological Methods.
The preprint of that tutorial is available on PsyArxiv
(\doi{10.31234/osf.io/v3shc}) or on the bain
website at
\url{https://informative-hypotheses.sites.uu.nl/software/bain/}
\strong{Users are
advised to read the tutorial AND the vignette that is provided
with this package before using} \code{bain}.
}
\examples{
# Evaluation of informative hypotheses for an ANOVA
# make a factor of variable site
sesamesim$site <- as.factor(sesamesim$site)
# execute an analysis of variance using lm() which, due to the -1, returns
# estimates of the means of postnumb per group
anov <- lm(postnumb~site-1,sesamesim)
# take a look at the estimated means and their names
coef(anov)
# set a seed value
set.seed(100)
# use the names to formulate and test hypotheses with bain
results <- bain(anov, "site1=site2=site3=site4=site5; site2>site5>site1>
site3>site4")
#
# SEE THE TUTORIAL AND VIGNETTE FOR MANY ADDITIONAL EXAMPLES


}
\references{
For a tutorial on this method, see:

Hoijtink, H., Mulder, J., van Lissa, C., & Gu, X. (2019). A tutorial on
testing hypotheses using the Bayes factor. \emph{Psychological methods, 24}(5),
539. \doi{10.31234/osf.io/v3shc}

For applications in structural equation modeling, see:

Van Lissa, C. J., Gu, X., Mulder, J., Rosseel, Y., Van Zundert, C., &
Hoijtink, H. (2021). Teacher’s corner: Evaluating informative hypotheses
using the Bayes factor in structural equation models.
\emph{Structural Equation Modeling: A Multidisciplinary Journal, 28}(2), 292-301.
\doi{10.1080/10705511.2020.1745644}.

For the statistical underpinnings, see:

Gu, Mulder, and Hoijtink (2018). Approximated adjusted fractional Bayes
factors: A general method for testing informative hypotheses.
\emph{British Journal of Mathematical and Statistical Psychology, 71}(2), 229-261.
\doi{10.1111/bmsp.12110}.

Hoijtink, H., Gu, X., & Mulder, J. (2019). Bayesian evaluation of informative
hypotheses for multiple populations.
\emph{British Journal of Mathematical and Statistical Psychology, 72}(2), 219-243.
\doi{10.1111/bmsp.12145}.

Hoijtink, H., Gu, X., Mulder, J., & Rosseel, Y. (2019). Computing Bayes
factors from data with missing values. \emph{Psychological Methods, 24}(2), 253.
\doi{10.31234/osf.io/q6h5w}
}
\author{
The main authors of the bain package are Xin Gu, Caspar
van Lissa, Herbert Hoijtink and Joris Mulder with smaller contributions
by Marlyne Bosman, Camiel van Zundert, and Fayette Klaassen.
Contact information can be found on the bain website at
\url{https://informative-hypotheses.sites.uu.nl/software/bain/}
}
