% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/object.coda.R
\name{object.coda.bairt}
\alias{object.coda.bairt}
\title{Creating an mcmc.list for coda package}
\usage{
\method{object.coda}{bairt}(mcmclist, parameter = "a", chain = 1,
  parts = NULL, ...)
}
\arguments{
\item{mcmclist}{A \emph{mcmc.2pnob} or \emph{mcmc.3pnob} class object.}

\item{parameter}{The parameter (a, b, c or theta) for graphing.}

\item{chain}{The parameter's chain that will be graphed.}

\item{parts}{Number of splits for MCMC chain.}

\item{...}{Further arguments.}
}
\value{
A \emph{mcmc.list} coda packet object.
}
\description{
The function \emph{object.coda} create a \emph{mcmc.list} object.
With this is possible to study the chain using the coda packet.
}
\details{
The function \emph{object.coda} create a \emph{mcmc.list} object of the
marginal chain selectionated. The marginal chain is splited in subchains
determined by \emph{parts}. The aim is represent parallel chains with
different starting values (Beguin & Glas, 2001, p. 547).
}
\examples{
# data for model
data("MathTest")

# Only for the first 500 examinees of the data MathTest
# Two-Parameter Normal Ogive Model
model2 <- mcmc.2pnob(MathTest[1:500,], iter = 400, burning = 100)

chain_a1 <- object.coda(model2, parameter = "a", chain = 1)
coda::gelman.plot(chain_a1)
coda::gelman.diag(chain_a1)
plot(chain_a1)

\donttest{
# For all examinees of the data MathTest
# Three-Parameter Normal Ogive Model
# selection of the prior for 5 response options
cprior <- select.c.prior(5)
model3 <- mcmc.3pnob(MathTest, iter = 3500, burning = 500,
                    c.prior = cprior, parts = 3)

chain_c1 <- object.coda(model3, parameter = "c", chain = 1)
coda::gelman.plot(chain_c1)
coda::gelman.diag(chain_c1)
plot(chain_c1)
}

## End(Not run)


}
\references{
A.A.  Beguin, A, A. & Glas, C.A.W. (2001). MCMC Estimation and Some
Model-Fit Analysis of Multidimensional IRT Models. Psychometrika,
66, 541-562.
}
\seealso{
\code{\link[coda]{as.mcmc.list}} and \code{\link[coda]{as.mcmc}}.
}
\author{
Javier Martínez
}
