% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-basic.R
\name{group_vector}
\alias{group_vector}
\title{group character vector by a regex pattern}
\usage{
group_vector(x, pattern = "\\\\w")
}
\arguments{
\item{x}{character vector}

\item{pattern}{regex pattern, '\\w' as default}
}
\value{
list
}
\description{
group character vector by a regex pattern
}
\examples{
v <- c(
  stringr::str_c("A", c(1, 2, 9, 10, 11, 12, 99, 101, 102)),
  stringr::str_c("B", c(1, 2, 9, 10, 21, 32, 99, 101, 102))
) \%>\% sample()

group_vector(v)

group_vector(v, pattern = "\\\\w\\\\d")

group_vector(v, pattern = "\\\\w(\\\\d)")

# unmatched part will alse be stored
group_vector(v, pattern = "\\\\d{2}")

}
