% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/plotcont.R
\name{plotcont}
\alias{plotcont}
\title{plotcont}
\usage{
plotcont(m, data, parametric.smooth = TRUE, level = c(0.5, 0.75, 0.95),
  link = "logit",
  title = paste("Predictive Posterior Contours (50\%, 75\% and 95\%)"))
}
\arguments{
\item{m}{The modelfit.}

\item{data}{The data frame used to fit the model.}

\item{parametric.smooth}{Indicates if the predictive curve is a parametric or non-parametric smoother}

\item{level}{credibility levels of the predictive curve}

\item{link}{The link function used to fit the model. Possible values are \emph{logit}, \emph{cloglog} \emph{probit}.}

\item{title}{Optional parameter for setting a title in the plot.}
}
\description{
This function plots the observe data in the ROC (Receiving Operating Charachteristics) space with the
posterior predictive contours. The predictive curves are approximated using a non-parametric smoother or with a parametric model. For the parametric model the current implementation supports only a logistic link function.
}
\examples{
## execute analysis
\dontrun{
data(glas)
glas.t <- glas[glas$marker == "Telomerase", 1:4]
glas.m1 <- metadiag(glas.t,
re = "normal",
link = "logit",
nr.burnin = 1000,
nr.iterations = 10000,
nr.chains = 4,
r2jags = TRUE)

plotcont(m = glas.m1, data = glas.t)
}
}
\seealso{
\code{\link{metadiag}}.
}
\keyword{file}

