% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotdata.R
\name{plotdata}
\alias{plotdata}
\title{Basic function to plot results of meta-analysis of diagnostic test data}
\usage{
plotdata(data, group = 1, x.lo = 0, x.up = 1, y.lo = 0, y.up = 1,
  alpha.p = 0.7, max.size = 15)
}
\arguments{
\item{data}{a data frame with at least 4 columns containing the true positives (tp),
number of patients with disease (n1), false positives (fp), number of patients without
disease (n2)}

\item{group}{a variable indicating a group factor}

\item{x.lo}{lower limit of the x-axis}

\item{x.up}{upper limit of the x-axis}

\item{y.lo}{lower limit of the y-axis}

\item{y.up}{upper limit of the y-axis}

\item{alpha.p}{transparency of the points}

\item{max.size}{scale parameter of the maximum size}
}
\description{
This function plots the true positive rates vs the false positive rates of each study included
in the meta-analysis. Study results are displayed by circles, the diameter of each circle is proportional
to the sample size of the study (or table). If subgroups are displayed each group is represented by
different colours. This function use the package \emph{ggplot2}.
}
\examples{

## execute analysis
\dontrun{

data(ct)
gr <- with(ct, factor(design,
                     labels = c("Retrospective study", "Prospective study")))

plotdata(ct,               # Data frame
        group = gr,       # Groupping variable
        y.lo = 0.75,      # Lower limit of y-axis
        x.up = 0.75,      # Upper limit of x-axis
        alpha.p = 0.5,    # Transparency of the balls
        max.size = 5)     # Scale the circles


data(glas)
plotdata(glas,                 # Data frame
        group = glas$marker,  # Groupping variable
        max.size = 5)         # Scale of circles


data(scheidler)
plotdata(scheidler, group = scheidler$test)


data(safdar05)
plotdata(safdar05)
plotdata(safdar05, group = safdar05$technique)

library(dplyr)
safdar05 \%>\% plotdata(group = safdar05$duration)


data(ep)
ep.gr <- with(ep, factor(d1,
ep.gr <- with(ep, factor(d1, labels = c("Prospective study", "Retrospective study")))


ep \%>\% plotdata(group = ep.gr)
ep \%>\% plotdata(group = factor(ep$nthres))


}


}

