% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/one_way_anova.R
\name{sim_pred_hanova1}
\alias{sim_pred_hanova1}
\title{Simulate from a one-way hierarchical ANOVA posterior predictive distribution}
\usage{
sim_pred_hanova1(theta_sim_vals, sim_vals, fac, nrep)
}
\arguments{
\item{theta_sim_vals}{A numeric matrix with \code{length(fac)} columns.
Each row of \code{theta_sim_vals} contains normal means simulated from
their posterior distribution.}

\item{sim_vals}{A numeric matrix with \code{length(fac)} columns.
Each row of \code{sim_vals} contains normal standard deviations \eqn{\sigma}
simulated from their posterior distribution.}

\item{fac}{The argument \code{fac} to \code{\link{hanova1}}, that is,
a vector of class \link{factor} indicating group membership.}

\item{nrep}{A numeric scalar.  The number of replications of the original
dataset simulated from the posterior predictive distribution.
If \code{nrep} is greater than \code{nrow(theta_sim_vals)} then
\code{nrep} is set equal to \code{nrow(theta_sim_vals)}.}
}
\value{
A numeric matrix with \code{nrep} columns.  Each column contains
  a draw from the posterior predictive distribution of the number of
  successes.
}
\description{
Simulates \code{nrep} draws from the posterior predictive distribution
of the one-way hierarchical ANOVA model described in \code{\link{hanova1}}.
This function is called within \code{\link{hanova1}} when the argument
\code{nrep} is supplied.
}
\examples{
RCP26_2 <- temp2[temp2$RCP == "rcp26", ]
temp_res <- hanova1(resp = RCP26_2[, 1], fac = RCP26_2[, 2])
sim_pred <- sim_pred_hanova1(temp_res$theta_sim_vals, temp_res$sim_vals,
                             RCP26_2[, 2], 50)
}
