% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subsampleDetections.R
\name{subsampleDetections}
\alias{subsampleDetections}
\title{Subsample Detections}
\usage{
subsampleDetections(data, n)
}
\arguments{
\item{data}{a detector data.frame or list of detector data.frames.}

\item{n}{a value giving the number (\code{n} >= 1) or 
fraction (\code{n} between 0 and 1) of detections per event per detector 
to select. Detections are randomly selected without replacement. 
If \code{n} is greater than the number of detections in an event, all 
detections for that event will be retained.}
}
\value{
a detector data.frame or list of detector data.frames with 
  no more than \code{n} detections per event per detector.
}
\description{
Extract a random subsample of detections for each event and 
  detector.
}
\examples{
data(train.data)

# initial number of detections per event per detector
sapply(train.data$detectors, function(x) table(x$event.id))

# select half of all detectors
detect.half <- subsampleDetections(train.data$detectors, 0.5)
sapply(detect.half, function(x) table(x$event.id))

# select 20 detections
detect.20 <- subsampleDetections(train.data$detectors, 20)
sapply(detect.20, function(x) table(x$event.id))

# select 10 detections fro 'ec' detector
ec.10 <- subsampleDetections(train.data$detectors$ec, 10)
table(ec.10$event.id)

}
\references{
Rankin, S., Archer, F., Keating, J. L., Oswald, J. N., 
  Oswald, M. , Curtis, A. and Barlow, J. (2017), Acoustic classification 
  of dolphins in the California Current using whistles, echolocation clicks, 
  and burst pulses. Marine Mammal Science 33:520-540. doi:10.1111/mms.12381
}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}
