% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bso-phenology-results.R
\name{bso_get_individuals_rst}
\alias{bso_get_individuals_rst}
\alias{bso_get_individuals_df}
\alias{bso_get_individuals}
\title{Get individuals (BSO only)}
\usage{
bso_get_individuals_rst(
  pheno,
  generation,
  stage = "all",
  dates = prop_dates(pheno)
)

bso_get_individuals_df(
  pheno,
  generation,
  stations = prop_stations(pheno),
  stage = "all",
  dates = prop_dates(pheno)
)
}
\arguments{
\item{pheno}{A BSO phenology (see \code{\link[=bso_phenology]{bso_phenology()}})}

\item{generation}{Generation of interest. For sister broods, 0.5 should be
added.}

\item{stage}{If it is a numeric, the individuals of the
slots specified will be retrieved. Otherwise it could be one of the following
values: \code{all}, \code{egg}, \code{larva}, \code{pupa}, \code{white} (egg + larva + pupa),
\code{maturation}, \code{preflight}, \code{reproduction}, \code{brown} (maturation + preflight +
reproduction)}

\item{dates}{Select dates that should be present in the output.}

\item{stations}{Pass a character vector to choose stations assigned to \code{pheno} by
their names, or pass different stations. See \code{\link[=stations_create]{stations_create()}} for details.}
}
\value{
\itemize{
\item \code{bso_get_individuals_rst()}: a multi-layer SpatRaster.
\item \code{bso_get_individuals()}: a data frame.
}
}
\description{
Get the number of individuals of a generation that are in a specific development stage.
}
\examples{
\donttest{
# This may take a few minutes...

# calculate phenology
p <- bso_phenology('bso', barrks_data('stations'), .quiet = TRUE)

# get the number of individuals of the hibernating generation that are waiting to fly
bso_get_individuals_df(p, 0, 'Freiburg', stage = 'preflight')
}
}
