/*
 * Decompiled with CFR 0.152.
 */
package CustomLogging;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LoggingOutputStream
extends ByteArrayOutputStream {
    private String lineSeparator;
    private Logger logger;
    private Level level;

    public LoggingOutputStream(Logger logger, Level level) {
        this.logger = logger;
        this.level = level;
        this.lineSeparator = System.getProperty("line.separator");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        LoggingOutputStream loggingOutputStream = this;
        synchronized (loggingOutputStream) {
            super.flush();
            String string = this.toString();
            super.reset();
            if (string.length() == 0 || string.equals(this.lineSeparator)) {
                return;
            }
            this.logger.logp(this.level, "", "", string);
        }
    }
}

