% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.explainbarp.R
\name{plot.Explainbarp}
\alias{plot.Explainbarp}
\title{Visualization of Shapley Values from the BARP Model}
\usage{
\method{plot}{Explainbarp}(
  x,
  average = NULL,
  type = NULL,
  num_post = NULL,
  plot.flag = TRUE,
  adjust = FALSE,
  probs = 0.95,
  title = NULL,
  geo.unit = NULL,
  geo.id = NULL,
  ...
)
}
\arguments{
\item{x}{An \code{ExplainBARP} class object containing the Shapley values of the BARP model.}

\item{average}{Input the reference value for calculating the mean of the object's phi list.
\code{"obs"} represents the average based on observations (#post by #variable),
while \code{"post"} represents the average based on posterior samples (#obs by #variable).
If \code{"both"} is entered, calculations are performed based on both observation and posterior sample criteria.
If no value is specified, "both" is used as the default.}

\item{type}{\code{"bar"} represents a bar chart that includes the average contribution of each variable,
while \code{"bee"} represents a summary plot, allowing you to determine the graph's format.}

\item{num_post}{To check the contribution of variables for a single posterior sample,
enter a value within the number of posterior samples.}

\item{plot.flag}{If \code{average = "obs"}, the quantile interval of each variable's is provided by default.}

\item{adjust}{The default value is \code{FALSE}.
Enter \code{TRUE} to check the Shapley values adjusted based on the model's average contribution.}

\item{probs}{Enter the probability for the quantile interval. The default value is \code{0.95}.}

\item{title}{The title of the plot, with a default value of \code{NULL}.}

\item{geo.unit}{Enter the name of the stratification variable used in post stratification.}

\item{geo.id}{Enter one value of interest among the values of the stratification variable.}

\item{...}{Additional arguments to be passed}
}
\value{
The plot is returned based on the specified option.: 
\item{out}{If average is \code{"obs"} or \code{"post"}, a bar plot or summary plot is generated based on
the selected averaging criterion. If average is \code{"both"}, a boxplot is displayed to
show the distribution of Shapley values computed using both criteria.
If adjust is \code{TRUE}, the adjusted Shapley values are displayed.
If \code{num_post} is specified, a bar plot or summary plot for the selected posterior sample is generated.}
}
\description{
This function is implemented to visualize the computed Shapley values in 
various ways for objects of the \code{Explainbarp} class. The type of plot 
generated depends on the input parameters.
Since the BARP model is designed to be visualized for a single stratum, 
the user must specify both the stratum variable and the value of the stratum to be visualized.
}
