% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/battingStats.R
\name{RCtech}
\alias{RCtech}
\title{Batting: Calculate Runs Created using the technical formula.}
\usage{
RCtech(dat = NULL)
}
\arguments{
\item{dat}{A data frame you would wish to calculate. The data frame must have the same column names found in
The \code{Lahman} package or the Chadwick Bureau GitHub repository.}
}
\description{
The "Technical Version" is the most well-known formula for RC. It adds several factors to the
basic formula such as sacrifice hits, stolen bases and intentional base on balls.
Required fields from the batting table are "AB", "H", "BB", "X2B", "X3B", "HR", "GIDP", "HBP", "SB", "CS",
"SF" and "SH," and "IBB."
}
\examples{

data("Batting2016")
head(Batting2016)

Batting2016$RCtech <- RCtech(Batting2016)

}
\seealso{
Other Batting functions: \code{\link{BABIP}},
  \code{\link{BA}}, \code{\link{BBpct}},
  \code{\link{CTpct}}, \code{\link{HRpct}},
  \code{\link{ISO}}, \code{\link{Kpct}}, \code{\link{OBP}},
  \code{\link{OPS}}, \code{\link{PA}},
  \code{\link{RC2002}}, \code{\link{RCbasic}},
  \code{\link{SLG}}, \code{\link{TBs}},
  \code{\link{XBHpct}}, \code{\link{XBperH}},
  \code{\link{wOBA}}, \code{\link{wRAA}}, \code{\link{wRC}}
}
\keyword{RCtech}
\keyword{base}
\keyword{extra}
\keyword{hit}
\keyword{per}
