% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ncaa_baseball_roster.R
\name{ncaa_baseball_roster}
\alias{ncaa_baseball_roster}
\title{\strong{Get NCAA Baseball Rosters}}
\usage{
ncaa_baseball_roster(teamid = NA, team_year)
}
\arguments{
\item{teamid}{NCAA id for a school}

\item{team_year}{The year of interest}
}
\value{
A data frame containing roster information, including
IDs and urls for each player (if available)\tabular{ll}{
   col_name \tab types \cr
   name \tab character \cr
   class \tab character \cr
   player_id \tab character \cr
   season \tab numeric \cr
   number \tab character \cr
   position \tab character \cr
   player_url \tab character \cr
   school \tab character \cr
   conference \tab character \cr
   school_id \tab numeric \cr
   division \tab numeric \cr
   conference_id \tab numeric \cr
}
}
\description{
\strong{Get NCAA Baseball Rosters}
}
\examples{
\donttest{
  try(ncaa_baseball_roster(teamid = 104, team_year = 2021))
}
}
