% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlb_attendance.R
\name{mlb_attendance}
\alias{mlb_attendance}
\title{\strong{MLB Attendance}}
\usage{
mlb_attendance(
  team_id = NULL,
  league_id = NULL,
  season = NULL,
  date = NULL,
  league_list_id = NULL
)
}
\arguments{
\item{team_id}{Return attendance information for a particular team_id(s).}

\item{league_id}{Return attendance information for a particular league_id(s). Format: '103,104'}

\item{season}{Return attendance information for particular year(s).}

\item{date}{Return attendance information on a particular date. Format: MM/DD/YYYY}

\item{league_list_id}{Unique league list identifier to return a directory of attendance for a specific league list_id
Valid values include:
\itemize{
\item milb_full
\item milb_short
\item milb_complex
\item milb_all
\item milb_all_nomex
\item milb_all_domestic
\item milb_noncomp
\item milb_noncomp_nomex
\item milb_domcomp
\item milb_intcomp
\item win_noabl
\item win_caribbean
\item win_all
\item abl
\item mlb
\item mlb_hist
\item mlb_milb
\item mlb_milb_hist
\item mlb_milb_win
\item baseball_all
}}
}
\value{
Returns a tibble with the following columns\tabular{ll}{
   col_name \tab types \cr
   openings_total \tab integer \cr
   openings_total_away \tab integer \cr
   openings_total_home \tab integer \cr
   openings_total_lost \tab integer \cr
   games_total \tab integer \cr
   games_away_total \tab integer \cr
   games_home_total \tab integer \cr
   year \tab character \cr
   attendance_average_away \tab integer \cr
   attendance_average_home \tab integer \cr
   attendance_average_ytd \tab integer \cr
   attendance_high \tab integer \cr
   attendance_high_date \tab character \cr
   attendance_low \tab integer \cr
   attendance_low_date \tab character \cr
   attendance_opening_average \tab integer \cr
   attendance_total \tab integer \cr
   attendance_total_away \tab integer \cr
   attendance_total_home \tab integer \cr
   attendance_high_game_game_pk \tab integer \cr
   attendance_high_game_link \tab character \cr
   attendance_high_game_day_night \tab character \cr
   attendance_high_game_content_link \tab character \cr
   attendance_low_game_game_pk \tab integer \cr
   attendance_low_game_link \tab character \cr
   attendance_low_game_day_night \tab character \cr
   attendance_low_game_content_link \tab character \cr
   game_type_id \tab character \cr
   game_type_description \tab character \cr
   team_id \tab integer \cr
   team_name \tab character \cr
   team_link \tab character \cr
}
}
\description{
\strong{MLB Attendance}
}
\examples{
\donttest{
  try(mlb_attendance(team_id = 109, season = 2021))
}
}
