% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlb_player_game_stats.R
\name{mlb_player_game_stats}
\alias{mlb_player_game_stats}
\title{\strong{Find MLB Player Game Stats}}
\usage{
mlb_player_game_stats(person_id = NULL, game_pk = NULL)
}
\arguments{
\item{person_id}{MLBAMIDs for player of interest.}

\item{game_pk}{The game_pk to return game_log statistics for a specific player in a specific game and to complete the call.}
}
\value{
Returns a tibble with the following columns:\tabular{ll}{
   col_name \tab types \cr
   type \tab character \cr
   group \tab character \cr
   assists \tab integer \cr
   put_outs \tab integer \cr
   errors \tab integer \cr
   chances \tab integer \cr
   fielding \tab character \cr
   caught_stealing \tab integer \cr
   passed_ball \tab integer \cr
   stolen_bases \tab integer \cr
   stolen_base_percentage \tab character \cr
   pickoffs \tab integer \cr
   games_played \tab integer \cr
   games_started \tab integer \cr
   fly_outs \tab integer \cr
   ground_outs \tab integer \cr
   air_outs \tab integer \cr
   runs \tab integer \cr
   doubles \tab integer \cr
   triples \tab integer \cr
   home_runs \tab integer \cr
   strike_outs \tab integer \cr
   base_on_balls \tab integer \cr
   intentional_walks \tab integer \cr
   hits \tab integer \cr
   hit_by_pitch \tab integer \cr
   at_bats \tab integer \cr
   number_of_pitches \tab integer \cr
   innings_pitched \tab character \cr
   wins \tab integer \cr
   losses \tab integer \cr
   saves \tab integer \cr
   save_opportunities \tab integer \cr
   holds \tab integer \cr
   blown_saves \tab integer \cr
   earned_runs \tab integer \cr
   batters_faced \tab integer \cr
   outs \tab integer \cr
   games_pitched \tab integer \cr
   complete_games \tab integer \cr
   shutouts \tab integer \cr
   pitches_thrown \tab integer \cr
   balls \tab integer \cr
   strikes \tab integer \cr
   strike_percentage \tab character \cr
   hit_batsmen \tab integer \cr
   balks \tab integer \cr
   wild_pitches \tab integer \cr
   rbi \tab integer \cr
   games_finished \tab integer \cr
   runs_scored_per9 \tab character \cr
   home_runs_per9 \tab character \cr
   inherited_runners \tab integer \cr
   inherited_runners_scored \tab integer \cr
   catchers_interference \tab integer \cr
   sac_bunts \tab integer \cr
   sac_flies \tab integer \cr
   ground_into_double_play \tab integer \cr
   ground_into_triple_play \tab integer \cr
   plate_appearances \tab integer \cr
   total_bases \tab integer \cr
   left_on_base \tab integer \cr
   at_bats_per_home_run \tab character \cr
   game_type \tab character \cr
   num_teams \tab integer \cr
   avg \tab character \cr
   obp \tab character \cr
   slg \tab character \cr
   ops \tab character \cr
   outs_pitched \tab integer \cr
   whip \tab character \cr
   ground_outs_to_airouts \tab character \cr
   pitches_per_inning \tab character \cr
   strikeout_walk_ratio \tab character \cr
   strikeouts_per9inn \tab character \cr
   walks_per9inn \tab character \cr
   hits_per9inn \tab character \cr
   team_id \tab integer \cr
   team_name \tab character \cr
   team_link \tab character \cr
   opponent_id \tab integer \cr
   opponent_name \tab character \cr
   opponent_link \tab character \cr
   pitcher_id \tab integer \cr
   pitcher_full_name \tab character \cr
   pitcher_link \tab character \cr
   pitcher_first_name \tab character \cr
   pitcher_last_name \tab character \cr
   batter_id \tab integer \cr
   batter_full_name \tab character \cr
   batter_link \tab character \cr
   batter_first_name \tab character \cr
   batter_last_name \tab character \cr
   total_splits \tab integer \cr
   type_display_name \tab character \cr
   group_display_name \tab character \cr
   player_id \tab numeric \cr
   game_pk \tab numeric \cr
}
}
\description{
\strong{Find MLB Player Game Stats}
}
\examples{
\donttest{
 try(mlb_player_game_stats(person_id = 605151, game_pk = 531368))
}
}
