% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlb_rosters.R
\name{mlb_rosters}
\alias{mlb_rosters}
\title{\strong{Find MLB Rosters by Roster Type}}
\usage{
mlb_rosters(team_id = NULL, season = NULL, date = NULL, roster_type = NULL)
}
\arguments{
\item{team_id}{team_id to return team roster information for a particular club.}

\item{season}{Year to return team roster information for a particular club in a specific season.}

\item{date}{Date to return team roster and their coaching staff directorial information for a particular team.}

\item{roster_type}{roster_type to return team directorial information for. See \code{mlb_roster_types()} for more options.
Valid options include: '40Man', 'fullSeason', 'fullRoster', 'nonRosterInvitees', 'active',
'allTime', 'depthChart', 'gameday', 'coach'}
}
\value{
Returns a tibble with the following columns:\tabular{ll}{
   col_name \tab types \cr
   jersey_number \tab character \cr
   person_id \tab integer \cr
   person_full_name \tab character \cr
   person_link \tab character \cr
   position_code \tab character \cr
   position_name \tab character \cr
   position_type \tab character \cr
   position_abbreviation \tab character \cr
   status_code \tab character \cr
   status_description \tab character \cr
   link \tab character \cr
   team_id \tab integer \cr
   roster_type \tab character \cr
   season \tab numeric \cr
   date \tab character \cr
}
}
\description{
\strong{Find MLB Rosters by Roster Type}
}
\examples{
\donttest{
  try(mlb_rosters(team_id = 109, season = 2018, roster_type = 'active'))
  try(mlb_rosters(team_id = 109, season = 2018, roster_type = 'coach'))
}
}
