% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlb_teams_stats_leaders.R
\name{mlb_teams_stats_leaders}
\alias{mlb_teams_stats_leaders}
\title{\strong{MLB Teams Stats Leaders}}
\usage{
mlb_teams_stats_leaders(
  leader_categories = NULL,
  leader_game_types = NULL,
  sit_codes = NULL,
  stat_group = NULL,
  season = NULL,
  league_id = NULL,
  sport_id = NULL,
  start_date = NULL,
  end_date = NULL,
  stat_type = NULL,
  limit = 1000
)
}
\arguments{
\item{leader_categories}{League leader category to return information and ranking for a particular statistic.}

\item{leader_game_types}{Game type to return information and ranking for a particular statistic in a particular game type.}

\item{sit_codes}{Situation code to return information and ranking for a particular statistic in a particular game type.}

\item{stat_group}{Stat group to return information and ranking for a particular statistic in a particular group.}

\item{season}{Year to return information and ranking for a particular statistic in a given year.}

\item{league_id}{League ID to return statistics for a given league. Default to "Qualified" player pool.}

\item{sport_id}{The sport_id to return information and ranking information for.}

\item{start_date}{Start date to return information and ranking for a particular statistic for a particular date range. Format: MM/DD/YYYY
\emph{start_date must be coupled with end_date and byDateRange stat_type}}

\item{end_date}{End date to return information and ranking for a particular statistic for a particular date range. Format: MM/DD/YYYY
\emph{end_date must be coupled with start_date and byDateRange stat_type}}

\item{stat_type}{The stat_type to return information and ranking for a particular statistic for a particular stat type.}

\item{limit}{A limit to limit return to a particular number of records.}
}
\value{
Returns a tibble with the following columns\tabular{ll}{
   col_name \tab types \cr
   leader_category \tab character \cr
   rank \tab integer \cr
   value \tab character \cr
   season \tab character \cr
   num_teams \tab integer \cr
   team_id \tab integer \cr
   team_name \tab character \cr
   team_link \tab character \cr
   league_id \tab integer \cr
   league_name \tab character \cr
   league_link \tab character \cr
   person_id \tab integer \cr
   person_full_name \tab character \cr
   person_link \tab character \cr
   person_first_name \tab character \cr
   person_last_name \tab character \cr
   sport_id \tab integer \cr
   sport_link \tab character \cr
   sport_abbreviation \tab character \cr
   stat_group \tab character \cr
   total_splits \tab integer \cr
   game_type_id \tab character \cr
   game_type_description \tab character \cr
}
}
\description{
\strong{MLB Teams Stats Leaders}
}
\examples{
\donttest{
 try(mlb_teams_stats_leaders(leader_categories='homeRuns',sport_id=1, season = 2021))
}
}
