% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ncaa_park_factor.R
\name{ncaa_park_factor}
\alias{ncaa_park_factor}
\title{\strong{Get Park Effects for NCAA Baseball Teams}}
\usage{
ncaa_park_factor(team_id, years, type = "conference", ...)
}
\arguments{
\item{team_id}{The team's unique NCAA id.}

\item{years}{The season or seasons (i.e. use 2016 for the 2015-2016 season,
etc., limited to just 2013-2020 seasons).}

\item{type}{default is conference. the conference parameter adjusts for the conference
the school plays in, the division parameter calculates based on the division the school plays in 1,2,or 3.
Defaults to 'conference'.}

\item{...}{Additional arguments passed to an underlying function like httr.}
}
\value{
A data frame with the following fields: school, home_game,
away_game, runs_scored_home, runs_allowed_home, run_scored_away,
runs_allowed_away, base_pf (base park factor), home_game_adj (an adjustment for the percentage of home games played) final_pf (park factor after adjustments)\tabular{ll}{
   col_name \tab types \cr
   school \tab character \cr
   home_game \tab numeric \cr
   away_game \tab numeric \cr
   runs_scored_home \tab numeric \cr
   runs_allowed_home \tab numeric \cr
   runs_scored_away \tab numeric \cr
   runs_allowed_away \tab numeric \cr
   base_pf \tab numeric \cr
   home_game_adj \tab numeric \cr
   final_pf \tab numeric \cr
}
}
\description{
\strong{Get Park Effects for NCAA Baseball Teams}
}
\details{
\if{html}{\out{<div class="sourceCode r">}}\preformatted{  try(ncaa_park_factor(team_id = 736, years = c(2018:2019), type = "conference"))
}\if{html}{\out{</div>}}
}
