% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cox.zph.mids.R
\name{cox.zph.mids}
\alias{cox.zph.mids}
\title{Test cox proportional odds assumption on models using multiple imputation.}
\usage{
cox.zph.mids(
  model,
  imputations,
  p_level = 0.05,
  global_only = TRUE,
  return_raw = FALSE,
  p_only = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{model}{cox proportional model to be evaluated}

\item{imputations}{mids object containing imputations}

\item{p_level}{value below which violation of proportional odds assumption is assumed. Defaults to .05}

\item{global_only}{return global p-value only. Implies p_only to be TRUE}

\item{return_raw}{return cox.zph objects in a list. If TRUE, function will not return anything else}

\item{p_only}{returns p-values of test only. If FALSE returns Chi² and degrees of freedom as well}

\item{verbose}{Set to FALSE to deactivate messages}
}
\value{
depending on specified options, this function can return
\itemize{
\item default: A vector of global p-values
\item global_only = FALSE: a data.frame with p-values for all variables plus the global
\item return_raw = TRUE: list of cox.zph objects
}
}
\description{
Constructs a model and conducts a cox.zph test for each imputation of the data set.
}
\examples{
data <- data.frame(time = 101:200, status = rep(c(0,1), 50), pred = rep(c(1:9, NA), 10))
imputed_data <- mice::mice(data)
cox_mod <- Hmisc::fit.mult.impute(survival::Surv(time, status) ~ pred,
fitter = rms::cph, xtrans = imputed_data)
cox.zph.mids(cox_mod, imputed_data)

}
\author{
J. Peter Marquardt
}
