% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Tidy_names_types_factors.R
\name{parse_date_columns}
\alias{parse_date_columns}
\title{Parse values in date columns as Dates}
\usage{
parse_date_columns(data, date_formats)
}
\arguments{
\item{data}{data.frame to modify}

\item{date_formats}{named list with:
\itemize{
\item Keys: Names of date columns
\item values: character specifying the format
}}
}
\value{
data.frame with date columns in Date type
}
\description{
Parse date columns in a data.frame as Date.
Use a named list to specify each date column (key) and the format (value) it is coded in.
}
\examples{
data <- data.frame(date = rep('01/23/4567', 5))
data <- parse_date_columns(data, list(date = '\%m/\%d/\%Y'))

}
\author{
J. Peter Marquardt
}
