% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/defaults.R
\name{defaults}
\alias{defaults}
\alias{set_defaults}
\alias{get_defaults}
\alias{reset_defaults}
\title{Set, get and reset \code{basemaps} defaults}
\usage{
set_defaults(
  ext = NULL,
  map_service = NULL,
  map_type = NULL,
  map_res = NULL,
  map_token = NULL,
  map_dir = NULL
)

get_defaults()

reset_defaults()
}
\arguments{
\item{ext}{extent to be covered by the basemap as any spatial class supported by \code{st_bbox}.}

\item{map_service}{character, a map service, either \code{"osm"}, \code{"carto"} or \code{"mapbox"}. Default is \code{"osm"}.}

\item{map_type}{character, a map type, e.g. \code{"streets"}. For a full list of available map types, see \code{\link{get_maptypes}}.}

\item{map_res}{numeric, resolution of base map in range from 0 to 1.}

\item{map_token}{character, authentification token for services that require registration, which are \code{"osm_thunderforest"} and \code{"mapbox"}. Register at \url{https://www.thunderforest.com/} and/or \url{https://www.mapbox.com/} to get tokens. Ignored for all other map services.}

\item{map_dir}{character, cache directory where downloaded basemap tiles will be stored. By default, a temporary directory is used, which is destroyed when the session is terminated.}
}
\value{
For \code{get_defaults}, a list of defaults, otherwise none.
}
\description{
These functions set, get or reset the defaults of all map arguments passed to \code{\link{basemap}} and associated functions.
}
\examples{
library(basemaps)
data(ext)

# set defaults for the basemap
set_defaults(ext = ext, map_service = "osm", map_type = "terrain_bg")

# get defaults
get_defaults()

\dontrun{
# load and return basemap map as raster (default)
map <- basemap()
}

# reset defaults
reset_defaults()

}
