% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basetheme.R
\name{basetheme}
\alias{basetheme}
\title{Theme Control}
\usage{
basetheme(...)
}
\arguments{
\item{...}{- a sequence of \code{parameter=value} pairs (see Details).}
}
\value{
a list of all theme settings (invisibly, unless no arguments were provided).
}
\description{
Sets and returns base plotting theme parameters.
}
\details{
Function dispatches based on the type of first argument:\cr\cr
1. No arguments - returns the list of the current theme settings.\cr
2. NULL - all theme settings are removed.\cr
3. list - assumed that list stores theme settings.\cr
4. character - a theme with that name is used.\cr
5. parameter=value pair - sets the setting for the specified parameter.\cr

Further arguments can be provided as \code{parameter=value} pairs.
See examples.

The list of theme parameters is always returned invisibly,
except when function is called with no arguments.

The parameters set by this function will take presedence over \code{par()} parameters.
}
\examples{
  # Set theme by parameters
  basetheme(pch=19, las=1, cex=2)
  plot(1, 1)

  # Obtain list of theme parameters
  # for the current theme
  basetheme()
  # for a specific theme
  theme <- basetheme("brutal")
  theme

  # Set theme by name
  basetheme("dark")
  plot(1)

  # Set theme by list
  theme <- basetheme("clean")
  theme$rect.col <- "grey90"
  basetheme(theme)
  pairs(iris[,1:4], col=iris$Species)

  # Reset theme
  basetheme(NULL)

}
\author{
Karolis Koncevičius
}
