% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootHillModel.R
\name{calcHillConfInt}
\alias{calcHillConfInt}
\title{Estimate an confidence interval on a Hill model property}
\usage{
calcHillConfInt(hfit, parfunc, civals = NULL)
}
\arguments{
\item{hfit}{An object of class \code{hillrm}, with the \code{ciCoefs} property
produced by \code{\link[=calcHillBootstrap]{calcHillBootstrap()}}}

\item{parfunc}{A function from a four parameter Hill model vector (see
\code{\link[=evalHillModel]{evalHillModel()}}) to a single value or a vector of values with a consisten
length}

\item{civals}{An optional set of upper and lower bounds on the confidence
interval to be estimated.  If \code{NULL}, the default, the \code{ciLevs} property
from \code{\link[=calcHillBootstrap]{calcHillBootstrap()}} will be used.}
}
\value{
An n-by-3 array, where n is the length of the vector produced by
\code{parfunc}.  The first row is the lower bound of the confidence interval,
the second row is the function evaluated at the best-fit Hill model, and the
third row is the upper bound of the confidence interval.
}
\description{
Given a function from Hill model parameters to one or more model properties,
this function produces a confidence interval on that value or those values
using the bootstrapped model coefficents produced by \code{\link[=calcHillBootstrap]{calcHillBootstrap()}}.
This is useful for estimating confidence intervals on other values like
IC50, or generating confidence intervals on fitted values for plots.
}
\examples{
conc <- c(0,2^(-6:3),Inf)
hpar <- c(1,3,0,75)
response <- evalHillModel(conc, hpar) + rnorm(length(conc),sd=7.5)

hfit <- fitHillModel(conc,response,c(1,2,3,4),start=c(0.5,1,0,100))
cihfit <- calcHillBootstrap(hfit)

ic50_ci <- calcHillConfInt(cihfit,function(h) invertHillModel(50,h))
}
