# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @title Create Similarity Matrix
#' @description Constructs a similarity matrix of the pairwise coclustering 
#' rate.
#' @param allocations Matrix of sampled partitions. Columns correspond to 
#' items/samples being clustered, each row is a sampled partition.//' 
#' @return A symmetric n x n matrix (for n rows in cluster record) describing 
#' the fraction of iterations for which each pairwise combination of points are
#' assigned the same label.
#' @export
createSimilarityMat <- function(allocations) {
    .Call('_batchmix_createSimilarityMat', PACKAGE = 'batchmix', allocations)
}

#' @title Gamma log-likelihood
#' @description Used in calculating model probability in Metropolis-Hastings 
#' algorithm when proposals are from the Gamma distribution.
#' @param x - double; the value to calculate the unnormalised likelihood of.
#' @param shape - double; the shape of the Gamma distribution.
#' @param rate - double; the rate of the Gamma distribution
#' @return the unnormalised log-likelihood of x in a Gamma with parameters shape 
#' and rate.
gammaLogLikelihood <- function(x, shape, rate) {
    .Call('_batchmix_gammaLogLikelihood', PACKAGE = 'batchmix', x, shape, rate)
}

#' @title Inverse gamma log-likelihood
#' @description Used in calculating model probability in Metropolis-Hastings 
#' algorithm when proposals are from the inverse-Gamma distribution.
#' @param x - double; the value to calculate the likelihood of.
#' @param shape - double; the shape of the inverse-Gamma distribution.
#' @param scale - double; the scale of the inverse-Gamma distribution
#' @return the unnormalised log-likelihood of x in a inverse-Gamma with parameters 
#' shape and scale.
invGammaLogLikelihood <- function(x, shape, scale) {
    .Call('_batchmix_invGammaLogLikelihood', PACKAGE = 'batchmix', x, shape, scale)
}

#' @title Wishart log-likelihood
#' @description Used in calculating model probability in Metropolis-Hastings 
#' algorithm when proposals are from the Wishart distribution.
#' @param X - matrix; the matrix to calculate the likelihood of.
#' @param V - matrix; the scale of the Wishart distribution.
#' @param n - double; the degrees of freedom for the Wishart distribution.
#' @param P - unsigned integer; the dimension of X.
#' @return the unnormalised log-likelihood of X in a Wishart with parameters V 
#' and n.
wishartLogLikelihood <- function(X, V, n, P) {
    .Call('_batchmix_wishartLogLikelihood', PACKAGE = 'batchmix', X, V, n, P)
}

#' @title Inverse-Wishart log-likelihood
#' @description Used in calculating model probability in Metropolis-Hastings 
#' algorithm when proposals are from the Wishart distribution.
#' @param X - matrix; the matrix to calculate the likelihood of.
#' @param Psi - matrix; the scale of the inverse-Wishart distribution.
#' @param nu - double; the degrees of freedom for the inverse-Wishart distribution.
#' @param P - unsigned integer; the dimension of X.
#' @return the unnormalised log-likelihood of X in a inverse-Wishart with parameters Psi 
#' and nu.
invWishartLogLikelihood <- function(X, Psi, nu, P) {
    .Call('_batchmix_invWishartLogLikelihood', PACKAGE = 'batchmix', X, Psi, nu, P)
}

#' @title Sample mixture of multivariate normal distributions with batch effects
#' @description Performs MCMC sampling for a mixture model with batch effects.
#' @param X The data matrix to perform clustering upon (items to cluster in rows).
#' @param K The number of components to model (upper limit on the number of 
#' clusters found).
#' @param B The number of batches to model.
#' @param labels Vector item labels to initialise from.
#' @param batch_vec Observed batch labels.
#' @param mu_proposal_window The standard deviation for the Gaussian proposal
#' density of the cluster means.
#' @param cov_proposal_window The degrees of freedom for the Wishart proposal
#' density of the cluster covariances.
#' @param m_proposal_window The standard deviation for the Gaussian proposal
#' density of the batch mean effects.
#' @param S_proposal_window The rate for the Gamma proposal density of the 
#' batch scale.
#' @param R The number of iterations to run for.
#' @param thin thinning factor for samples recorded.
#' @param concentration Vector of concentrations for mixture weights
#' (recommended to be symmetric).
#' @param m_scale The scale hyperparameter for the batch shift prior 
#' distribution.
#' @param rho The shape of the prior distribution for the batch scale.
#' @param theta The scale of the prior distribution for the batch scale.
#' @param initial_mu A P x K matrix of initial values for the class means.
#' @param initial_cov A P x P x K cube of initial values for the class 
#' covariance matrices.
#' @param initial_m A P x B matrix of initial values for the batch shift 
#' effects.
#' @param initial_S A P x B matrix of initial values for the batch scales.
#' @param mu_initialised Bool indicating if the class means are initialised by
#' the user. If ``false`` then initial values are drawn from the prior 
#' distribution.
#' @param cov_initialised Bool indicating if the class covariance matrices are 
#' initialised by the user. If ``false`` then initial values are drawn from the
#' prior distribution.
#' @param m_initialised Bool indicating if the batch shift effects are 
#' initialised by the user. If ``false`` then initial values are drawn from the
#' prior distribution.
#' @param S_initialised Bool indicating if the batch scales are initialised by 
#' the user. If ``false`` then initial values are drawn from the prior 
#' distribution.
#' @return Named list of the different quantities drawn by the sampler.
sampleMVN <- function(X, K, B, labels, batch_vec, mu_proposal_window, cov_proposal_window, m_proposal_window, S_proposal_window, R, thin, concentration, m_scale, rho, theta, initial_mu, initial_cov, initial_m, initial_S, mu_initialised, cov_initialised, m_initialised, S_initialised) {
    .Call('_batchmix_sampleMVN', PACKAGE = 'batchmix', X, K, B, labels, batch_vec, mu_proposal_window, cov_proposal_window, m_proposal_window, S_proposal_window, R, thin, concentration, m_scale, rho, theta, initial_mu, initial_cov, initial_m, initial_S, mu_initialised, cov_initialised, m_initialised, S_initialised)
}

#' @title Sample mixture of multivariate t-distributions with batch effects
#' @description Performs MCMC sampling for a MVT mixture model with batch effects.
#' @param X The data matrix to perform clustering upon (items to cluster in rows).
#' @param K The number of components to model (upper limit on the number of 
#' clusters found).
#' @param B The number of batches to model.
#' @param labels Vector item labels to initialise from.
#' @param batch_vec Observed batch labels.
#' @param mu_proposal_window The standard deviation for the Gaussian proposal 
#' density of the cluster means.
#' @param cov_proposal_window The degrees of freedom for the Wishart proposal 
#' density of the cluster covariances.
#' @param m_proposal_window The standard deviation for the Gaussian proposal 
#' density of the batch mean effects.
#' @param S_proposal_window The rate for the Gamma proposal density of the 
#' batch scale.
#' @param t_df_proposal_window The rate for the Gamma proposal density of the 
#' cluster degrees of freedom.
#' @param R The number of iterations to run for.
#' @param thin thinning factor for samples recorded.
#' @param concentration Vector of concentrations for mixture weights 
#' (recommended to be symmetric).
#' @param m_scale The scale hyperparameter for the batch shift prior 
#' distribution.
#' @param rho The shape of the prior distribution for the batch scale.
#' @param theta The scale of the prior distribution for the batch scale.
#' @param initial_mu A P x K matrix of initial values for the class means.
#' @param initial_cov A P x P x K cube of initial values for the class 
#' covariance matrices.
#' @param initial_df A K vector of initial values for the class degrees of
#' freedom.
#' @param initial_m A P x B matrix of initial values for the batch shift 
#' effects.
#' @param initial_S A P x B matrix of initial values for the batch scales.
#' @param mu_initialised Bool indicating if the class means are initialised by
#' the user. If ``false`` then initial values are drawn from the prior 
#' distribution.
#' @param cov_initialised Bool indicating if the class covariance matrices are 
#' initialised by the user. If ``false`` then initial values are drawn from the
#' prior distribution.
#' @param df_initialised Bool indicating if the class degrees of freedom are 
#' initialised by the user. If ``false`` then initial values are drawn from the 
#' prior distribution.
#' @param m_initialised Bool indicating if the batch shift effects are 
#' initialised by the user. If ``false`` then initial values are drawn from the
#' prior distribution.
#' @param S_initialised Bool indicating if the batch scales are initialised by 
#' the user. If ``false`` then initial values are drawn from the prior 
#' distribution.
#' @return Named list of the different quantities drawn by the sampler.
sampleMVT <- function(X, K, B, labels, batch_vec, mu_proposal_window, cov_proposal_window, m_proposal_window, S_proposal_window, t_df_proposal_window, R, thin, concentration, m_scale, rho, theta, initial_mu, initial_cov, initial_df, initial_m, initial_S, mu_initialised, cov_initialised, df_initialised, m_initialised, S_initialised) {
    .Call('_batchmix_sampleMVT', PACKAGE = 'batchmix', X, K, B, labels, batch_vec, mu_proposal_window, cov_proposal_window, m_proposal_window, S_proposal_window, t_df_proposal_window, R, thin, concentration, m_scale, rho, theta, initial_mu, initial_cov, initial_df, initial_m, initial_S, mu_initialised, cov_initialised, df_initialised, m_initialised, S_initialised)
}

#' @title Sample semi-supervised MVN Mixture model
#' @description Performs MCMC sampling for a mixture model.
#' @param X The data matrix to perform clustering upon (items to cluster in
#' rows).
#' @param K The number of components to model (upper limit on the number of
#' clusters found).
#' @param B The number of batches to model.
#' @param labels Vector item labels to initialise from.
#' @param batch_vec Observed batch labels.
#' @param fixed Binary vector of the items that are fixed in their initial
#' label.
#' @param mu_proposal_window The standard deviation for the Gaussian proposal
#'  density of the cluster means.
#' @param cov_proposal_window The degrees of freedom for the Wishart proposal
#'  density of the cluster covariances.
#' @param m_proposal_window The standard deviation for the Gaussian proposal
#'  density of the batch mean effects.
#' @param S_proposal_window The rate for the Gamma proposal density of the batch scale.
#' @param R The number of iterations to run for.
#' @param thin thinning factor for samples recorded.
#' @param concentration Vector of concentrations for mixture weights 
#' (recommended to be symmetric).
#' @param m_scale The scale hyperparameter for the batch shift prior 
#' distribution.
#' @param rho The shape of the prior distribution for the batch scale.
#' @param theta The scale of the prior distribution for the batch scale.
#' @param initial_mu A P x K matrix of initial values for the class means.
#' @param initial_cov A P x P x K cube of initial values for the class 
#' covariance matrices.
#' @param initial_m A P x B matrix of initial values for the batch shift 
#' effects.
#' @param initial_S A P x B matrix of initial values for the batch scales.
#' @param mu_initialised Bool indicating if the class means are initialised by
#' the user. If ``false`` then initial values are drawn from the prior 
#' distribution.
#' @param cov_initialised Bool indicating if the class covariance matrices are 
#' initialised by the user. If ``false`` then initial values are drawn from the
#' prior distribution.
#' @param m_initialised Bool indicating if the batch shift effects are 
#' initialised by the user. If ``false`` then initial values are drawn from the
#' prior distribution.
#' @param S_initialised Bool indicating if the batch scales are initialised by 
#' the user. If ``false`` then initial values are drawn from the prior 
#' distribution.
#' @return Named list of the different quantities drawn by the sampler.
sampleSemisupervisedMVN <- function(X, K, B, labels, batch_vec, fixed, mu_proposal_window, cov_proposal_window, m_proposal_window, S_proposal_window, R, thin, concentration, m_scale, rho, theta, initial_mu, initial_cov, initial_m, initial_S, mu_initialised, cov_initialised, m_initialised, S_initialised) {
    .Call('_batchmix_sampleSemisupervisedMVN', PACKAGE = 'batchmix', X, K, B, labels, batch_vec, fixed, mu_proposal_window, cov_proposal_window, m_proposal_window, S_proposal_window, R, thin, concentration, m_scale, rho, theta, initial_mu, initial_cov, initial_m, initial_S, mu_initialised, cov_initialised, m_initialised, S_initialised)
}

#' @title Sample semi-supervised MVT Mixture model
#' @description Performs MCMC sampling for a mixture model.
#' @param X The data matrix to perform clustering upon (items to cluster in rows).
#' @param K The number of components to model (upper limit on the number of clusters found).
#' @param B The number of batches to model.
#' @param labels Vector item labels to initialise from.
#' @param batch_vec Observed batch labels.
#' @param fixed Binary vector of the items that are fixed in their initial label.
#' @param mu_proposal_window The standard deviation for the Gaussian proposal density of the cluster means.
#' @param cov_proposal_window The degrees of freedom for the Wishart proposal density of the cluster covariances.
#' @param m_proposal_window The standard deviation for the Gaussian proposal density of the batch mean effects.
#' @param S_proposal_window The rate for the Gamma proposal density of the batch scale.
#' @param t_df_proposal_window The rate for the Gamma proposal density of the cluster degrees of freedom.
#' @param R The number of iterations to run for.
#' @param thin thinning factor for samples recorded.
#' @param concentration Vector of concentrations for mixture weights (recommended to be symmetric).
#' @param m_scale The scale hyperparameter for the batch shift prior 
#' distribution.
#' @param rho The shape of the prior distribution for the batch scale.
#' @param theta The scale of the prior distribution for the batch scale.
#' @param initial_mu A P x K matrix of initial values for the class means.
#' @param initial_cov A P x P x K cube of initial values for the class 
#' covariance matrices.
#' @param initial_df A K vector of initial values for the class degrees of
#' freedom.
#' @param initial_m A P x B matrix of initial values for the batch shift 
#' effects.
#' @param initial_S A P x B matrix of initial values for the batch scales.
#' @param mu_initialised Bool indicating if the class means are initialised by
#' the user. If ``false`` then initial values are drawn from the prior 
#' distribution.
#' @param cov_initialised Bool indicating if the class covariance matrices are 
#' initialised by the user. If ``false`` then initial values are drawn from the
#' prior distribution.
#' @param df_initialised Bool indicating if the class degrees of freedom are 
#' initialised by the user. If ``false`` then initial values are drawn from the 
#' prior distribution.
#' @param m_initialised Bool indicating if the batch shift effects are 
#' initialised by the user. If ``false`` then initial values are drawn from the
#' prior distribution.
#' @param S_initialised Bool indicating if the batch scales are initialised by 
#' the user. If ``false`` then initial values are drawn from the prior 
#' distribution.
#' @return Named list of the different quantities drawn by the sampler.
sampleSemisupervisedMVT <- function(X, K, B, labels, batch_vec, fixed, mu_proposal_window, cov_proposal_window, m_proposal_window, S_proposal_window, t_df_proposal_window, R, thin, concentration, m_scale, rho, theta, initial_mu, initial_cov, initial_df, initial_m, initial_S, mu_initialised, cov_initialised, df_initialised, m_initialised, S_initialised) {
    .Call('_batchmix_sampleSemisupervisedMVT', PACKAGE = 'batchmix', X, K, B, labels, batch_vec, fixed, mu_proposal_window, cov_proposal_window, m_proposal_window, S_proposal_window, t_df_proposal_window, R, thin, concentration, m_scale, rho, theta, initial_mu, initial_cov, initial_df, initial_m, initial_S, mu_initialised, cov_initialised, df_initialised, m_initialised, S_initialised)
}

