% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/status.R
\name{batch_file_status}
\alias{batch_file_status}
\title{Batch File Status}
\usage{
batch_file_status(path)
}
\arguments{
\item{path}{A string of the path to the directory with the files for processing.}
}
\value{
A tibble with four columns:
\describe{
\item{type}{A character vector indicating SUCCESS,  FAILURE or REMAING}
\item{time}{A hms vector of the file processing time}
\item{file}{A character vector of the file name}
\item{error}{A character vector of the error message (or NA if no error)}
}
}
\description{
Gets the current status (SUCCESS, FAILURE, REMAING) of each
eligible file in path.
}
\examples{
path <- tempdir()
write.csv(mtcars, file.path(path, "file1.csv"))
batch_config(function(x) TRUE, path, regexp = "[.]csv$")
batch_file_status(path)
batch_run(path, ask = FALSE)
batch_file_status(path)
batch_cleanup(path)
unlink(file.path(path, "file1.csv"))
}
\seealso{
\code{\link[=batch_log_read]{batch_log_read()}}
}
