% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.R
\name{batch_config_read}
\alias{batch_config_read}
\title{Read Configuration File}
\usage{
batch_config_read(path)
}
\arguments{
\item{path}{A string of the path to the directory with the files for processing.}
}
\value{
A named list of the configuration values.
}
\description{
Reads the values in the
configuration file created by \code{\link[=batch_config]{batch_config()}}.
}
\examples{
path <- tempdir()
write.csv(mtcars, file.path(path, "file1.csv"))
batch_config(function(x) TRUE, path, regexp = "[.]csv$")
batch_config_read(path)
batch_cleanup(path, force = TRUE, remaining = TRUE)
unlink(file.path(path, "file1.csv"))
}
\seealso{
\code{\link[=batch_process]{batch_process()}} and \code{\link[=batch_log_read]{batch_log_read()}}
}
