% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clusterFunctions.R
\name{cfKillJob}
\alias{cfKillJob}
\title{Cluster Functions Helper to Kill Batch Jobs}
\usage{
cfKillJob(reg, cmd, args = character(0L), max.tries = 3L)
}
\arguments{
\item{reg}{[\code{\link{Registry}}]\cr
Registry. If not explicitly passed, uses the default registry (see \code{\link{setDefaultRegistry}}).}

\item{cmd}{[\code{character(1)}]\cr
OS command, e.g. \dQuote{qdel}.}

\item{args}{[\code{character}]\cr
Arguments to \code{cmd}, including the batch id.}

\item{max.tries}{[\code{integer(1)}]\cr
Number of total times to try execute the OS command in cases of failures.
Default is \code{3}.}
}
\value{
\code{TRUE} on success. An exception is raised otherwise.
}
\description{
This function is only intended for use in your own cluster functions implementation.

Calls the OS command to kill a job via \code{system} like this: \dQuote{cmd batch.job.id}. If the
command returns an exit code > 0, the command is repeated after a 1 second sleep
\code{max.tries-1} times. If the command failed in all tries, an exception is generated.
}
\seealso{
Other ClusterFunctionsHelper: \code{\link{cfBrewTemplate}},
  \code{\link{cfHandleUnknownSubmitError}},
  \code{\link{cfReadBrewTemplate}},
  \code{\link{makeClusterFunctions}},
  \code{\link{makeSubmitJobResult}},
  \code{\link{runOSCommand}}
}

