% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clusterFunctionsSSH.R
\name{makeClusterFunctionsSSH}
\alias{makeClusterFunctionsSSH}
\title{ClusterFunctions for Remote SSH Execution}
\usage{
makeClusterFunctionsSSH(workers)
}
\arguments{
\item{workers}{[\code{list} of \code{\link{Worker}}]\cr
List of Workers as constructed with \code{\link{Worker}}.}
}
\value{
[\code{\link{ClusterFunctions}}].
}
\description{
Jobs are spawned by starting multiple R sessions via \code{Rscript} over SSH.
If the hostname of the \code{\link{Worker}} equals \dQuote{localhost},
\code{Rscript} is called directly so that you do not need to have an SSH client installed.
}
\note{
If you use a custom \dQuote{.ssh/config} file, make sure your
ProxyCommand passes \sQuote{-q} to ssh, otherwise each output will
end with the message \dQuote{Killed by signal 1} and this will break
the communication with the nodes.
}
\examples{
\dontrun{
# cluster functions for multicore execution on the local machine
makeClusterFunctionsSSH(list(Worker$new("localhost", ncpus = 2)))
}
}
\seealso{
Other ClusterFunctions: \code{\link{makeClusterFunctionsDocker}},
  \code{\link{makeClusterFunctionsInteractive}},
  \code{\link{makeClusterFunctionsLSF}},
  \code{\link{makeClusterFunctionsMulticore}},
  \code{\link{makeClusterFunctionsOpenLava}},
  \code{\link{makeClusterFunctionsSGE}},
  \code{\link{makeClusterFunctionsSlurm}},
  \code{\link{makeClusterFunctionsSocket}},
  \code{\link{makeClusterFunctionsTorque}},
  \code{\link{makeClusterFunctions}}
}

