% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/b_linear.R
\name{b_linear}
\alias{b_linear}
\title{b_linear}
\usage{
b_linear(
  x,
  y,
  s,
  priors = NULL,
  warmup = 1000,
  iter = 2000,
  chains = 4,
  seed = NULL,
  refresh = NULL,
  control = NULL,
  suppress_warnings = TRUE
)
}
\arguments{
\item{x}{a vector containing sequence indexes (time).}

\item{y}{a vector containing responses of subjects.}

\item{s}{a vector containing subject indexes. Starting index should be 1 and the largest subject index should equal the number of subjects.}

\item{priors}{List of parameters and their priors - b_prior objects. You can put a prior on the mu_a (mean intercept), sigma_a (variance of mu_a), mu_b (mean slope), sigma_s (variance of mu_b), mu_s (variance) and sigma_s (variance of mu_s) parameters (default = NULL).}

\item{warmup}{Integer specifying the number of warmup iterations per chain (default = 1000).}

\item{iter}{Integer specifying the number of iterations (including warmup, default = 2000).}

\item{chains}{Integer specifying the number of parallel chains (default = 4).}

\item{seed}{Random number generator seed (default = NULL).}

\item{refresh}{Frequency of output (default = NULL).}

\item{control}{A named list of parameters to control the sampler's behavior (default = NULL).}

\item{suppress_warnings}{Suppress warnings returned by Stan (default = TRUE).}
}
\value{
An object of class `linear_class`.
}
\description{
Bayesian model for fitting a linear normal model to data.
}
\examples{
\donttest{
# priors
mu_prior <- b_prior(family="normal", pars=c(0, 100))
sigma_prior <- b_prior(family="uniform", pars=c(0, 500))

# attach priors to relevant parameters
priors <- list(c("mu_a", mu_prior),
               c("sigma_a", sigma_prior),
               c("mu_b", mu_prior),
               c("sigma_b", sigma_prior),
               c("mu_s", sigma_prior),
               c("sigma_s", sigma_prior))

# generate data
x <- vector()
y <- vector()
s <- vector()
for (i in 1:5) {
  x <- c(x, rep(1:10, 2))
  y <- c(y, rnorm(20, mean=1:10, sd=2))
  s <- c(s, rep(i, 20))
}

fit <- b_linear(x=x, y=y, s=s, priors=priors, chains=1)
}

}
