% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotDists.R
\name{plotGamma}
\alias{plotGamma}
\title{Plot the PDF of the Gamma distribution.}
\usage{
plotGamma(shape, rate, area = 0.99)
}
\arguments{
\item{shape}{shape (\eqn{\alpha}) parameter of the Gamma distribution.}

\item{rate}{rate (\eqn{\beta}) parameter of the Gamma distribution.}

\item{area}{control x-axis limits (default is set to view 99\% of the area under the density curve)}
}
\value{
The PDF of Gamma(shape, rate).
}
\description{
Plot the PDF of the Gamma distribution.
}
\details{
Note: We use the shape/rate parametrization of Gamma. See https://en.wikipedia.org/wiki/Gamma_distribution for details.
}
\examples{
plotGamma(1, 1)
plotGamma(2, 5)
}

