% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bandit.R
\name{deployBandit}
\alias{deployBandit}
\title{Deploy a bayesBandit object as a JSON API.}
\usage{
deployBandit(bandit, port = 8000)
}
\arguments{
\item{bandit}{a bayesBandit object}

\item{port}{port to deploy on}
}
\value{
An active \code{http} process on some port.
}
\description{
Turn your bayesBandit object into an API and serve/update requests through HTTP.
}
\details{
\code{deployBandit} turns a Bayesian bandit into a JSON API that accepts curl requests. Two of the five methods of 
bayesBandit classes are exposed: \code{serveRecipe} and \code{setResults}. Assuming the API is deployed on \code{localhost} this is an
example of how it would be hit:

\deqn{curl http://localhost:8000/serveRecipe}

\deqn{curl --data '{"A":[1, 0, 1, 1], "B":[0, 0, 0, 1]}' http://localhost:8000/setResults}
}
\examples{
A_binom <- rbinom(100, 1, .5)
B_binom <- rbinom(100, 1, .6)

AB1 <- bayesTest(A_binom, B_binom, priors = c('alpha' = 1, 'beta' = 1), distribution = 'bernoulli')

binomialBandit <- banditize(AB1)
\dontrun{deployBandit(binomialBandit)}

}

