% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bdpsurvival.R
\name{bdpsurvival}
\alias{bdpsurvival}
\alias{bdpsurvival,ANY-method}
\title{Bayesian Discount Prior: Survival Analysis}
\usage{
bdpsurvival(formula = formula, data = data, breaks = NULL, a0 = 0.1,
  b0 = 0.1, surv_time = NULL, alpha_max = 1, fix_alpha = FALSE,
  number_mcmc = 10000, weibull_scale = 0.135, weibull_shape = 3,
  two_side = TRUE)
}
\arguments{
\item{formula}{an object of class "formula." Must have a survival object on
the left side and exactly two inputs on the right side: treatment and
historical. See "Details" for more information.}

\item{data}{data frame. A data frame with columns 'time', 'status',
'treatment', and historical.' See "Details" for required structure.}

\item{breaks}{vector. Breaks (interval starts) used to compose the breaks of the
piecewise exponential model. Do not include zero.}

\item{a0}{scalar. Prior value for the gamma shape. Default is 1.}

\item{b0}{scalar. Prior value for the gamma rate. Default is 1.}

\item{surv_time}{scalar. Survival time of interest for computing the the
probability of survival for a single arm (OPC) trial. Default is
overall, i.e., current+historical, median survival time.}

\item{alpha_max}{scalar. Maximum weight the discount function can apply.
Default is 1. For a two-arm trial, users may specify a vector of two values
where the first value is used to weight the historical treatment group and
the second value is used to weight the historical control group.}

\item{fix_alpha}{logical. Fix alpha at alpha_max? Default value is FALSE.}

\item{number_mcmc}{scalar. Number of Markov Chain Monte Carlo (MCMC)
simulations. Default is 10000.}

\item{weibull_scale}{scalar. Scale parameter of the Weibull discount function
used to compute alpha, the weight parameter of the historical data. Default
value is 0.135. For a two-arm trial, users may specify a vector of two
values where the first value is used to estimate the weight of the
historical treatment group and the second value is used to estimate the
weight of the historical control group.}

\item{weibull_shape}{scalar. Shape parameter of the Weibull discount function
used to compute alpha, the weight parameter of the historical data. Default
value is 3. For a two-arm trial, users may specify a vector of two values
where the first value is used to estimate the weight of the historical
treatment group and the second value is used to estimate the weight of the
historical control group.}

\item{two_side}{logical. Indicator of two-sided test for the discount
function. Default value is TRUE.}
}
\value{
\code{bdpsurvival} returns an object of class "bdpsurvival".
The functions \code{summary} and \code{print} are used to obtain and
print a summary of the results, including user inputs. The \code{plot}
function displays visual outputs as well.

An object of class "\code{bdpsurvival}" is a list containing at least
the following components:
\describe{
 \item{\code{posterior_treatment}}{
   list. Entries contain values related to the treatment group:}
   \itemize{
     \item{\code{alpha_discount}}{
       numeric. Alpha value, the weighting parameter of the historical data.}
     \item{\code{p_hat}}{
       numeric. The posterior probability of the stochastic comparison
       between the current and historical data.}
     \item{\code{posterior}}{
       list. Entries contain \code{cdf}, a vector of the posterior cdf of the
       piecewise exponentialdistribution; \code{surv_time_posterior}, a
       vector with the posterior of the survival probability; and
       \code{posterior}, a matrix of the posteriors of each of the piecewise
       hazards.}
     \item{\code{posterior_flat}}{
       matrix. The distributions of the current treatment group piecewise
       hazard rates.}
     \item{\code{prior}}{
       matrix. The distributions of the historical treatment group piecewise
       hazard rates.}
  }
 \item{\code{f1}}{
   list. Entries contain values related to the posterior effect:}
   \itemize{
     \item{\code{density_post_treatment}}{
       object of class \code{density}. Used internally to plot the density of
       the treatment group posterior.}
     \item{\code{density_flat_treatment}}{
       object of class \code{density}. Used internally to plot the density of
       the treatment group "flat" distribution.}
     \item{\code{density_prior_treatment}}{
       object of class \code{density}. Used internally to plot the density of
       the treatment group prior.}
     \item{\code{treatmentpost}}{
       vector. Used internally to plot the posterior distribution of the
       survival probability.}
  }
 \item{\code{args1}}{
   list. Entries contain user inputs. In addition, the following elements
   are ouput:}
   \itemize{
     \item{\code{S_t} and \code{S0_t}}{
       survival objects. Used internally pass survival data between
       functions.}
  }
}
}
\description{
\code{bdpsurvival} is used to estimate the survival probability
  (single arm trial; OPC) or hazard ratio (two-arm trial; RCT) for
  right-censored data using the survival analysis implementation of the
  Bayesian discount prior.
}
\details{
\code{bdpsurvival} uses a two-stage approach for determining the
  strength of historical data in estimation of a survival probability outcome.
  In the first stage, a Weibull distribution function is used as a
  \emph{discount function} that defines the maximum strength of the
  historical data (via \code{weibull_shape}, \code{weibull_scale}, and
  \code{alpha_max}) and discounts based on disagreement with the current data.
  Disagreement between current and historical data is determined by stochastically
  comparing the respective posterior distributions under noninformative priors.
  With a single arm survival data analysis, the comparison is the
  proability (\code{p}) that the current survial is less than the historical
  survival. The comparison metric \code{p} is then
  input into the Weibull discount function and the final strength of the
  historical data is returned (alpha).

In the second stage, posterior estimation is performed where the discount
  function parameter, \code{alpha}, is used as a fixed value for all posterior
  estimation procedures.

 To carry out a single arm (OPC) analysis, data for the current and
 historical treatments are specified in a dataframe. The dataframe must have
 columns with names 'time', 'status', 'treatment', and 'historical.' Column
 'time' is the survival (censor) time of the event and 'status' is the
 event indicator. The column 'treatment' is used to indicate which observations
 are in the treatment and control group. A value of 1 indicates that the
 observation is in the treatment group. The column 'historical' indicates
 whether the observation is from the historical data (1) or current data (0).
 The results are then based on the posterior distribution of the current data
 augmented by the historical data.

 Two-arm (RCT) analyses are not available with this release.
}
\examples{
# One-arm trial (OPC) example
# Simulate survival data for a single arm (OPC) trial
time   <- c(rexp(50, rate=1/20), rexp(50, rate=1/10))
status <- c(rexp(50, rate=1/30), rexp(50, rate=1/30))
status <- ifelse(time < status, 1, 0)

# Collect data into a dataframe
example_surv_1arm <- data.frame(status     = status,
                                time       = time,
                                historical = c(rep(1,50),rep(0,50)),
                                treatment  = 1)

fitSurv <- bdpsurvival(Surv(time, status) ~ historical + treatment,
                       data = example_surv_1arm)

summary(fitSurv)


}
