% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllMethods.R
\name{predict}
\alias{predict}
\alias{predict,bayesGAMfit-method}
\title{Posterior predictive samples from models fit by \code{bayesGAM}, but with new data}
\usage{
\S4method{predict}{bayesGAMfit}(object, newdata, draws = NULL, ...)
}
\arguments{
\item{object}{Object of type \code{bayesGAMfit} generated from \code{bayesGAM}.}

\item{newdata}{A data frame with new data applied to the \code{bayesGAMfit} object}

\item{draws}{An integer indicating the number of draws to return. The default and maximum number of draws is the size of the posterior sample.}

\item{...}{Additional arguments for \code{postrior_predict}}
}
\value{
a list of \emph{D} by \emph{N} matrices, where \emph{D} is the number of draws from the posterior predictive distribution and \emph{N} is the number of data points being predicted per draw.
}
\description{
Draw from the posterior predictive distribution applied to new data
}
\examples{
set.seed(432)
f <- bayesGAM(weight ~ np(height), data = women,
              family = gaussian, iter=500, chains = 1)
newheights <- with(women, rnorm(10, mean = mean(height)), sd=sd(height))
women2 <- data.frame(height=newheights)

pred <- predict(f, women2, draws=100)
}
\references{
Goodrich B, Gabry J, Ali I & Brilleman S. (2020). rstanarm: Bayesian applied regression modeling via Stan. R package version 2.19.3 https://mc-stan.org/rstanarm.

Jonah Gabry, Ben Goodrich and Martin Lysy (2020). rstantools: Tools for Developing R Packages Interfacing with 'Stan'. https://mc-stan.org/rstantools/, https://discourse.mc-stan.org/.
}
