% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auto_sarima.R
\name{auto.sarima}
\alias{auto.sarima}
\title{Automatic estimate of a Seasonal ARIMA model}
\usage{
auto.sarima(ts,xreg = NULL,chains=4,iter=4000,warmup=floor(iter/2),
                adapt.delta = 0.9,tree.depth =10,stepwise = TRUE, series.name = NULL,
                prior_mu0 = NULL,prior_sigma0 = NULL,prior_ar = NULL, prior_ma = NULL,
                prior_sar = NULL,prior_sma = NULL, prior_breg = NULL,...)
}
\arguments{
\item{ts}{a numeric or ts object with the univariate time series.}

\item{xreg}{Optionally, a numerical matrix of external regressors,
which must have the same number of rows as ts. It should not be a data frame.}

\item{chains}{An integer of the number of Markov Chains chains to be run,
by default 4 chains are run.}

\item{iter}{An integer of total iterations per chain including the warm-up,
by default  the number of iterations are 2000.}

\item{warmup}{A positive integer specifying number of warm-up (aka burn-in)
iterations. This also specifies the number of iterations used for step-size
adaptation, so warm-up samples should not be used for inference. The number
of warmup should not be larger than \code{iter} and the default is
\code{iter/2}.}

\item{adapt.delta}{An optional real value between 0 and 1, the thin of the jumps
in a HMC method. By default is 0.9.}

\item{tree.depth}{An integer of the maximum  depth of the trees  evaluated
during each iteration. By default is 10.}

\item{stepwise}{If TRUE, will do stepwise selection (faster). Otherwise, it searches
over all models. Non-stepwise selection can be very slow, especially for seasonal models.}

\item{series.name}{an optional string vector with the series names.}

\item{prior_mu0}{The prior distribution for the location parameter in an ARIMA model. By default
the value is set \code{NULL}, then the default student(7,0,1) prior is used.}

\item{prior_sigma0}{The prior distribution for the scale parameter in an ARIMA model. By default
the value is set \code{NULL}, then the default student(7,0,1) prior is used.}

\item{prior_ar}{The prior distribution for the auto-regressive parameters in an ARIMA model.
By default the value is set \code{NULL}, then the default normal(0,0.5) priors are used.}

\item{prior_ma}{The prior distribution for the moving average parameters in an ARIMA model.
By default the value is set \code{NULL}, then the default normal(0,0.5) priors are used.}

\item{prior_sar}{The prior distribution for the seasonal auto-regressive parameters in a
SARIMA model. By default the value is set \code{NULL}, then the default normal(0,0.5) priors
are used.}

\item{prior_sma}{The prior distribution for the seasonal moving average parameters in a
SARIMA model. By default the value is set \code{NULL}, then the default normal(0,0.5) priors
are used.}

\item{prior_breg}{The prior distribution for the regression coefficient parameters in a
ARIMAX model. By default the value is set \code{NULL}, then the default student(7,0,1) priors
are used.}

\item{...}{Further arguments passed to  \code{auto.arima} function.}
}
\value{
A varstan object with the "best" fitted ARIMA model to the data
}
\description{
Returns the best seasonal ARIMA model using a \code{bic} value, this
function the\code{auto.arima} function of the \pkg{forecast} package
to select the seasonal ARIMA model and estimates the model using a
HMC sampler.
}
\details{
Automatic ARIMA model fitting implemented by Rob Hyndman, this function finds the best
Seasonal ARIMA model using \code{bic}, and then proceeds to fit the model using
\code{varstan} function and the default priors of a \code{Sarima} model constructor.

This function provides an initial model fit for beginning the Bayesian analysis
of the univariate time series. For better fit and model selection try different
models and other model selection criteria such as \code{loo} or \code{bayes_factor}.

The default arguments are designed for rapid estimation of models for many time series.
If you are analyzing just one time series, and can afford to take some more time, it is
recommended that you set \code{stepwise}=\code{FALSE} and reduce the number of iterations
per chain (\code{iter}).

For more information look at \code{auto.arima()} function of forecast package.
}
\examples{
\donttest{
 # Automatic Sarima model for the birth data
 auto.sarima(birth)

 # Dynamic Harmonic regression
 auto.sarima(birth,xreg = fourier(birth,K= 6))
}

}
\references{
Hyndman, R. & Khandakar, Y. (2008). Automatic time series forecasting: the
forecast package for \code{R}. \emph{Journal of Statistical Software}. 26(3),
1-22.\code{doi:	10.18637/jss.v027.i03}.

Box, G. E. P. and Jenkins, G.M. (1978). Time series analysis: Forecasting and
control. San Francisco: Holden-Day. \emph{Biometrika}, 60(2), 297-303.
\code{doi:10.1093/biomet/65.2.297}.

Kennedy, P. (1992). Forecasting with dynamic regression models: Alan Pankratz, 1991.
\emph{International Journal of Forecasting}. 8(4), 647-648.
\code{url: https://EconPapers.repec.org/RePEc:eee:intfor:v:8:y:1992:i:4:p:647-648}.
}
\seealso{
\code{Sarima} \code{varstan}.
}
\author{
Asael Alonzo Matamoros
}
