// Generated by rstantools.  Do not edit by hand.

/*
    Bforecast is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Bforecast is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Bforecast.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.21.0
#include <stan/model/model_header.hpp>
namespace model_SVM_namespace {
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;
static int current_statement_begin__;
stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_SVM");
    reader.add_event(178, 176, "end", "model_SVM");
    return reader;
}
#include <stan_meta_header.hpp>
class model_SVM
  : public stan::model::model_base_crtp<model_SVM> {
private:
        int n;
        int p;
        int q;
        int d1;
        matrix_d xreg;
        vector_d y;
        vector_d prior_mu0;
        vector_d prior_sigma0;
        matrix_d prior_ar;
        matrix_d prior_ma;
        matrix_d prior_beta;
        matrix_d prior_alpha;
        matrix_d prior_breg;
public:
    model_SVM(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, 0, pstream__);
    }
    model_SVM(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, random_seed__, pstream__);
    }
    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning
        current_statement_begin__ = -1;
        static const char* function__ = "model_SVM_namespace::model_SVM";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        try {
            // initialize data block variables from context__
            current_statement_begin__ = 2;
            context__.validate_dims("data initialization", "n", "int", context__.to_vec());
            n = int(0);
            vals_i__ = context__.vals_i("n");
            pos__ = 0;
            n = vals_i__[pos__++];
            check_greater_or_equal(function__, "n", n, 0);
            current_statement_begin__ = 3;
            context__.validate_dims("data initialization", "p", "int", context__.to_vec());
            p = int(0);
            vals_i__ = context__.vals_i("p");
            pos__ = 0;
            p = vals_i__[pos__++];
            check_greater_or_equal(function__, "p", p, 0);
            current_statement_begin__ = 4;
            context__.validate_dims("data initialization", "q", "int", context__.to_vec());
            q = int(0);
            vals_i__ = context__.vals_i("q");
            pos__ = 0;
            q = vals_i__[pos__++];
            check_greater_or_equal(function__, "q", q, 0);
            current_statement_begin__ = 5;
            context__.validate_dims("data initialization", "d1", "int", context__.to_vec());
            d1 = int(0);
            vals_i__ = context__.vals_i("d1");
            pos__ = 0;
            d1 = vals_i__[pos__++];
            check_greater_or_equal(function__, "d1", d1, 0);
            current_statement_begin__ = 6;
            validate_non_negative_index("xreg", "n", n);
            validate_non_negative_index("xreg", "d1", d1);
            context__.validate_dims("data initialization", "xreg", "matrix_d", context__.to_vec(n,d1));
            xreg = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(n, d1);
            vals_r__ = context__.vals_r("xreg");
            pos__ = 0;
            size_t xreg_j_2_max__ = d1;
            size_t xreg_j_1_max__ = n;
            for (size_t j_2__ = 0; j_2__ < xreg_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < xreg_j_1_max__; ++j_1__) {
                    xreg(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 7;
            validate_non_negative_index("y", "n", n);
            context__.validate_dims("data initialization", "y", "vector_d", context__.to_vec(n));
            y = Eigen::Matrix<double, Eigen::Dynamic, 1>(n);
            vals_r__ = context__.vals_r("y");
            pos__ = 0;
            size_t y_j_1_max__ = n;
            for (size_t j_1__ = 0; j_1__ < y_j_1_max__; ++j_1__) {
                y(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 9;
            validate_non_negative_index("prior_mu0", "4", 4);
            context__.validate_dims("data initialization", "prior_mu0", "vector_d", context__.to_vec(4));
            prior_mu0 = Eigen::Matrix<double, Eigen::Dynamic, 1>(4);
            vals_r__ = context__.vals_r("prior_mu0");
            pos__ = 0;
            size_t prior_mu0_j_1_max__ = 4;
            for (size_t j_1__ = 0; j_1__ < prior_mu0_j_1_max__; ++j_1__) {
                prior_mu0(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 10;
            validate_non_negative_index("prior_sigma0", "4", 4);
            context__.validate_dims("data initialization", "prior_sigma0", "vector_d", context__.to_vec(4));
            prior_sigma0 = Eigen::Matrix<double, Eigen::Dynamic, 1>(4);
            vals_r__ = context__.vals_r("prior_sigma0");
            pos__ = 0;
            size_t prior_sigma0_j_1_max__ = 4;
            for (size_t j_1__ = 0; j_1__ < prior_sigma0_j_1_max__; ++j_1__) {
                prior_sigma0(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 11;
            validate_non_negative_index("prior_ar", "p", p);
            validate_non_negative_index("prior_ar", "4", 4);
            context__.validate_dims("data initialization", "prior_ar", "matrix_d", context__.to_vec(p,4));
            prior_ar = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(p, 4);
            vals_r__ = context__.vals_r("prior_ar");
            pos__ = 0;
            size_t prior_ar_j_2_max__ = 4;
            size_t prior_ar_j_1_max__ = p;
            for (size_t j_2__ = 0; j_2__ < prior_ar_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < prior_ar_j_1_max__; ++j_1__) {
                    prior_ar(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 12;
            validate_non_negative_index("prior_ma", "q", q);
            validate_non_negative_index("prior_ma", "4", 4);
            context__.validate_dims("data initialization", "prior_ma", "matrix_d", context__.to_vec(q,4));
            prior_ma = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(q, 4);
            vals_r__ = context__.vals_r("prior_ma");
            pos__ = 0;
            size_t prior_ma_j_2_max__ = 4;
            size_t prior_ma_j_1_max__ = q;
            for (size_t j_2__ = 0; j_2__ < prior_ma_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < prior_ma_j_1_max__; ++j_1__) {
                    prior_ma(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 13;
            validate_non_negative_index("prior_beta", "1", 1);
            validate_non_negative_index("prior_beta", "4", 4);
            context__.validate_dims("data initialization", "prior_beta", "matrix_d", context__.to_vec(1,4));
            prior_beta = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(1, 4);
            vals_r__ = context__.vals_r("prior_beta");
            pos__ = 0;
            size_t prior_beta_j_2_max__ = 4;
            size_t prior_beta_j_1_max__ = 1;
            for (size_t j_2__ = 0; j_2__ < prior_beta_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < prior_beta_j_1_max__; ++j_1__) {
                    prior_beta(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 14;
            validate_non_negative_index("prior_alpha", "1", 1);
            validate_non_negative_index("prior_alpha", "4", 4);
            context__.validate_dims("data initialization", "prior_alpha", "matrix_d", context__.to_vec(1,4));
            prior_alpha = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(1, 4);
            vals_r__ = context__.vals_r("prior_alpha");
            pos__ = 0;
            size_t prior_alpha_j_2_max__ = 4;
            size_t prior_alpha_j_1_max__ = 1;
            for (size_t j_2__ = 0; j_2__ < prior_alpha_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < prior_alpha_j_1_max__; ++j_1__) {
                    prior_alpha(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 15;
            validate_non_negative_index("prior_breg", "d1", d1);
            validate_non_negative_index("prior_breg", "4", 4);
            context__.validate_dims("data initialization", "prior_breg", "matrix_d", context__.to_vec(d1,4));
            prior_breg = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(d1, 4);
            vals_r__ = context__.vals_r("prior_breg");
            pos__ = 0;
            size_t prior_breg_j_2_max__ = 4;
            size_t prior_breg_j_1_max__ = d1;
            for (size_t j_2__ = 0; j_2__ < prior_breg_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < prior_breg_j_1_max__; ++j_1__) {
                    prior_breg(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            // initialize transformed data variables
            // execute transformed data statements
            // validate transformed data
            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 18;
            num_params_r__ += 1;
            current_statement_begin__ = 19;
            num_params_r__ += 1;
            current_statement_begin__ = 20;
            validate_non_negative_index("breg", "d1", d1);
            num_params_r__ += d1;
            current_statement_begin__ = 21;
            validate_non_negative_index("ar0", "p", p);
            num_params_r__ += p;
            current_statement_begin__ = 22;
            validate_non_negative_index("ma0", "q", q);
            num_params_r__ += q;
            current_statement_begin__ = 23;
            num_params_r__ += 1;
            current_statement_begin__ = 24;
            num_params_r__ += 1;
            current_statement_begin__ = 25;
            validate_non_negative_index("hstd", "n", n);
            num_params_r__ += n;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    ~model_SVM() { }
    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        typedef double local_scalar_t__;
        stan::io::writer<double> writer__(params_r__, params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;
        current_statement_begin__ = 18;
        if (!(context__.contains_r("mu0")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable mu0 missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("mu0");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "mu0", "double", context__.to_vec());
        double mu0(0);
        mu0 = vals_r__[pos__++];
        try {
            writer__.scalar_unconstrain(mu0);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable mu0: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 19;
        if (!(context__.contains_r("alpha")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable alpha missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("alpha");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "alpha", "double", context__.to_vec());
        double alpha(0);
        alpha = vals_r__[pos__++];
        try {
            writer__.scalar_unconstrain(alpha);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable alpha: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 20;
        if (!(context__.contains_r("breg")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable breg missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("breg");
        pos__ = 0U;
        validate_non_negative_index("breg", "d1", d1);
        context__.validate_dims("parameter initialization", "breg", "vector_d", context__.to_vec(d1));
        Eigen::Matrix<double, Eigen::Dynamic, 1> breg(d1);
        size_t breg_j_1_max__ = d1;
        for (size_t j_1__ = 0; j_1__ < breg_j_1_max__; ++j_1__) {
            breg(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(breg);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable breg: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 21;
        if (!(context__.contains_r("ar0")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable ar0 missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("ar0");
        pos__ = 0U;
        validate_non_negative_index("ar0", "p", p);
        context__.validate_dims("parameter initialization", "ar0", "vector_d", context__.to_vec(p));
        Eigen::Matrix<double, Eigen::Dynamic, 1> ar0(p);
        size_t ar0_j_1_max__ = p;
        for (size_t j_1__ = 0; j_1__ < ar0_j_1_max__; ++j_1__) {
            ar0(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_lub_unconstrain(-(1), 1, ar0);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable ar0: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 22;
        if (!(context__.contains_r("ma0")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable ma0 missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("ma0");
        pos__ = 0U;
        validate_non_negative_index("ma0", "q", q);
        context__.validate_dims("parameter initialization", "ma0", "vector_d", context__.to_vec(q));
        Eigen::Matrix<double, Eigen::Dynamic, 1> ma0(q);
        size_t ma0_j_1_max__ = q;
        for (size_t j_1__ = 0; j_1__ < ma0_j_1_max__; ++j_1__) {
            ma0(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_lub_unconstrain(-(1), 1, ma0);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable ma0: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 23;
        if (!(context__.contains_r("beta0")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable beta0 missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("beta0");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "beta0", "double", context__.to_vec());
        double beta0(0);
        beta0 = vals_r__[pos__++];
        try {
            writer__.scalar_lub_unconstrain(-(1), 1, beta0);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable beta0: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 24;
        if (!(context__.contains_r("sigma0")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable sigma0 missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("sigma0");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "sigma0", "double", context__.to_vec());
        double sigma0(0);
        sigma0 = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0, sigma0);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable sigma0: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 25;
        if (!(context__.contains_r("hstd")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable hstd missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("hstd");
        pos__ = 0U;
        validate_non_negative_index("hstd", "n", n);
        context__.validate_dims("parameter initialization", "hstd", "vector_d", context__.to_vec(n));
        Eigen::Matrix<double, Eigen::Dynamic, 1> hstd(n);
        size_t hstd_j_1_max__ = n;
        for (size_t j_1__ = 0; j_1__ < hstd_j_1_max__; ++j_1__) {
            hstd(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(hstd);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable hstd: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }
    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }
    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(std::vector<T__>& params_r__,
                 std::vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {
        typedef T__ local_scalar_t__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // dummy to suppress unused var warning
        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;
        try {
            stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
            // model parameters
            current_statement_begin__ = 18;
            local_scalar_t__ mu0;
            (void) mu0;  // dummy to suppress unused var warning
            if (jacobian__)
                mu0 = in__.scalar_constrain(lp__);
            else
                mu0 = in__.scalar_constrain();
            current_statement_begin__ = 19;
            local_scalar_t__ alpha;
            (void) alpha;  // dummy to suppress unused var warning
            if (jacobian__)
                alpha = in__.scalar_constrain(lp__);
            else
                alpha = in__.scalar_constrain();
            current_statement_begin__ = 20;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> breg;
            (void) breg;  // dummy to suppress unused var warning
            if (jacobian__)
                breg = in__.vector_constrain(d1, lp__);
            else
                breg = in__.vector_constrain(d1);
            current_statement_begin__ = 21;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> ar0;
            (void) ar0;  // dummy to suppress unused var warning
            if (jacobian__)
                ar0 = in__.vector_lub_constrain(-(1), 1, p, lp__);
            else
                ar0 = in__.vector_lub_constrain(-(1), 1, p);
            current_statement_begin__ = 22;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> ma0;
            (void) ma0;  // dummy to suppress unused var warning
            if (jacobian__)
                ma0 = in__.vector_lub_constrain(-(1), 1, q, lp__);
            else
                ma0 = in__.vector_lub_constrain(-(1), 1, q);
            current_statement_begin__ = 23;
            local_scalar_t__ beta0;
            (void) beta0;  // dummy to suppress unused var warning
            if (jacobian__)
                beta0 = in__.scalar_lub_constrain(-(1), 1, lp__);
            else
                beta0 = in__.scalar_lub_constrain(-(1), 1);
            current_statement_begin__ = 24;
            local_scalar_t__ sigma0;
            (void) sigma0;  // dummy to suppress unused var warning
            if (jacobian__)
                sigma0 = in__.scalar_lb_constrain(0, lp__);
            else
                sigma0 = in__.scalar_lb_constrain(0);
            current_statement_begin__ = 25;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> hstd;
            (void) hstd;  // dummy to suppress unused var warning
            if (jacobian__)
                hstd = in__.vector_constrain(n, lp__);
            else
                hstd = in__.vector_constrain(n);
            // transformed parameters
            current_statement_begin__ = 29;
            validate_non_negative_index("ar", "p", p);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> ar(p);
            stan::math::initialize(ar, DUMMY_VAR__);
            stan::math::fill(ar, DUMMY_VAR__);
            current_statement_begin__ = 30;
            validate_non_negative_index("ma", "q", q);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> ma(q);
            stan::math::initialize(ma, DUMMY_VAR__);
            stan::math::fill(ma, DUMMY_VAR__);
            current_statement_begin__ = 31;
            local_scalar_t__ beta;
            (void) beta;  // dummy to suppress unused var warning
            stan::math::initialize(beta, DUMMY_VAR__);
            stan::math::fill(beta, DUMMY_VAR__);
            current_statement_begin__ = 33;
            validate_non_negative_index("mu", "n", n);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> mu(n);
            stan::math::initialize(mu, DUMMY_VAR__);
            stan::math::fill(mu, DUMMY_VAR__);
            current_statement_begin__ = 34;
            validate_non_negative_index("epsilon", "n", n);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> epsilon(n);
            stan::math::initialize(epsilon, DUMMY_VAR__);
            stan::math::fill(epsilon, DUMMY_VAR__);
            current_statement_begin__ = 35;
            validate_non_negative_index("h", "n", n);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> h(n);
            stan::math::initialize(h, DUMMY_VAR__);
            stan::math::fill(h, DUMMY_VAR__);
            stan::math::assign(h,multiply(hstd, sigma0));
            // transformed parameters block statements
            current_statement_begin__ = 41;
            for (int i = 1; i <= p; ++i) {
                current_statement_begin__ = 42;
                if (as_bool(logical_eq(get_base1(prior_ar, i, 4, "prior_ar", 1), 1))) {
                    current_statement_begin__ = 42;
                    stan::model::assign(ar, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                get_base1(ar0, i, "ar0", 1), 
                                "assigning variable ar");
                } else {
                    current_statement_begin__ = 43;
                    stan::model::assign(ar, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                ((2 * get_base1(ar0, i, "ar0", 1)) - 1), 
                                "assigning variable ar");
                }
            }
            current_statement_begin__ = 45;
            for (int i = 1; i <= q; ++i) {
                current_statement_begin__ = 46;
                if (as_bool(logical_eq(get_base1(prior_ma, i, 4, "prior_ma", 1), 1))) {
                    current_statement_begin__ = 46;
                    stan::model::assign(ma, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                get_base1(ma0, i, "ma0", 1), 
                                "assigning variable ma");
                } else {
                    current_statement_begin__ = 47;
                    stan::model::assign(ma, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                ((2 * get_base1(ma0, i, "ma0", 1)) - 1), 
                                "assigning variable ma");
                }
            }
            current_statement_begin__ = 50;
            if (as_bool(logical_eq(get_base1(prior_beta, 1, 4, "prior_beta", 1), 1))) {
                current_statement_begin__ = 50;
                stan::math::assign(beta, beta0);
            } else {
                current_statement_begin__ = 51;
                stan::math::assign(beta, ((2 * beta0) - 1));
            }
            current_statement_begin__ = 54;
            if (as_bool(logical_gt(d1, 0))) {
                current_statement_begin__ = 54;
                stan::math::assign(mu, add(mu0, multiply(xreg, breg)));
            } else {
                current_statement_begin__ = 55;
                stan::math::assign(mu, rep_vector(0, n));
            }
            current_statement_begin__ = 58;
            stan::model::assign(mu, 
                        stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                        mu0, 
                        "assigning variable mu");
            current_statement_begin__ = 59;
            stan::model::assign(h, 
                        stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                        (stan::model::rvalue(h, stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), "h") + alpha), 
                        "assigning variable h");
            current_statement_begin__ = 60;
            stan::model::assign(epsilon, 
                        stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                        (get_base1(y, 1, "y", 1) - get_base1(mu, 1, "mu", 1)), 
                        "assigning variable epsilon");
            current_statement_begin__ = 63;
            for (int i = 2; i <= n; ++i) {
                current_statement_begin__ = 64;
                stan::model::assign(mu, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            mu0, 
                            "assigning variable mu");
                current_statement_begin__ = 65;
                stan::model::assign(h, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            (stan::model::rvalue(h, stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), "h") + alpha), 
                            "assigning variable h");
                current_statement_begin__ = 67;
                if (as_bool(logical_gt(p, 0))) {
                    current_statement_begin__ = 67;
                    for (int j = 1; j <= p; ++j) {
                        current_statement_begin__ = 67;
                        if (as_bool(logical_gt(i, j))) {
                            current_statement_begin__ = 67;
                            stan::model::assign(mu, 
                                        stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                        (stan::model::rvalue(mu, stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), "mu") + (get_base1(y, (i - j), "y", 1) * get_base1(ar, j, "ar", 1))), 
                                        "assigning variable mu");
                        }
                    }
                }
                current_statement_begin__ = 69;
                if (as_bool(logical_gt(q, 0))) {
                    current_statement_begin__ = 69;
                    for (int j = 1; j <= q; ++j) {
                        current_statement_begin__ = 69;
                        if (as_bool(logical_gt(i, j))) {
                            current_statement_begin__ = 69;
                            stan::model::assign(mu, 
                                        stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                        (stan::model::rvalue(mu, stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), "mu") + (get_base1(epsilon, (i - j), "epsilon", 1) * get_base1(ma, j, "ma", 1))), 
                                        "assigning variable mu");
                        }
                    }
                }
                current_statement_begin__ = 70;
                stan::model::assign(epsilon, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            (get_base1(y, i, "y", 1) - get_base1(mu, i, "mu", 1)), 
                            "assigning variable epsilon");
                current_statement_begin__ = 72;
                stan::model::assign(h, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            (stan::model::rvalue(h, stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), "h") + (beta * (get_base1(h, (i - 1), "h", 1) - alpha))), 
                            "assigning variable h");
            }
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 29;
            size_t ar_j_1_max__ = p;
            for (size_t j_1__ = 0; j_1__ < ar_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(ar(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: ar" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable ar: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 30;
            size_t ma_j_1_max__ = q;
            for (size_t j_1__ = 0; j_1__ < ma_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(ma(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: ma" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable ma: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 31;
            if (stan::math::is_uninitialized(beta)) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: beta";
                stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable beta: ") + msg__.str()), current_statement_begin__, prog_reader__());
            }
            current_statement_begin__ = 33;
            size_t mu_j_1_max__ = n;
            for (size_t j_1__ = 0; j_1__ < mu_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(mu(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: mu" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable mu: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 34;
            size_t epsilon_j_1_max__ = n;
            for (size_t j_1__ = 0; j_1__ < epsilon_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(epsilon(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: epsilon" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable epsilon: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 35;
            size_t h_j_1_max__ = n;
            for (size_t j_1__ = 0; j_1__ < h_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(h(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: h" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable h: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            // model body
            current_statement_begin__ = 77;
            if (as_bool(logical_eq(get_base1(prior_mu0, 4, "prior_mu0", 1), 1))) {
                current_statement_begin__ = 77;
                lp_accum__.add(normal_log(mu0, get_base1(prior_mu0, 1, "prior_mu0", 1), get_base1(prior_mu0, 2, "prior_mu0", 1)));
            } else if (as_bool(logical_eq(get_base1(prior_mu0, 4, "prior_mu0", 1), 2))) {
                current_statement_begin__ = 78;
                lp_accum__.add(beta_log(mu0, get_base1(prior_mu0, 1, "prior_mu0", 1), get_base1(prior_mu0, 2, "prior_mu0", 1)));
            } else if (as_bool(logical_eq(get_base1(prior_mu0, 4, "prior_mu0", 1), 3))) {
                current_statement_begin__ = 79;
                lp_accum__.add(uniform_log(mu0, get_base1(prior_mu0, 1, "prior_mu0", 1), get_base1(prior_mu0, 2, "prior_mu0", 1)));
            } else if (as_bool(logical_eq(get_base1(prior_mu0, 4, "prior_mu0", 1), 4))) {
                current_statement_begin__ = 80;
                lp_accum__.add(student_t_log(mu0, get_base1(prior_mu0, 3, "prior_mu0", 1), get_base1(prior_mu0, 1, "prior_mu0", 1), get_base1(prior_mu0, 2, "prior_mu0", 1)));
            } else if (as_bool(logical_eq(get_base1(prior_mu0, 4, "prior_mu0", 1), 5))) {
                current_statement_begin__ = 81;
                lp_accum__.add(cauchy_log(mu0, get_base1(prior_mu0, 1, "prior_mu0", 1), get_base1(prior_mu0, 2, "prior_mu0", 1)));
            } else if (as_bool(logical_eq(get_base1(prior_mu0, 4, "prior_mu0", 1), 6))) {
                current_statement_begin__ = 82;
                lp_accum__.add(inv_gamma_log(mu0, get_base1(prior_mu0, 1, "prior_mu0", 1), get_base1(prior_mu0, 2, "prior_mu0", 1)));
            } else if (as_bool(logical_eq(get_base1(prior_mu0, 4, "prior_mu0", 1), 7))) {
                current_statement_begin__ = 83;
                lp_accum__.add(inv_chi_square_log(mu0, get_base1(prior_mu0, 3, "prior_mu0", 1)));
            } else if (as_bool(logical_eq(get_base1(prior_mu0, 4, "prior_mu0", 1), 8))) {
                current_statement_begin__ = 84;
                lp_accum__.add(-(stan::math::log(sigma0)));
            } else if (as_bool(logical_eq(get_base1(prior_mu0, 4, "prior_mu0", 1), 9))) {
                current_statement_begin__ = 85;
                lp_accum__.add(gamma_log(mu0, get_base1(prior_mu0, 1, "prior_mu0", 1), get_base1(prior_mu0, 2, "prior_mu0", 1)));
            } else if (as_bool(logical_eq(get_base1(prior_mu0, 4, "prior_mu0", 1), 10))) {
                current_statement_begin__ = 86;
                lp_accum__.add(exponential_log(mu0, get_base1(prior_mu0, 2, "prior_mu0", 1)));
            } else if (as_bool(logical_eq(get_base1(prior_mu0, 4, "prior_mu0", 1), 11))) {
                current_statement_begin__ = 87;
                lp_accum__.add(chi_square_log(mu0, get_base1(prior_mu0, 3, "prior_mu0", 1)));
            } else if (as_bool(logical_eq(get_base1(prior_mu0, 4, "prior_mu0", 1), 12))) {
                current_statement_begin__ = 88;
                lp_accum__.add(double_exponential_log(mu0, get_base1(prior_mu0, 1, "prior_mu0", 1), get_base1(prior_mu0, 2, "prior_mu0", 1)));
            }
            current_statement_begin__ = 91;
            if (as_bool(logical_eq(get_base1(prior_sigma0, 4, "prior_sigma0", 1), 1))) {
                current_statement_begin__ = 91;
                lp_accum__.add(normal_log(sigma0, get_base1(prior_sigma0, 1, "prior_sigma0", 1), get_base1(prior_sigma0, 2, "prior_sigma0", 1)));
            } else if (as_bool(logical_eq(get_base1(prior_sigma0, 4, "prior_sigma0", 1), 2))) {
                current_statement_begin__ = 92;
                lp_accum__.add(beta_log(sigma0, get_base1(prior_sigma0, 1, "prior_sigma0", 1), get_base1(prior_sigma0, 2, "prior_sigma0", 1)));
            } else if (as_bool(logical_eq(get_base1(prior_sigma0, 4, "prior_sigma0", 1), 3))) {
                current_statement_begin__ = 93;
                lp_accum__.add(uniform_log(sigma0, get_base1(prior_sigma0, 1, "prior_sigma0", 1), get_base1(prior_sigma0, 2, "prior_sigma0", 1)));
            } else if (as_bool(logical_eq(get_base1(prior_sigma0, 4, "prior_sigma0", 1), 4))) {
                current_statement_begin__ = 94;
                lp_accum__.add(student_t_log(sigma0, get_base1(prior_sigma0, 3, "prior_sigma0", 1), get_base1(prior_sigma0, 1, "prior_sigma0", 1), get_base1(prior_sigma0, 2, "prior_sigma0", 1)));
            } else if (as_bool(logical_eq(get_base1(prior_sigma0, 4, "prior_sigma0", 1), 5))) {
                current_statement_begin__ = 95;
                lp_accum__.add(cauchy_log(sigma0, get_base1(prior_sigma0, 1, "prior_sigma0", 1), get_base1(prior_sigma0, 2, "prior_sigma0", 1)));
            } else if (as_bool(logical_eq(get_base1(prior_sigma0, 4, "prior_sigma0", 1), 6))) {
                current_statement_begin__ = 96;
                lp_accum__.add(inv_gamma_log(sigma0, get_base1(prior_sigma0, 1, "prior_sigma0", 1), get_base1(prior_sigma0, 2, "prior_sigma0", 1)));
            } else if (as_bool(logical_eq(get_base1(prior_sigma0, 4, "prior_sigma0", 1), 7))) {
                current_statement_begin__ = 97;
                lp_accum__.add(inv_chi_square_log(sigma0, get_base1(prior_sigma0, 3, "prior_sigma0", 1)));
            } else if (as_bool(logical_eq(get_base1(prior_sigma0, 4, "prior_sigma0", 1), 8))) {
                current_statement_begin__ = 98;
                lp_accum__.add(-(stan::math::log(sigma0)));
            } else if (as_bool(logical_eq(get_base1(prior_sigma0, 4, "prior_sigma0", 1), 9))) {
                current_statement_begin__ = 99;
                lp_accum__.add(gamma_log(sigma0, get_base1(prior_sigma0, 1, "prior_sigma0", 1), get_base1(prior_sigma0, 2, "prior_sigma0", 1)));
            } else if (as_bool(logical_eq(get_base1(prior_sigma0, 4, "prior_sigma0", 1), 10))) {
                current_statement_begin__ = 100;
                lp_accum__.add(exponential_log(sigma0, get_base1(prior_sigma0, 2, "prior_sigma0", 1)));
            } else if (as_bool(logical_eq(get_base1(prior_sigma0, 4, "prior_sigma0", 1), 11))) {
                current_statement_begin__ = 101;
                lp_accum__.add(chi_square_log(sigma0, get_base1(prior_sigma0, 3, "prior_sigma0", 1)));
            } else if (as_bool(logical_eq(get_base1(prior_sigma0, 4, "prior_sigma0", 1), 12))) {
                current_statement_begin__ = 102;
                lp_accum__.add(double_exponential_log(sigma0, get_base1(prior_sigma0, 1, "prior_sigma0", 1), get_base1(prior_sigma0, 2, "prior_sigma0", 1)));
            }
            current_statement_begin__ = 105;
            if (as_bool(logical_gt(d1, 0))) {
                current_statement_begin__ = 106;
                for (int i = 1; i <= d1; ++i) {
                    current_statement_begin__ = 107;
                    if (as_bool(logical_eq(get_base1(prior_breg, i, 4, "prior_breg", 1), 1))) {
                        current_statement_begin__ = 107;
                        lp_accum__.add(normal_log(get_base1(breg, i, "breg", 1), get_base1(prior_breg, i, 1, "prior_breg", 1), get_base1(prior_breg, i, 2, "prior_breg", 1)));
                    } else if (as_bool(logical_eq(get_base1(prior_breg, i, 4, "prior_breg", 1), 2))) {
                        current_statement_begin__ = 108;
                        lp_accum__.add(beta_log(get_base1(breg, i, "breg", 1), get_base1(prior_breg, i, 1, "prior_breg", 1), get_base1(prior_breg, i, 2, "prior_breg", 1)));
                    } else if (as_bool(logical_eq(get_base1(prior_breg, i, 4, "prior_breg", 1), 3))) {
                        current_statement_begin__ = 109;
                        lp_accum__.add(uniform_log(get_base1(breg, i, "breg", 1), get_base1(prior_breg, i, 1, "prior_breg", 1), get_base1(prior_breg, i, 2, "prior_breg", 1)));
                    } else if (as_bool(logical_eq(get_base1(prior_breg, i, 4, "prior_breg", 1), 4))) {
                        current_statement_begin__ = 110;
                        lp_accum__.add(student_t_log(get_base1(breg, i, "breg", 1), get_base1(prior_breg, i, 3, "prior_breg", 1), get_base1(prior_breg, i, 1, "prior_breg", 1), get_base1(prior_breg, i, 2, "prior_breg", 1)));
                    } else if (as_bool(logical_eq(get_base1(prior_breg, i, 4, "prior_breg", 1), 5))) {
                        current_statement_begin__ = 111;
                        lp_accum__.add(cauchy_log(get_base1(breg, i, "breg", 1), get_base1(prior_breg, i, 1, "prior_breg", 1), get_base1(prior_breg, i, 2, "prior_breg", 1)));
                    } else if (as_bool(logical_eq(get_base1(prior_breg, i, 4, "prior_breg", 1), 6))) {
                        current_statement_begin__ = 112;
                        lp_accum__.add(inv_gamma_log(get_base1(breg, i, "breg", 1), get_base1(prior_breg, i, 1, "prior_breg", 1), get_base1(prior_breg, i, 2, "prior_breg", 1)));
                    } else if (as_bool(logical_eq(get_base1(prior_breg, i, 4, "prior_breg", 1), 7))) {
                        current_statement_begin__ = 113;
                        lp_accum__.add(inv_chi_square_log(get_base1(breg, i, "breg", 1), get_base1(prior_breg, i, 3, "prior_breg", 1)));
                    } else if (as_bool(logical_eq(get_base1(prior_breg, i, 4, "prior_breg", 1), 8))) {
                        current_statement_begin__ = 114;
                        lp_accum__.add(-(stan::math::log(sigma0)));
                    } else if (as_bool(logical_eq(get_base1(prior_breg, i, 4, "prior_breg", 1), 9))) {
                        current_statement_begin__ = 115;
                        lp_accum__.add(gamma_log(get_base1(breg, i, "breg", 1), get_base1(prior_breg, i, 1, "prior_breg", 1), get_base1(prior_breg, i, 2, "prior_breg", 1)));
                    } else if (as_bool(logical_eq(get_base1(prior_breg, i, 4, "prior_breg", 1), 10))) {
                        current_statement_begin__ = 116;
                        lp_accum__.add(exponential_log(get_base1(breg, i, "breg", 1), get_base1(prior_breg, i, 2, "prior_breg", 1)));
                    } else if (as_bool(logical_eq(get_base1(prior_breg, i, 4, "prior_breg", 1), 11))) {
                        current_statement_begin__ = 117;
                        lp_accum__.add(chi_square_log(get_base1(breg, i, "breg", 1), get_base1(prior_breg, i, 3, "prior_breg", 1)));
                    } else if (as_bool(logical_eq(get_base1(prior_breg, i, 4, "prior_breg", 1), 12))) {
                        current_statement_begin__ = 118;
                        lp_accum__.add(double_exponential_log(get_base1(breg, i, "breg", 1), get_base1(prior_breg, i, 1, "prior_breg", 1), get_base1(prior_breg, i, 2, "prior_breg", 1)));
                    }
                }
            }
            current_statement_begin__ = 123;
            if (as_bool(logical_gt(p, 0))) {
                current_statement_begin__ = 124;
                for (int i = 1; i <= p; ++i) {
                    current_statement_begin__ = 125;
                    if (as_bool(logical_eq(get_base1(prior_ar, i, 4, "prior_ar", 1), 1))) {
                        current_statement_begin__ = 125;
                        lp_accum__.add(normal_log(get_base1(ar0, i, "ar0", 1), get_base1(prior_ar, i, 1, "prior_ar", 1), get_base1(prior_ar, i, 2, "prior_ar", 1)));
                    } else if (as_bool(logical_eq(get_base1(prior_ar, i, 4, "prior_ar", 1), 2))) {
                        current_statement_begin__ = 126;
                        lp_accum__.add(beta_log(stan::math::fabs(get_base1(ar0, i, "ar0", 1)), get_base1(prior_ar, i, 1, "prior_ar", 1), get_base1(prior_ar, i, 2, "prior_ar", 1)));
                    } else if (as_bool(logical_eq(get_base1(prior_ar, i, 4, "prior_ar", 1), 3))) {
                        current_statement_begin__ = 127;
                        lp_accum__.add(uniform_log(get_base1(ar0, i, "ar0", 1), get_base1(prior_ar, i, 1, "prior_ar", 1), get_base1(prior_ar, i, 2, "prior_ar", 1)));
                    }
                }
            }
            current_statement_begin__ = 131;
            if (as_bool(logical_gt(q, 0))) {
                current_statement_begin__ = 132;
                for (int i = 1; i <= q; ++i) {
                    current_statement_begin__ = 133;
                    if (as_bool(logical_eq(get_base1(prior_ma, i, 4, "prior_ma", 1), 1))) {
                        current_statement_begin__ = 133;
                        lp_accum__.add(normal_log(get_base1(ma0, i, "ma0", 1), get_base1(prior_ma, i, 1, "prior_ma", 1), get_base1(prior_ma, i, 2, "prior_ma", 1)));
                    } else if (as_bool(logical_eq(get_base1(prior_ma, i, 4, "prior_ma", 1), 2))) {
                        current_statement_begin__ = 134;
                        lp_accum__.add(beta_log(stan::math::fabs(get_base1(ma0, i, "ma0", 1)), get_base1(prior_ma, i, 1, "prior_ma", 1), get_base1(prior_ma, i, 2, "prior_ma", 1)));
                    } else if (as_bool(logical_eq(get_base1(prior_ma, i, 4, "prior_ma", 1), 3))) {
                        current_statement_begin__ = 135;
                        lp_accum__.add(uniform_log(get_base1(ma0, i, "ma0", 1), get_base1(prior_ma, i, 1, "prior_ma", 1), get_base1(prior_ma, i, 2, "prior_ma", 1)));
                    }
                }
            }
            current_statement_begin__ = 139;
            if (as_bool(logical_eq(get_base1(prior_alpha, 1, 4, "prior_alpha", 1), 1))) {
                current_statement_begin__ = 139;
                lp_accum__.add(normal_log(alpha, get_base1(prior_alpha, 1, 1, "prior_alpha", 1), get_base1(prior_alpha, 1, 2, "prior_alpha", 1)));
            } else if (as_bool(logical_eq(get_base1(prior_alpha, 1, 4, "prior_alpha", 1), 2))) {
                current_statement_begin__ = 140;
                lp_accum__.add(beta_log(alpha, get_base1(prior_alpha, 1, 1, "prior_alpha", 1), get_base1(prior_alpha, 1, 2, "prior_alpha", 1)));
            } else if (as_bool(logical_eq(get_base1(prior_alpha, 1, 4, "prior_alpha", 1), 3))) {
                current_statement_begin__ = 141;
                lp_accum__.add(uniform_log(alpha, get_base1(prior_alpha, 1, 1, "prior_alpha", 1), get_base1(prior_alpha, 1, 2, "prior_alpha", 1)));
            } else if (as_bool(logical_eq(get_base1(prior_alpha, 1, 4, "prior_alpha", 1), 4))) {
                current_statement_begin__ = 142;
                lp_accum__.add(student_t_log(alpha, get_base1(prior_alpha, 1, 3, "prior_alpha", 1), get_base1(prior_alpha, 1, 1, "prior_alpha", 1), get_base1(prior_alpha, 1, 2, "prior_alpha", 1)));
            } else if (as_bool(logical_eq(get_base1(prior_alpha, 1, 4, "prior_alpha", 1), 5))) {
                current_statement_begin__ = 143;
                lp_accum__.add(cauchy_log(alpha, get_base1(prior_alpha, 1, 1, "prior_alpha", 1), get_base1(prior_alpha, 1, 2, "prior_alpha", 1)));
            } else if (as_bool(logical_eq(get_base1(prior_alpha, 1, 4, "prior_alpha", 1), 6))) {
                current_statement_begin__ = 144;
                lp_accum__.add(inv_gamma_log(alpha, get_base1(prior_alpha, 1, 1, "prior_alpha", 1), get_base1(prior_alpha, 1, 2, "prior_alpha", 1)));
            } else if (as_bool(logical_eq(get_base1(prior_alpha, 1, 4, "prior_alpha", 1), 7))) {
                current_statement_begin__ = 145;
                lp_accum__.add(inv_chi_square_log(alpha, get_base1(prior_alpha, 1, 3, "prior_alpha", 1)));
            } else if (as_bool(logical_eq(get_base1(prior_alpha, 1, 4, "prior_alpha", 1), 8))) {
                current_statement_begin__ = 146;
                lp_accum__.add(-(stan::math::log(sigma0)));
            } else if (as_bool(logical_eq(get_base1(prior_alpha, 1, 4, "prior_alpha", 1), 9))) {
                current_statement_begin__ = 147;
                lp_accum__.add(gamma_log(alpha, get_base1(prior_alpha, 1, 1, "prior_alpha", 1), get_base1(prior_alpha, 1, 2, "prior_alpha", 1)));
            } else if (as_bool(logical_eq(get_base1(prior_alpha, 1, 4, "prior_alpha", 1), 10))) {
                current_statement_begin__ = 148;
                lp_accum__.add(exponential_log(alpha, get_base1(prior_alpha, 1, 2, "prior_alpha", 1)));
            } else if (as_bool(logical_eq(get_base1(prior_alpha, 1, 4, "prior_alpha", 1), 11))) {
                current_statement_begin__ = 149;
                lp_accum__.add(chi_square_log(alpha, get_base1(prior_alpha, 1, 3, "prior_alpha", 1)));
            } else if (as_bool(logical_eq(get_base1(prior_alpha, 1, 4, "prior_alpha", 1), 12))) {
                current_statement_begin__ = 150;
                lp_accum__.add(double_exponential_log(alpha, get_base1(prior_alpha, 1, 1, "prior_alpha", 1), get_base1(prior_alpha, 1, 2, "prior_alpha", 1)));
            }
            current_statement_begin__ = 153;
            if (as_bool(logical_eq(get_base1(prior_beta, 1, 4, "prior_beta", 1), 1))) {
                current_statement_begin__ = 153;
                lp_accum__.add(normal_log(beta0, get_base1(prior_beta, 1, 1, "prior_beta", 1), get_base1(prior_beta, 1, 2, "prior_beta", 1)));
            } else if (as_bool(logical_eq(get_base1(prior_beta, 1, 4, "prior_beta", 1), 2))) {
                current_statement_begin__ = 154;
                lp_accum__.add(beta_log(beta0, get_base1(prior_beta, 1, 1, "prior_beta", 1), get_base1(prior_beta, 1, 2, "prior_beta", 1)));
            } else if (as_bool(logical_eq(get_base1(prior_beta, 1, 4, "prior_beta", 1), 3))) {
                current_statement_begin__ = 155;
                lp_accum__.add(uniform_log(beta0, get_base1(prior_beta, 1, 1, "prior_beta", 1), get_base1(prior_beta, 1, 2, "prior_beta", 1)));
            }
            current_statement_begin__ = 159;
            lp_accum__.add(normal_log(hstd, 0, 1));
            current_statement_begin__ = 161;
            lp_accum__.add(normal_log(epsilon, 0, stan::math::exp(divide(h, 2))));
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
        lp_accum__.add(lp__);
        return lp_accum__.sum();
    } // log_prob()
    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }
    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("mu0");
        names__.push_back("alpha");
        names__.push_back("breg");
        names__.push_back("ar0");
        names__.push_back("ma0");
        names__.push_back("beta0");
        names__.push_back("sigma0");
        names__.push_back("hstd");
        names__.push_back("ar");
        names__.push_back("ma");
        names__.push_back("beta");
        names__.push_back("mu");
        names__.push_back("epsilon");
        names__.push_back("h");
        names__.push_back("sigma");
        names__.push_back("fit");
        names__.push_back("residuals");
        names__.push_back("log_lik");
        names__.push_back("loglik");
    }
    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(d1);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(p);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(q);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(p);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(q);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
    }
    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;
        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
        static const char* function__ = "model_SVM_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        double mu0 = in__.scalar_constrain();
        vars__.push_back(mu0);
        double alpha = in__.scalar_constrain();
        vars__.push_back(alpha);
        Eigen::Matrix<double, Eigen::Dynamic, 1> breg = in__.vector_constrain(d1);
        size_t breg_j_1_max__ = d1;
        for (size_t j_1__ = 0; j_1__ < breg_j_1_max__; ++j_1__) {
            vars__.push_back(breg(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> ar0 = in__.vector_lub_constrain(-(1), 1, p);
        size_t ar0_j_1_max__ = p;
        for (size_t j_1__ = 0; j_1__ < ar0_j_1_max__; ++j_1__) {
            vars__.push_back(ar0(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> ma0 = in__.vector_lub_constrain(-(1), 1, q);
        size_t ma0_j_1_max__ = q;
        for (size_t j_1__ = 0; j_1__ < ma0_j_1_max__; ++j_1__) {
            vars__.push_back(ma0(j_1__));
        }
        double beta0 = in__.scalar_lub_constrain(-(1), 1);
        vars__.push_back(beta0);
        double sigma0 = in__.scalar_lb_constrain(0);
        vars__.push_back(sigma0);
        Eigen::Matrix<double, Eigen::Dynamic, 1> hstd = in__.vector_constrain(n);
        size_t hstd_j_1_max__ = n;
        for (size_t j_1__ = 0; j_1__ < hstd_j_1_max__; ++j_1__) {
            vars__.push_back(hstd(j_1__));
        }
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        if (!include_tparams__ && !include_gqs__) return;
        try {
            // declare and define transformed parameters
            current_statement_begin__ = 29;
            validate_non_negative_index("ar", "p", p);
            Eigen::Matrix<double, Eigen::Dynamic, 1> ar(p);
            stan::math::initialize(ar, DUMMY_VAR__);
            stan::math::fill(ar, DUMMY_VAR__);
            current_statement_begin__ = 30;
            validate_non_negative_index("ma", "q", q);
            Eigen::Matrix<double, Eigen::Dynamic, 1> ma(q);
            stan::math::initialize(ma, DUMMY_VAR__);
            stan::math::fill(ma, DUMMY_VAR__);
            current_statement_begin__ = 31;
            double beta;
            (void) beta;  // dummy to suppress unused var warning
            stan::math::initialize(beta, DUMMY_VAR__);
            stan::math::fill(beta, DUMMY_VAR__);
            current_statement_begin__ = 33;
            validate_non_negative_index("mu", "n", n);
            Eigen::Matrix<double, Eigen::Dynamic, 1> mu(n);
            stan::math::initialize(mu, DUMMY_VAR__);
            stan::math::fill(mu, DUMMY_VAR__);
            current_statement_begin__ = 34;
            validate_non_negative_index("epsilon", "n", n);
            Eigen::Matrix<double, Eigen::Dynamic, 1> epsilon(n);
            stan::math::initialize(epsilon, DUMMY_VAR__);
            stan::math::fill(epsilon, DUMMY_VAR__);
            current_statement_begin__ = 35;
            validate_non_negative_index("h", "n", n);
            Eigen::Matrix<double, Eigen::Dynamic, 1> h(n);
            stan::math::initialize(h, DUMMY_VAR__);
            stan::math::fill(h, DUMMY_VAR__);
            stan::math::assign(h,multiply(hstd, sigma0));
            // do transformed parameters statements
            current_statement_begin__ = 41;
            for (int i = 1; i <= p; ++i) {
                current_statement_begin__ = 42;
                if (as_bool(logical_eq(get_base1(prior_ar, i, 4, "prior_ar", 1), 1))) {
                    current_statement_begin__ = 42;
                    stan::model::assign(ar, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                get_base1(ar0, i, "ar0", 1), 
                                "assigning variable ar");
                } else {
                    current_statement_begin__ = 43;
                    stan::model::assign(ar, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                ((2 * get_base1(ar0, i, "ar0", 1)) - 1), 
                                "assigning variable ar");
                }
            }
            current_statement_begin__ = 45;
            for (int i = 1; i <= q; ++i) {
                current_statement_begin__ = 46;
                if (as_bool(logical_eq(get_base1(prior_ma, i, 4, "prior_ma", 1), 1))) {
                    current_statement_begin__ = 46;
                    stan::model::assign(ma, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                get_base1(ma0, i, "ma0", 1), 
                                "assigning variable ma");
                } else {
                    current_statement_begin__ = 47;
                    stan::model::assign(ma, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                ((2 * get_base1(ma0, i, "ma0", 1)) - 1), 
                                "assigning variable ma");
                }
            }
            current_statement_begin__ = 50;
            if (as_bool(logical_eq(get_base1(prior_beta, 1, 4, "prior_beta", 1), 1))) {
                current_statement_begin__ = 50;
                stan::math::assign(beta, beta0);
            } else {
                current_statement_begin__ = 51;
                stan::math::assign(beta, ((2 * beta0) - 1));
            }
            current_statement_begin__ = 54;
            if (as_bool(logical_gt(d1, 0))) {
                current_statement_begin__ = 54;
                stan::math::assign(mu, add(mu0, multiply(xreg, breg)));
            } else {
                current_statement_begin__ = 55;
                stan::math::assign(mu, rep_vector(0, n));
            }
            current_statement_begin__ = 58;
            stan::model::assign(mu, 
                        stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                        mu0, 
                        "assigning variable mu");
            current_statement_begin__ = 59;
            stan::model::assign(h, 
                        stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                        (stan::model::rvalue(h, stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), "h") + alpha), 
                        "assigning variable h");
            current_statement_begin__ = 60;
            stan::model::assign(epsilon, 
                        stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                        (get_base1(y, 1, "y", 1) - get_base1(mu, 1, "mu", 1)), 
                        "assigning variable epsilon");
            current_statement_begin__ = 63;
            for (int i = 2; i <= n; ++i) {
                current_statement_begin__ = 64;
                stan::model::assign(mu, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            mu0, 
                            "assigning variable mu");
                current_statement_begin__ = 65;
                stan::model::assign(h, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            (stan::model::rvalue(h, stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), "h") + alpha), 
                            "assigning variable h");
                current_statement_begin__ = 67;
                if (as_bool(logical_gt(p, 0))) {
                    current_statement_begin__ = 67;
                    for (int j = 1; j <= p; ++j) {
                        current_statement_begin__ = 67;
                        if (as_bool(logical_gt(i, j))) {
                            current_statement_begin__ = 67;
                            stan::model::assign(mu, 
                                        stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                        (stan::model::rvalue(mu, stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), "mu") + (get_base1(y, (i - j), "y", 1) * get_base1(ar, j, "ar", 1))), 
                                        "assigning variable mu");
                        }
                    }
                }
                current_statement_begin__ = 69;
                if (as_bool(logical_gt(q, 0))) {
                    current_statement_begin__ = 69;
                    for (int j = 1; j <= q; ++j) {
                        current_statement_begin__ = 69;
                        if (as_bool(logical_gt(i, j))) {
                            current_statement_begin__ = 69;
                            stan::model::assign(mu, 
                                        stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                        (stan::model::rvalue(mu, stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), "mu") + (get_base1(epsilon, (i - j), "epsilon", 1) * get_base1(ma, j, "ma", 1))), 
                                        "assigning variable mu");
                        }
                    }
                }
                current_statement_begin__ = 70;
                stan::model::assign(epsilon, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            (get_base1(y, i, "y", 1) - get_base1(mu, i, "mu", 1)), 
                            "assigning variable epsilon");
                current_statement_begin__ = 72;
                stan::model::assign(h, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            (stan::model::rvalue(h, stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), "h") + (beta * (get_base1(h, (i - 1), "h", 1) - alpha))), 
                            "assigning variable h");
            }
            if (!include_gqs__ && !include_tparams__) return;
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            // write transformed parameters
            if (include_tparams__) {
                size_t ar_j_1_max__ = p;
                for (size_t j_1__ = 0; j_1__ < ar_j_1_max__; ++j_1__) {
                    vars__.push_back(ar(j_1__));
                }
                size_t ma_j_1_max__ = q;
                for (size_t j_1__ = 0; j_1__ < ma_j_1_max__; ++j_1__) {
                    vars__.push_back(ma(j_1__));
                }
                vars__.push_back(beta);
                size_t mu_j_1_max__ = n;
                for (size_t j_1__ = 0; j_1__ < mu_j_1_max__; ++j_1__) {
                    vars__.push_back(mu(j_1__));
                }
                size_t epsilon_j_1_max__ = n;
                for (size_t j_1__ = 0; j_1__ < epsilon_j_1_max__; ++j_1__) {
                    vars__.push_back(epsilon(j_1__));
                }
                size_t h_j_1_max__ = n;
                for (size_t j_1__ = 0; j_1__ < h_j_1_max__; ++j_1__) {
                    vars__.push_back(h(j_1__));
                }
            }
            if (!include_gqs__) return;
            // declare and define generated quantities
            current_statement_begin__ = 164;
            validate_non_negative_index("sigma", "n", n);
            Eigen::Matrix<double, Eigen::Dynamic, 1> sigma(n);
            stan::math::initialize(sigma, DUMMY_VAR__);
            stan::math::fill(sigma, DUMMY_VAR__);
            stan::math::assign(sigma,stan::math::exp(divide(h, 2)));
            current_statement_begin__ = 165;
            validate_non_negative_index("fit", "n", n);
            Eigen::Matrix<double, Eigen::Dynamic, 1> fit(n);
            stan::math::initialize(fit, DUMMY_VAR__);
            stan::math::fill(fit, DUMMY_VAR__);
            current_statement_begin__ = 166;
            validate_non_negative_index("residuals", "n", n);
            Eigen::Matrix<double, Eigen::Dynamic, 1> residuals(n);
            stan::math::initialize(residuals, DUMMY_VAR__);
            stan::math::fill(residuals, DUMMY_VAR__);
            current_statement_begin__ = 167;
            validate_non_negative_index("log_lik", "n", n);
            Eigen::Matrix<double, Eigen::Dynamic, 1> log_lik(n);
            stan::math::initialize(log_lik, DUMMY_VAR__);
            stan::math::fill(log_lik, DUMMY_VAR__);
            current_statement_begin__ = 168;
            double loglik;
            (void) loglik;  // dummy to suppress unused var warning
            stan::math::initialize(loglik, DUMMY_VAR__);
            stan::math::fill(loglik, DUMMY_VAR__);
            stan::math::assign(loglik,0);
            // generated quantities statements
            current_statement_begin__ = 170;
            for (int i = 1; i <= n; ++i) {
                current_statement_begin__ = 171;
                stan::model::assign(residuals, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            normal_rng(get_base1(epsilon, i, "epsilon", 1), get_base1(sigma, i, "sigma", 1), base_rng__), 
                            "assigning variable residuals");
                current_statement_begin__ = 172;
                stan::model::assign(log_lik, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            normal_log(get_base1(y, i, "y", 1), get_base1(mu, i, "mu", 1), get_base1(sigma, i, "sigma", 1)), 
                            "assigning variable log_lik");
            }
            current_statement_begin__ = 174;
            stan::math::assign(fit, subtract(y, residuals));
            current_statement_begin__ = 175;
            stan::math::assign(loglik, sum(log_lik));
            // validate, write generated quantities
            current_statement_begin__ = 164;
            size_t sigma_j_1_max__ = n;
            for (size_t j_1__ = 0; j_1__ < sigma_j_1_max__; ++j_1__) {
                vars__.push_back(sigma(j_1__));
            }
            current_statement_begin__ = 165;
            size_t fit_j_1_max__ = n;
            for (size_t j_1__ = 0; j_1__ < fit_j_1_max__; ++j_1__) {
                vars__.push_back(fit(j_1__));
            }
            current_statement_begin__ = 166;
            size_t residuals_j_1_max__ = n;
            for (size_t j_1__ = 0; j_1__ < residuals_j_1_max__; ++j_1__) {
                vars__.push_back(residuals(j_1__));
            }
            current_statement_begin__ = 167;
            size_t log_lik_j_1_max__ = n;
            for (size_t j_1__ = 0; j_1__ < log_lik_j_1_max__; ++j_1__) {
                vars__.push_back(log_lik(j_1__));
            }
            current_statement_begin__ = 168;
            vars__.push_back(loglik);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng, params_r_vec, params_i_vec, vars_vec, include_tparams, include_gqs, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }
    std::string model_name() const {
        return "model_SVM";
    }
    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu0";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "alpha";
        param_names__.push_back(param_name_stream__.str());
        size_t breg_j_1_max__ = d1;
        for (size_t j_1__ = 0; j_1__ < breg_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "breg" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t ar0_j_1_max__ = p;
        for (size_t j_1__ = 0; j_1__ < ar0_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "ar0" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t ma0_j_1_max__ = q;
        for (size_t j_1__ = 0; j_1__ < ma0_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "ma0" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "beta0";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma0";
        param_names__.push_back(param_name_stream__.str());
        size_t hstd_j_1_max__ = n;
        for (size_t j_1__ = 0; j_1__ < hstd_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "hstd" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t ar_j_1_max__ = p;
            for (size_t j_1__ = 0; j_1__ < ar_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "ar" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t ma_j_1_max__ = q;
            for (size_t j_1__ = 0; j_1__ < ma_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "ma" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta";
            param_names__.push_back(param_name_stream__.str());
            size_t mu_j_1_max__ = n;
            for (size_t j_1__ = 0; j_1__ < mu_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "mu" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t epsilon_j_1_max__ = n;
            for (size_t j_1__ = 0; j_1__ < epsilon_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "epsilon" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t h_j_1_max__ = n;
            for (size_t j_1__ = 0; j_1__ < h_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "h" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        if (!include_gqs__) return;
        size_t sigma_j_1_max__ = n;
        for (size_t j_1__ = 0; j_1__ < sigma_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t fit_j_1_max__ = n;
        for (size_t j_1__ = 0; j_1__ < fit_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "fit" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t residuals_j_1_max__ = n;
        for (size_t j_1__ = 0; j_1__ < residuals_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "residuals" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t log_lik_j_1_max__ = n;
        for (size_t j_1__ = 0; j_1__ < log_lik_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "loglik";
        param_names__.push_back(param_name_stream__.str());
    }
    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu0";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "alpha";
        param_names__.push_back(param_name_stream__.str());
        size_t breg_j_1_max__ = d1;
        for (size_t j_1__ = 0; j_1__ < breg_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "breg" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t ar0_j_1_max__ = p;
        for (size_t j_1__ = 0; j_1__ < ar0_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "ar0" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t ma0_j_1_max__ = q;
        for (size_t j_1__ = 0; j_1__ < ma0_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "ma0" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "beta0";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma0";
        param_names__.push_back(param_name_stream__.str());
        size_t hstd_j_1_max__ = n;
        for (size_t j_1__ = 0; j_1__ < hstd_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "hstd" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t ar_j_1_max__ = p;
            for (size_t j_1__ = 0; j_1__ < ar_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "ar" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t ma_j_1_max__ = q;
            for (size_t j_1__ = 0; j_1__ < ma_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "ma" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta";
            param_names__.push_back(param_name_stream__.str());
            size_t mu_j_1_max__ = n;
            for (size_t j_1__ = 0; j_1__ < mu_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "mu" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t epsilon_j_1_max__ = n;
            for (size_t j_1__ = 0; j_1__ < epsilon_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "epsilon" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t h_j_1_max__ = n;
            for (size_t j_1__ = 0; j_1__ < h_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "h" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        if (!include_gqs__) return;
        size_t sigma_j_1_max__ = n;
        for (size_t j_1__ = 0; j_1__ < sigma_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t fit_j_1_max__ = n;
        for (size_t j_1__ = 0; j_1__ < fit_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "fit" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t residuals_j_1_max__ = n;
        for (size_t j_1__ = 0; j_1__ < residuals_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "residuals" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t log_lik_j_1_max__ = n;
        for (size_t j_1__ = 0; j_1__ < log_lik_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "loglik";
        param_names__.push_back(param_name_stream__.str());
    }
}; // model
}  // namespace
typedef model_SVM_namespace::model_SVM stan_model;
#ifndef USING_R
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
#endif
#endif
