// Generated by rstantools.  Do not edit by hand.

/*
    bayeslist is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    bayeslist is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with bayeslist.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#ifndef USE_STANC3
#define USE_STANC3
#endif
#include <rstan/rstaninc.hpp>
// Code generated by stanc v2.26.1-4-gd72b68b7-dirty
#include <stan/model/model_header.hpp>
namespace model_model_misreport_cmp_namespace {
inline void validate_positive_index(const char* var_name, const char* expr,
                                    int val) {
  if (val < 1) {
    std::stringstream msg;
    msg << "Found dimension size less than one in simplex declaration"
        << "; variable=" << var_name << "; dimension size expression=" << expr
        << "; expression value=" << val;
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
inline void validate_unit_vector_index(const char* var_name, const char* expr,
                                       int val) {
  if (val <= 1) {
    std::stringstream msg;
    if (val == 1) {
      msg << "Found dimension size one in unit vector declaration."
          << " One-dimensional unit vector is discrete"
          << " but the target distribution must be continuous."
          << " variable=" << var_name << "; dimension size expression=" << expr;
    } else {
      msg << "Found dimension size less than one in unit vector declaration"
          << "; variable=" << var_name << "; dimension size expression=" << expr
          << "; expression value=" << val;
    }
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using std::pow;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::model_base_crtp;
using stan::model::rvalue;
using stan::model::cons_list;
using stan::model::index_uni;
using stan::model::index_max;
using stan::model::index_min;
using stan::model::index_min_max;
using stan::model::index_multi;
using stan::model::index_omni;
using stan::model::nil_index_list;
using namespace stan::math;
using stan::math::pow; 
stan::math::profile_map profiles__;
static int current_statement__= 0;
static const std::vector<string> locations_array__ = {" (found before start of program)",
                                                      " (in 'model_misreport_cmp', line 30, column 1 to column 16)",
                                                      " (in 'model_misreport_cmp', line 31, column 1 to column 41)",
                                                      " (in 'model_misreport_cmp', line 32, column 1 to column 18)",
                                                      " (in 'model_misreport_cmp', line 33, column 1 to column 14)",
                                                      " (in 'model_misreport_cmp', line 34, column 1 to column 10)",
                                                      " (in 'model_misreport_cmp', line 35, column 1 to column 10)",
                                                      " (in 'model_misreport_cmp', line 36, column 1 to column 33)",
                                                      " (in 'model_misreport_cmp', line 39, column 1 to column 17)",
                                                      " (in 'model_misreport_cmp', line 41, column 2 to column 39)",
                                                      " (in 'model_misreport_cmp', line 40, column 15 to line 42, column 2)",
                                                      " (in 'model_misreport_cmp', line 40, column 1 to line 42, column 2)",
                                                      " (in 'model_misreport_cmp', line 45, column 1 to column 23)",
                                                      " (in 'model_misreport_cmp', line 46, column 1 to column 22)",
                                                      " (in 'model_misreport_cmp', line 47, column 1 to column 25)",
                                                      " (in 'model_misreport_cmp', line 48, column 1 to column 21)",
                                                      " (in 'model_misreport_cmp', line 49, column 1 to column 21)",
                                                      " (in 'model_misreport_cmp', line 51, column 2 to column 36)",
                                                      " (in 'model_misreport_cmp', line 50, column 15 to line 52, column 2)",
                                                      " (in 'model_misreport_cmp', line 50, column 1 to line 52, column 2)",
                                                      " (in 'model_misreport_cmp', line 67, column 3 to column 15)",
                                                      " (in 'model_misreport_cmp', line 66, column 9 to line 68, column 3)",
                                                      " (in 'model_misreport_cmp', line 65, column 3 to column 211)",
                                                      " (in 'model_misreport_cmp', line 64, column 57 to line 66, column 3)",
                                                      " (in 'model_misreport_cmp', line 64, column 9 to line 68, column 3)",
                                                      " (in 'model_misreport_cmp', line 63, column 3 to column 374)",
                                                      " (in 'model_misreport_cmp', line 62, column 46 to line 64, column 3)",
                                                      " (in 'model_misreport_cmp', line 62, column 9 to line 68, column 3)",
                                                      " (in 'model_misreport_cmp', line 61, column 3 to column 202)",
                                                      " (in 'model_misreport_cmp', line 60, column 63 to line 62, column 3)",
                                                      " (in 'model_misreport_cmp', line 60, column 9 to line 68, column 3)",
                                                      " (in 'model_misreport_cmp', line 59, column 3 to column 150)",
                                                      " (in 'model_misreport_cmp', line 58, column 59 to line 60, column 3)",
                                                      " (in 'model_misreport_cmp', line 58, column 9 to line 68, column 3)",
                                                      " (in 'model_misreport_cmp', line 57, column 3 to column 197)",
                                                      " (in 'model_misreport_cmp', line 56, column 46 to line 58, column 3)",
                                                      " (in 'model_misreport_cmp', line 56, column 9 to line 68, column 3)",
                                                      " (in 'model_misreport_cmp', line 55, column 3 to column 359)",
                                                      " (in 'model_misreport_cmp', line 54, column 38 to line 56, column 3)",
                                                      " (in 'model_misreport_cmp', line 54, column 2 to line 68, column 3)",
                                                      " (in 'model_misreport_cmp', line 53, column 15 to line 71, column 2)",
                                                      " (in 'model_misreport_cmp', line 53, column 1 to line 71, column 2)",
                                                      " (in 'model_misreport_cmp', line 17, column 1 to column 7)",
                                                      " (in 'model_misreport_cmp', line 18, column 1 to column 7)",
                                                      " (in 'model_misreport_cmp', line 19, column 18 to column 19)",
                                                      " (in 'model_misreport_cmp', line 19, column 1 to column 21)",
                                                      " (in 'model_misreport_cmp', line 20, column 1 to column 7)",
                                                      " (in 'model_misreport_cmp', line 21, column 8 to column 9)",
                                                      " (in 'model_misreport_cmp', line 21, column 10 to column 11)",
                                                      " (in 'model_misreport_cmp', line 21, column 1 to column 15)",
                                                      " (in 'model_misreport_cmp', line 22, column 11 to column 12)",
                                                      " (in 'model_misreport_cmp', line 22, column 1 to column 14)",
                                                      " (in 'model_misreport_cmp', line 23, column 12 to column 13)",
                                                      " (in 'model_misreport_cmp', line 23, column 1 to column 15)",
                                                      " (in 'model_misreport_cmp', line 24, column 19 to column 20)",
                                                      " (in 'model_misreport_cmp', line 24, column 1 to column 22)",
                                                      " (in 'model_misreport_cmp', line 25, column 19 to column 20)",
                                                      " (in 'model_misreport_cmp', line 25, column 1 to column 22)",
                                                      " (in 'model_misreport_cmp', line 30, column 8 to column 9)",
                                                      " (in 'model_misreport_cmp', line 31, column 30 to column 31)",
                                                      " (in 'model_misreport_cmp', line 32, column 8 to column 9)",
                                                      " (in 'model_misreport_cmp', line 39, column 8 to column 9)",
                                                      " (in 'model_misreport_cmp', line 4, column 2 to column 31)",
                                                      " (in 'model_misreport_cmp', line 3, column 16 to line 5, column 2)",
                                                      " (in 'model_misreport_cmp', line 7, column 2 to column 31)",
                                                      " (in 'model_misreport_cmp', line 6, column 16 to line 8, column 2)",
                                                      " (in 'model_misreport_cmp', line 10, column 2 to column 45)",
                                                      " (in 'model_misreport_cmp', line 9, column 46 to line 11, column 2)",
                                                      " (in 'model_misreport_cmp', line 13, column 2 to column 45)",
                                                      " (in 'model_misreport_cmp', line 12, column 46 to line 14, column 2)"};
template <typename T0__>
stan::promote_args_t<T0__>
gd(const T0__& p, std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<T0__>;
  const static bool propto__ = true;
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    current_statement__ = 62;
    return binomial_lpmf<false>(1, 1, p);
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct gd_functor__ {
template <typename T0__>
stan::promote_args_t<T0__>
operator()(const T0__& p, std::ostream* pstream__)  const 
{
return gd(p, pstream__);
}
};
template <typename T0__>
stan::promote_args_t<T0__>
jd(const T0__& p, std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<T0__>;
  const static bool propto__ = true;
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    current_statement__ = 64;
    return binomial_lpmf<false>(1, 1, p);
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct jd_functor__ {
template <typename T0__>
stan::promote_args_t<T0__>
operator()(const T0__& p, std::ostream* pstream__)  const 
{
return jd(p, pstream__);
}
};
template <typename T2__, typename T3__>
stan::promote_args_t<T2__,
T3__>
h0d(const int& y, const int& J, const T2__& alpha, const T3__& beta,
    std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<T2__, T3__>;
  const static bool propto__ = true;
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    current_statement__ = 66;
    return beta_binomial_lpmf<false>(y, J, alpha, beta);
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct h0d_functor__ {
template <typename T2__, typename T3__>
stan::promote_args_t<T2__,
T3__>
operator()(const int& y, const int& J, const T2__& alpha, const T3__& beta,
           std::ostream* pstream__)  const 
{
return h0d(y, J, alpha, beta, pstream__);
}
};
template <typename T2__, typename T3__>
stan::promote_args_t<T2__,
T3__>
h1d(const int& y, const int& J, const T2__& alpha, const T3__& beta,
    std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<T2__, T3__>;
  const static bool propto__ = true;
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    current_statement__ = 68;
    return beta_binomial_lpmf<false>(y, J, alpha, beta);
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct h1d_functor__ {
template <typename T2__, typename T3__>
stan::promote_args_t<T2__,
T3__>
operator()(const int& y, const int& J, const T2__& alpha, const T3__& beta,
           std::ostream* pstream__)  const 
{
return h1d(y, J, alpha, beta, pstream__);
}
};
#include <stan_meta_header.hpp>
class model_model_misreport_cmp final : public model_base_crtp<model_model_misreport_cmp> {
private:
  int N;
  int J;
  std::vector<int> Y;
  int K;
  Eigen::Matrix<double, -1, -1> X;
  std::vector<int> treat;
  std::vector<int> direct;
  std::vector<double> a;
  std::vector<double> b;
 
public:
  ~model_model_misreport_cmp() { }
  
  inline std::string model_name() const final { return "model_model_misreport_cmp"; }
  inline std::vector<std::string> model_compile_info() const noexcept {
    return std::vector<std::string>{"stanc_version = stanc3 v2.26.1-4-gd72b68b7-dirty", "stancflags = "};
  }
  
  
  model_model_misreport_cmp(stan::io::var_context& context__,
                            unsigned int random_seed__ = 0,
                            std::ostream* pstream__ = nullptr) : model_base_crtp(0) {
    using local_scalar_t__ = double ;
    boost::ecuyer1988 base_rng__ = 
        stan::services::util::create_rng(random_seed__, 0);
    (void) base_rng__;  // suppress unused var warning
    static const char* function__ = "model_model_misreport_cmp_namespace::model_model_misreport_cmp";
    (void) function__;  // suppress unused var warning
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      current_statement__ = 42;
      context__.validate_dims("data initialization","N","int",
          context__.to_vec());
      N = std::numeric_limits<int>::min();
      
      current_statement__ = 42;
      N = context__.vals_i("N")[(1 - 1)];
      current_statement__ = 43;
      context__.validate_dims("data initialization","J","int",
          context__.to_vec());
      J = std::numeric_limits<int>::min();
      
      current_statement__ = 43;
      J = context__.vals_i("J")[(1 - 1)];
      current_statement__ = 44;
      validate_non_negative_index("Y", "N", N);
      current_statement__ = 45;
      context__.validate_dims("data initialization","Y","int",
          context__.to_vec(N));
      Y = std::vector<int>(N, std::numeric_limits<int>::min());
      
      current_statement__ = 45;
      assign(Y, nil_index_list(), context__.vals_i("Y"),
        "assigning variable Y");
      current_statement__ = 45;
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        current_statement__ = 45;
        current_statement__ = 45;
        check_greater_or_equal(function__, "Y[sym1__]", Y[(sym1__ - 1)], 0);}
      current_statement__ = 46;
      context__.validate_dims("data initialization","K","int",
          context__.to_vec());
      K = std::numeric_limits<int>::min();
      
      current_statement__ = 46;
      K = context__.vals_i("K")[(1 - 1)];
      current_statement__ = 47;
      validate_non_negative_index("X", "N", N);
      current_statement__ = 48;
      validate_non_negative_index("X", "K", K);
      current_statement__ = 49;
      context__.validate_dims("data initialization","X","double",
          context__.to_vec(N, K));
      X = Eigen::Matrix<double, -1, -1>(N, K);
      stan::math::fill(X, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> X_flat__;
        current_statement__ = 49;
        assign(X_flat__, nil_index_list(), context__.vals_r("X"),
          "assigning variable X_flat__");
        current_statement__ = 49;
        pos__ = 1;
        current_statement__ = 49;
        for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
          current_statement__ = 49;
          for (int sym2__ = 1; sym2__ <= N; ++sym2__) {
            current_statement__ = 49;
            assign(X,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              X_flat__[(pos__ - 1)], "assigning variable X");
            current_statement__ = 49;
            pos__ = (pos__ + 1);}}
      }
      current_statement__ = 50;
      validate_non_negative_index("treat", "N", N);
      current_statement__ = 51;
      context__.validate_dims("data initialization","treat","int",
          context__.to_vec(N));
      treat = std::vector<int>(N, std::numeric_limits<int>::min());
      
      current_statement__ = 51;
      assign(treat, nil_index_list(), context__.vals_i("treat"),
        "assigning variable treat");
      current_statement__ = 52;
      validate_non_negative_index("direct", "N", N);
      current_statement__ = 53;
      context__.validate_dims("data initialization","direct","int",
          context__.to_vec(N));
      direct = std::vector<int>(N, std::numeric_limits<int>::min());
      
      current_statement__ = 53;
      assign(direct, nil_index_list(), context__.vals_i("direct"),
        "assigning variable direct");
      current_statement__ = 54;
      validate_non_negative_index("a", "K", K);
      current_statement__ = 55;
      context__.validate_dims("data initialization","a","double",
          context__.to_vec(K));
      a = std::vector<double>(K, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 55;
      assign(a, nil_index_list(), context__.vals_r("a"),
        "assigning variable a");
      current_statement__ = 55;
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        current_statement__ = 55;
        current_statement__ = 55;
        check_greater_or_equal(function__, "a[sym1__]", a[(sym1__ - 1)], 0);}
      current_statement__ = 56;
      validate_non_negative_index("b", "K", K);
      current_statement__ = 57;
      context__.validate_dims("data initialization","b","double",
          context__.to_vec(K));
      b = std::vector<double>(K, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 57;
      assign(b, nil_index_list(), context__.vals_r("b"),
        "assigning variable b");
      current_statement__ = 57;
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        current_statement__ = 57;
        current_statement__ = 57;
        check_greater_or_equal(function__, "b[sym1__]", b[(sym1__ - 1)], 0);}
      current_statement__ = 58;
      validate_non_negative_index("psi0", "K", K);
      current_statement__ = 59;
      validate_non_negative_index("delta00", "K", K);
      current_statement__ = 60;
      validate_non_negative_index("gamma0", "K", K);
      current_statement__ = 61;
      validate_non_negative_index("delta", "K", K);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    num_params_r__ = 0U;
    
    try {
      num_params_r__ += K;
      num_params_r__ += K;
      num_params_r__ += K;
      num_params_r__ += 1;
      num_params_r__ += 1;
      num_params_r__ += 1;
      num_params_r__ += 1;
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
  }
  template <bool propto__, bool jacobian__, typename VecR, typename VecI, stan::require_vector_like_t<VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline stan::scalar_type_t<VecR> log_prob_impl(VecR& params_r__,
                                                 VecI& params_i__,
                                                 std::ostream* pstream__ = nullptr) const {
    using T__ = stan::scalar_type_t<VecR>;
    using local_scalar_t__ = T__;
    T__ lp__(0.0);
    stan::math::accumulator<T__> lp_accum__;
    static const char* function__ = "model_model_misreport_cmp_namespace::log_prob";
(void) function__;  // suppress unused var warning
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      Eigen::Matrix<local_scalar_t__, -1, 1> psi0;
      psi0 = Eigen::Matrix<local_scalar_t__, -1, 1>(K);
      stan::math::fill(psi0, DUMMY_VAR__);
      
      current_statement__ = 1;
      psi0 = in__.vector(K);
      Eigen::Matrix<local_scalar_t__, -1, 1> delta00;
      delta00 = Eigen::Matrix<local_scalar_t__, -1, 1>(K);
      stan::math::fill(delta00, DUMMY_VAR__);
      
      current_statement__ = 2;
      delta00 = in__.vector(K);
      current_statement__ = 2;
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        current_statement__ = 2;
        if (jacobian__) {
          current_statement__ = 2;
          assign(delta00, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lub_constrain(delta00[(sym1__ - 1)], 0, 1, lp__),
            "assigning variable delta00");
        } else {
          current_statement__ = 2;
          assign(delta00, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lub_constrain(delta00[(sym1__ - 1)], 0, 1),
            "assigning variable delta00");
        }}
      Eigen::Matrix<local_scalar_t__, -1, 1> gamma0;
      gamma0 = Eigen::Matrix<local_scalar_t__, -1, 1>(K);
      stan::math::fill(gamma0, DUMMY_VAR__);
      
      current_statement__ = 3;
      gamma0 = in__.vector(K);
      local_scalar_t__ treat_e;
      treat_e = DUMMY_VAR__;
      
      current_statement__ = 4;
      treat_e = in__.scalar();
      local_scalar_t__ U_e;
      U_e = DUMMY_VAR__;
      
      current_statement__ = 5;
      U_e = in__.scalar();
      local_scalar_t__ Z_e;
      Z_e = DUMMY_VAR__;
      
      current_statement__ = 6;
      Z_e = in__.scalar();
      local_scalar_t__ rho0;
      rho0 = DUMMY_VAR__;
      
      current_statement__ = 7;
      rho0 = in__.scalar();
      current_statement__ = 7;
      if (jacobian__) {
        current_statement__ = 7;
        rho0 = stan::math::lub_constrain(rho0, 0, 1, lp__);
      } else {
        current_statement__ = 7;
        rho0 = stan::math::lub_constrain(rho0, 0, 1);
      }
      Eigen::Matrix<local_scalar_t__, -1, 1> delta;
      delta = Eigen::Matrix<local_scalar_t__, -1, 1>(K);
      stan::math::fill(delta, DUMMY_VAR__);
      
      current_statement__ = 11;
      for (int i = 1; i <= K; ++i) {
        current_statement__ = 9;
        assign(delta, cons_list(index_uni(i), nil_index_list()),
          stan::math::log((1 / ((1 / delta00[(i - 1)]) - 1))),
          "assigning variable delta");}
      {
        current_statement__ = 12;
        lp_accum__.add(normal_lpdf<propto__>(gamma0, 0, 10));
        current_statement__ = 13;
        lp_accum__.add(normal_lpdf<propto__>(psi0, 0, 10));
        current_statement__ = 14;
        lp_accum__.add(normal_lpdf<propto__>(treat_e, 0, 10));
        current_statement__ = 15;
        lp_accum__.add(normal_lpdf<propto__>(U_e, 0, 10));
        current_statement__ = 16;
        lp_accum__.add(normal_lpdf<propto__>(Z_e, 0, 10));
        current_statement__ = 19;
        for (int i = 1; i <= K; ++i) {
          current_statement__ = 17;
          lp_accum__.add(
            beta_lpdf<propto__>(delta00[(i - 1)], (a[(i - 1)] + 1),
              (b[(i - 1)] + 1)));}
        current_statement__ = 41;
        for (int i = 1; i <= N; ++i) {
          current_statement__ = 39;
          if ((primitive_value(logical_eq(treat[(i - 1)], 0)) &&
              primitive_value(logical_eq(direct[(i - 1)], 0)))) {
            current_statement__ = 37;
            lp_accum__.add(
              stan::math::log(
                (((stan::math::exp(
                     jd(
                       inv_logit(
                         multiply(
                           rvalue(X,
                             cons_list(index_uni(i),
                               cons_list(index_omni(), nil_index_list())),
                             "X"), gamma0)), pstream__)) *
                    stan::math::exp(
                      gd(
                        inv_logit(
                          multiply(
                            rvalue(X,
                              cons_list(index_uni(i),
                                cons_list(index_omni(), nil_index_list())),
                              "X"), delta)), pstream__))) *
                   stan::math::exp(
                     h1d(Y[(i - 1)], J,
                       ((inv_logit(
                           ((multiply(
                               rvalue(X,
                                 cons_list(index_uni(i),
                                   cons_list(index_omni(), nil_index_list())),
                                 "X"), psi0) + Z_e) + U_e)) * (1 - rho0)) /
                         rho0),
                       (((1 -
                           inv_logit(
                             ((multiply(
                                 rvalue(X,
                                   cons_list(index_uni(i),
                                     cons_list(index_omni(),
                                       nil_index_list())), "X"), psi0) + Z_e)
                               + U_e))) * (1 - rho0)) / rho0), pstream__))) +
                  ((1 -
                     stan::math::exp(
                       gd(
                         inv_logit(
                           multiply(
                             rvalue(X,
                               cons_list(index_uni(i),
                                 cons_list(index_omni(), nil_index_list())),
                               "X"), delta)), pstream__))) *
                    stan::math::exp(
                      h0d(Y[(i - 1)], J,
                        ((inv_logit(
                            multiply(
                              rvalue(X,
                                cons_list(index_uni(i),
                                  cons_list(index_omni(), nil_index_list())),
                                "X"), psi0)) * (1 - rho0)) / rho0),
                        (((1 -
                            inv_logit(
                              multiply(
                                rvalue(X,
                                  cons_list(index_uni(i),
                                    cons_list(index_omni(), nil_index_list())),
                                  "X"), psi0))) * (1 - rho0)) / rho0), pstream__))))));
          } else {
            current_statement__ = 36;
            if ((primitive_value(logical_eq(treat[(i - 1)], 0)) &&
                primitive_value(logical_eq(direct[(i - 1)], 1)))) {
              current_statement__ = 34;
              lp_accum__.add(
                ((stan::math::log(
                    (1 -
                      stan::math::exp(
                        jd(
                          inv_logit(
                            multiply(
                              rvalue(X,
                                cons_list(index_uni(i),
                                  cons_list(index_omni(), nil_index_list())),
                                "X"), gamma0)), pstream__)))) +
                   gd(
                     inv_logit(
                       multiply(
                         rvalue(X,
                           cons_list(index_uni(i),
                             cons_list(index_omni(), nil_index_list())), "X"),
                         delta)), pstream__)) +
                  h1d(Y[(i - 1)], J,
                    ((inv_logit(
                        (multiply(
                           rvalue(X,
                             cons_list(index_uni(i),
                               cons_list(index_omni(), nil_index_list())),
                             "X"), psi0) + Z_e)) * (1 - rho0)) / rho0),
                    (((1 -
                        inv_logit(
                          (multiply(
                             rvalue(X,
                               cons_list(index_uni(i),
                                 cons_list(index_omni(), nil_index_list())),
                               "X"), psi0) + Z_e))) * (1 - rho0)) / rho0), pstream__)));
            } else {
              current_statement__ = 33;
              if ((primitive_value((primitive_value(
                  logical_eq(treat[(i - 1)], 1)) && primitive_value(
                  logical_eq(direct[(i - 1)], 0)))) && primitive_value(
                  logical_eq(Y[(i - 1)], 0)))) {
                current_statement__ = 31;
                lp_accum__.add(
                  (stan::math::log(
                     (1 -
                       stan::math::exp(
                         gd(
                           inv_logit(
                             multiply(
                               rvalue(X,
                                 cons_list(index_uni(i),
                                   cons_list(index_omni(), nil_index_list())),
                                 "X"), delta)), pstream__)))) +
                    h0d(0, J,
                      ((inv_logit(
                          multiply(
                            rvalue(X,
                              cons_list(index_uni(i),
                                cons_list(index_omni(), nil_index_list())),
                              "X"), psi0)) * (1 - rho0)) / rho0),
                      (((1 -
                          inv_logit(
                            multiply(
                              rvalue(X,
                                cons_list(index_uni(i),
                                  cons_list(index_omni(), nil_index_list())),
                                "X"), psi0))) * (1 - rho0)) / rho0), pstream__)));
              } else {
                current_statement__ = 30;
                if ((primitive_value((primitive_value(
                    logical_eq(treat[(i - 1)], 1)) && primitive_value(
                    logical_eq(direct[(i - 1)], 0)))) && primitive_value(
                    logical_eq(Y[(i - 1)], (J + 1))))) {
                  current_statement__ = 28;
                  lp_accum__.add(
                    ((jd(
                        inv_logit(
                          (multiply(
                             rvalue(X,
                               cons_list(index_uni(i),
                                 cons_list(index_omni(), nil_index_list())),
                               "X"), gamma0) + treat_e)), pstream__) +
                       gd(
                         inv_logit(
                           multiply(
                             rvalue(X,
                               cons_list(index_uni(i),
                                 cons_list(index_omni(), nil_index_list())),
                               "X"), delta)), pstream__)) +
                      h1d(J, J,
                        ((inv_logit(
                            ((multiply(
                                rvalue(X,
                                  cons_list(index_uni(i),
                                    cons_list(index_omni(), nil_index_list())),
                                  "X"), psi0) + Z_e) + U_e)) * (1 - rho0)) /
                          rho0),
                        (((1 -
                            inv_logit(
                              ((multiply(
                                  rvalue(X,
                                    cons_list(index_uni(i),
                                      cons_list(index_omni(),
                                        nil_index_list())), "X"), psi0) +
                                 Z_e) + U_e))) * (1 - rho0)) / rho0), pstream__)));
                } else {
                  current_statement__ = 27;
                  if ((primitive_value(logical_eq(treat[(i - 1)], 1)) &&
                      primitive_value(logical_eq(direct[(i - 1)], 0)))) {
                    current_statement__ = 25;
                    lp_accum__.add(
                      stan::math::log(
                        (((stan::math::exp(
                             jd(
                               inv_logit(
                                 (multiply(
                                    rvalue(X,
                                      cons_list(index_uni(i),
                                        cons_list(index_omni(),
                                          nil_index_list())), "X"), gamma0) +
                                   treat_e)), pstream__)) *
                            stan::math::exp(
                              gd(
                                inv_logit(
                                  multiply(
                                    rvalue(X,
                                      cons_list(index_uni(i),
                                        cons_list(index_omni(),
                                          nil_index_list())), "X"), delta)), pstream__)))
                           *
                           stan::math::exp(
                             h1d((Y[(i - 1)] - 1), J,
                               ((inv_logit(
                                   ((multiply(
                                       rvalue(X,
                                         cons_list(index_uni(i),
                                           cons_list(index_omni(),
                                             nil_index_list())), "X"), psi0)
                                      + Z_e) + U_e)) * (1 - rho0)) / rho0),
                               (((1 -
                                   inv_logit(
                                     ((multiply(
                                         rvalue(X,
                                           cons_list(index_uni(i),
                                             cons_list(index_omni(),
                                               nil_index_list())), "X"),
                                         psi0) + Z_e) + U_e))) * (1 - rho0))
                                 / rho0), pstream__))) +
                          ((1 -
                             stan::math::exp(
                               gd(
                                 inv_logit(
                                   multiply(
                                     rvalue(X,
                                       cons_list(index_uni(i),
                                         cons_list(index_omni(),
                                           nil_index_list())), "X"), delta)), pstream__)))
                            *
                            stan::math::exp(
                              h0d(Y[(i - 1)], J,
                                ((inv_logit(
                                    multiply(
                                      rvalue(X,
                                        cons_list(index_uni(i),
                                          cons_list(index_omni(),
                                            nil_index_list())), "X"), psi0))
                                   * (1 - rho0)) / rho0),
                                (((1 -
                                    inv_logit(
                                      multiply(
                                        rvalue(X,
                                          cons_list(index_uni(i),
                                            cons_list(index_omni(),
                                              nil_index_list())), "X"), psi0)))
                                   * (1 - rho0)) / rho0), pstream__))))));
                  } else {
                    current_statement__ = 24;
                    if ((primitive_value((primitive_value(
                        logical_eq(treat[(i - 1)], 1)) && primitive_value(
                        logical_eq(direct[(i - 1)], 1)))) && primitive_value(
                        logical_gt(Y[(i - 1)], 0)))) {
                      current_statement__ = 22;
                      lp_accum__.add(
                        ((stan::math::log(
                            (1 -
                              stan::math::exp(
                                jd(
                                  inv_logit(
                                    (multiply(
                                       rvalue(X,
                                         cons_list(index_uni(i),
                                           cons_list(index_omni(),
                                             nil_index_list())), "X"),
                                       gamma0) + treat_e)), pstream__)))) +
                           gd(
                             inv_logit(
                               multiply(
                                 rvalue(X,
                                   cons_list(index_uni(i),
                                     cons_list(index_omni(),
                                       nil_index_list())), "X"), delta)), pstream__))
                          +
                          h1d((Y[(i - 1)] - 1), J,
                            ((inv_logit(
                                (multiply(
                                   rvalue(X,
                                     cons_list(index_uni(i),
                                       cons_list(index_omni(),
                                         nil_index_list())), "X"), psi0) +
                                  Z_e)) * (1 - rho0)) / rho0),
                            (((1 -
                                inv_logit(
                                  (multiply(
                                     rvalue(X,
                                       cons_list(index_uni(i),
                                         cons_list(index_omni(),
                                           nil_index_list())), "X"), psi0) +
                                    Z_e))) * (1 - rho0)) / rho0), pstream__)));
                    } else {
                      current_statement__ = 20;
                      lp_accum__.add(1);
                    }
                  }
                }
              }
            }
          }}
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    lp_accum__.add(lp__);
    return lp_accum__.sum();
    } // log_prob_impl() 
    
  template <typename RNG, typename VecR, typename VecI, typename VecVar, stan::require_vector_like_vt<std::is_floating_point, VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr, stan::require_std_vector_vt<std::is_floating_point, VecVar>* = nullptr>
  inline void write_array_impl(RNG& base_rng__, VecR& params_r__,
                               VecI& params_i__, VecVar& vars__,
                               const bool emit_transformed_parameters__ = true,
                               const bool emit_generated_quantities__ = true,
                               std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.resize(0);
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    static const char* function__ = "model_model_misreport_cmp_namespace::write_array";
(void) function__;  // suppress unused var warning
    (void) function__;  // suppress unused var warning
    double lp__ = 0.0;
    (void) lp__;  // dummy to suppress unused var warning
    stan::math::accumulator<double> lp_accum__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      Eigen::Matrix<double, -1, 1> psi0;
      psi0 = Eigen::Matrix<double, -1, 1>(K);
      stan::math::fill(psi0, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 1;
      psi0 = in__.vector(K);
      Eigen::Matrix<double, -1, 1> delta00;
      delta00 = Eigen::Matrix<double, -1, 1>(K);
      stan::math::fill(delta00, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 2;
      delta00 = in__.vector(K);
      current_statement__ = 2;
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        current_statement__ = 2;
        assign(delta00, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lub_constrain(delta00[(sym1__ - 1)], 0, 1),
          "assigning variable delta00");}
      Eigen::Matrix<double, -1, 1> gamma0;
      gamma0 = Eigen::Matrix<double, -1, 1>(K);
      stan::math::fill(gamma0, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 3;
      gamma0 = in__.vector(K);
      double treat_e;
      treat_e = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 4;
      treat_e = in__.scalar();
      double U_e;
      U_e = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 5;
      U_e = in__.scalar();
      double Z_e;
      Z_e = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 6;
      Z_e = in__.scalar();
      double rho0;
      rho0 = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 7;
      rho0 = in__.scalar();
      current_statement__ = 7;
      rho0 = stan::math::lub_constrain(rho0, 0, 1);
      Eigen::Matrix<double, -1, 1> delta;
      delta = Eigen::Matrix<double, -1, 1>(K);
      stan::math::fill(delta, std::numeric_limits<double>::quiet_NaN());
      
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        vars__.emplace_back(psi0[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        vars__.emplace_back(delta00[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        vars__.emplace_back(gamma0[(sym1__ - 1)]);}
      vars__.emplace_back(treat_e);
      vars__.emplace_back(U_e);
      vars__.emplace_back(Z_e);
      vars__.emplace_back(rho0);
      if (logical_negation((primitive_value(emit_transformed_parameters__) ||
            primitive_value(emit_generated_quantities__)))) {
        return ;
      } 
      current_statement__ = 11;
      for (int i = 1; i <= K; ++i) {
        current_statement__ = 9;
        assign(delta, cons_list(index_uni(i), nil_index_list()),
          stan::math::log((1 / ((1 / delta00[(i - 1)]) - 1))),
          "assigning variable delta");}
      if (emit_transformed_parameters__) {
        for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
          vars__.emplace_back(delta[(sym1__ - 1)]);}
      } 
      if (logical_negation(emit_generated_quantities__)) {
        return ;
      } 
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // write_array_impl() 
    
  template <typename VecVar, typename VecI, stan::require_std_vector_t<VecVar>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline void transform_inits_impl(const stan::io::var_context& context__,
                                   VecI& params_i__, VecVar& vars__,
                                   std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.clear();
    vars__.reserve(num_params_r__);
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      Eigen::Matrix<double, -1, 1> psi0;
      psi0 = Eigen::Matrix<double, -1, 1>(K);
      stan::math::fill(psi0, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> psi0_flat__;
        current_statement__ = 1;
        assign(psi0_flat__, nil_index_list(), context__.vals_r("psi0"),
          "assigning variable psi0_flat__");
        current_statement__ = 1;
        pos__ = 1;
        current_statement__ = 1;
        for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
          current_statement__ = 1;
          assign(psi0, cons_list(index_uni(sym1__), nil_index_list()),
            psi0_flat__[(pos__ - 1)], "assigning variable psi0");
          current_statement__ = 1;
          pos__ = (pos__ + 1);}
      }
      Eigen::Matrix<double, -1, 1> delta00;
      delta00 = Eigen::Matrix<double, -1, 1>(K);
      stan::math::fill(delta00, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> delta00_flat__;
        current_statement__ = 2;
        assign(delta00_flat__, nil_index_list(), context__.vals_r("delta00"),
          "assigning variable delta00_flat__");
        current_statement__ = 2;
        pos__ = 1;
        current_statement__ = 2;
        for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
          current_statement__ = 2;
          assign(delta00, cons_list(index_uni(sym1__), nil_index_list()),
            delta00_flat__[(pos__ - 1)], "assigning variable delta00");
          current_statement__ = 2;
          pos__ = (pos__ + 1);}
      }
      Eigen::Matrix<double, -1, 1> delta00_free__;
      delta00_free__ = Eigen::Matrix<double, -1, 1>(K);
      stan::math::fill(delta00_free__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 2;
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        current_statement__ = 2;
        assign(delta00_free__,
          cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lub_free(delta00[(sym1__ - 1)], 0, 1),
          "assigning variable delta00_free__");}
      Eigen::Matrix<double, -1, 1> gamma0;
      gamma0 = Eigen::Matrix<double, -1, 1>(K);
      stan::math::fill(gamma0, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> gamma0_flat__;
        current_statement__ = 3;
        assign(gamma0_flat__, nil_index_list(), context__.vals_r("gamma0"),
          "assigning variable gamma0_flat__");
        current_statement__ = 3;
        pos__ = 1;
        current_statement__ = 3;
        for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
          current_statement__ = 3;
          assign(gamma0, cons_list(index_uni(sym1__), nil_index_list()),
            gamma0_flat__[(pos__ - 1)], "assigning variable gamma0");
          current_statement__ = 3;
          pos__ = (pos__ + 1);}
      }
      double treat_e;
      treat_e = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 4;
      treat_e = context__.vals_r("treat_e")[(1 - 1)];
      double U_e;
      U_e = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 5;
      U_e = context__.vals_r("U_e")[(1 - 1)];
      double Z_e;
      Z_e = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 6;
      Z_e = context__.vals_r("Z_e")[(1 - 1)];
      double rho0;
      rho0 = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 7;
      rho0 = context__.vals_r("rho0")[(1 - 1)];
      double rho0_free__;
      rho0_free__ = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 7;
      rho0_free__ = stan::math::lub_free(rho0, 0, 1);
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        vars__.emplace_back(psi0[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        vars__.emplace_back(delta00_free__[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        vars__.emplace_back(gamma0[(sym1__ - 1)]);}
      vars__.emplace_back(treat_e);
      vars__.emplace_back(U_e);
      vars__.emplace_back(Z_e);
      vars__.emplace_back(rho0_free__);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // transform_inits_impl() 
    
  inline void get_param_names(std::vector<std::string>& names__) const {
    
    names__.clear();
    names__.emplace_back("psi0");
    names__.emplace_back("delta00");
    names__.emplace_back("gamma0");
    names__.emplace_back("treat_e");
    names__.emplace_back("U_e");
    names__.emplace_back("Z_e");
    names__.emplace_back("rho0");
    names__.emplace_back("delta");
    } // get_param_names() 
    
  inline void get_dims(std::vector<std::vector<size_t>>& dimss__) const {
    dimss__.clear();
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(K)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(K)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(K)});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(K)});
    
    } // get_dims() 
    
  inline void constrained_param_names(
                                      std::vector<std::string>& param_names__,
                                      bool emit_transformed_parameters__ = true,
                                      bool emit_generated_quantities__ = true) const
    final {
    
    for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "psi0" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "delta00" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "gamma0" + '.' + std::to_string(sym1__));
      }}
    param_names__.emplace_back(std::string() + "treat_e");
    param_names__.emplace_back(std::string() + "U_e");
    param_names__.emplace_back(std::string() + "Z_e");
    param_names__.emplace_back(std::string() + "rho0");
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "delta" + '.' + std::to_string(sym1__));
        }}
    }
    
    if (emit_generated_quantities__) {
      
    }
    
    } // constrained_param_names() 
    
  inline void unconstrained_param_names(
                                        std::vector<std::string>& param_names__,
                                        bool emit_transformed_parameters__ = true,
                                        bool emit_generated_quantities__ = true) const
    final {
    
    for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "psi0" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "delta00" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "gamma0" + '.' + std::to_string(sym1__));
      }}
    param_names__.emplace_back(std::string() + "treat_e");
    param_names__.emplace_back(std::string() + "U_e");
    param_names__.emplace_back(std::string() + "Z_e");
    param_names__.emplace_back(std::string() + "rho0");
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "delta" + '.' + std::to_string(sym1__));
        }}
    }
    
    if (emit_generated_quantities__) {
      
    }
    
    } // unconstrained_param_names() 
    
  inline std::string get_constrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"psi0\",\"type\":{\"name\":\"vector\",\"length\":" << K << "},\"block\":\"parameters\"},{\"name\":\"delta00\",\"type\":{\"name\":\"vector\",\"length\":" << K << "},\"block\":\"parameters\"},{\"name\":\"gamma0\",\"type\":{\"name\":\"vector\",\"length\":" << K << "},\"block\":\"parameters\"},{\"name\":\"treat_e\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"U_e\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"Z_e\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"rho0\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"delta\",\"type\":{\"name\":\"vector\",\"length\":" << K << "},\"block\":\"transformed_parameters\"}]";
    return s__.str();
    } // get_constrained_sizedtypes() 
    
  inline std::string get_unconstrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"psi0\",\"type\":{\"name\":\"vector\",\"length\":" << K << "},\"block\":\"parameters\"},{\"name\":\"delta00\",\"type\":{\"name\":\"vector\",\"length\":" << K << "},\"block\":\"parameters\"},{\"name\":\"gamma0\",\"type\":{\"name\":\"vector\",\"length\":" << K << "},\"block\":\"parameters\"},{\"name\":\"treat_e\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"U_e\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"Z_e\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"rho0\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"delta\",\"type\":{\"name\":\"vector\",\"length\":" << K << "},\"block\":\"transformed_parameters\"}]";
    return s__.str();
    } // get_unconstrained_sizedtypes() 
    
  
    // Begin method overload boilerplate
    template <typename RNG>
    inline void write_array(RNG& base_rng,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                            const bool emit_transformed_parameters = true,
                            const bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      std::vector<double> vars_vec(vars.size());
      std::vector<int> params_i;
      write_array_impl(base_rng, params_r, params_i, vars_vec,
          emit_transformed_parameters, emit_generated_quantities, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i) {
        vars.coeffRef(i) = vars_vec[i];
      }
    }
    template <typename RNG>
    inline void write_array(RNG& base_rng, std::vector<double>& params_r,
                            std::vector<int>& params_i,
                            std::vector<double>& vars,
                            bool emit_transformed_parameters = true,
                            bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      write_array_impl(base_rng, params_r, params_i, vars, emit_transformed_parameters, emit_generated_quantities, pstream);
    }
    template <bool propto__, bool jacobian__, typename T_>
    inline T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
                       std::ostream* pstream = nullptr) const {
      Eigen::Matrix<int, -1, 1> params_i;
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
    template <bool propto__, bool jacobian__, typename T__>
    inline T__ log_prob(std::vector<T__>& params_r,
                        std::vector<int>& params_i,
                        std::ostream* pstream = nullptr) const {
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
  
    inline void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream = nullptr) const final {
      std::vector<double> params_r_vec(params_r.size());
      std::vector<int> params_i;
      transform_inits_impl(context, params_i, params_r_vec, pstream);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i) {
        params_r.coeffRef(i) = params_r_vec[i];
      }
    }
    inline void transform_inits(const stan::io::var_context& context,
                                std::vector<int>& params_i,
                                std::vector<double>& vars,
                                std::ostream* pstream = nullptr) const final {
      transform_inits_impl(context, params_i, vars, pstream);
    }        
};
}
using stan_model = model_model_misreport_cmp_namespace::model_model_misreport_cmp;
#ifndef USING_R
// Boilerplate
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
stan::math::profile_map& get_stan_profile_data() {
  return model_model_misreport_cmp_namespace::profiles__;
}
#endif
#endif
