% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_bayesnec.R
\name{fit_bayesnec}
\alias{fit_bayesnec}
\title{fit_bayesnec}
\usage{
fit_bayesnec(
  data,
  x_var,
  y_var,
  trials_var = NA,
  family = NULL,
  priors,
  model = NA,
  inits,
  skip_check = FALSE,
  pointwise,
  random = NA,
  random_vars = NA,
  ...
)
}
\arguments{
\item{data}{A \code{\link[base]{data.frame}} containing the data to use for
the model.}

\item{x_var}{A \code{\link[base]{character}} indicating the column heading
containing the concentration (x) variable.}

\item{y_var}{A \code{\link[base]{character}} indicating the column heading
containing the response (y) variable.}

\item{trials_var}{The column heading indicating the column for the number
of "trials" for binomial or beta_binomial2 response data.
If not supplied, the model may run but will not be the model you intended!}

\item{family}{Either a \code{\link[base]{character}} string, a function, or
an object of class \code{\link[stats]{family}} defining the statistical
distribution (family) to use for the y (response) data. See details.}

\item{priors}{An object of class \code{\link[brms]{brmsprior}} which
specifies user-desired prior distributions of model parameters.
If missing, \code{\link{bnec}} will figure out a baseline prior for each
parameter. It can also be specified as a named \code{\link[base]{list}}
where each name needs to correspond to the same string as "model". See
details.}

\item{model}{A \code{\link[base]{character}} vector indicating the model(s)
to fit. See Details for more information.}

\item{inits}{Optional. Initialisation values. Must be a
\code{\link[base]{list}} of "n" names lists, where "n" corresponds to the
number of chains, and names correspond to the parameter names of a given
model.}

\item{skip_check}{Should data check via \code{\link{check_data}}
be avoided? Only relevant to function \code{\link{amend}}.
Defaults to FALSE.}

\item{pointwise}{A flag indicating whether to compute the full log-likelihood matrix
at once or separately for each observation. The latter approach is usually considerably slower but requires
much less working memory. Accordingly, if one runs into memory issues, pointwise = TRUE is the way to go,
but will not work for the custom family beta_binomial2}

\item{random}{= A named \code{\link[base]{list}} containing the random model
formula to apply to model parameters.}

\item{random_vars}{= A \code{\link[base]{character}} vector containing the names of
the columns containing the variables used in the random model formula.}

\item{...}{Further arguments to \code{\link[brms]{brm}} via
\code{\link{fit_bayesnec}}.}
}
\value{
The fitted \pkg{brms} model, including an estimate of the NEC
value and predicted posterior values.
A posterior sample of the NEC is also available under \code{nec_posterior}
}
\description{
Fits a concentration(dose)-response model using brms
}
\seealso{
\code{\link{bnec}}
}
