% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bayesnecformula.R
\name{make_brmsformula}
\alias{make_brmsformula}
\title{Expose the final \code{\link[brms]{brmsformula}}}
\usage{
make_brmsformula(formula, data)
}
\arguments{
\item{formula}{Either a \code{\link[base]{character}} string defining an
R formula or an actual \code{\link[stats]{formula}} object. See details.}

\item{data}{A \code{\link[base]{data.frame}} containing the variables
specified in \code{formula}.}
}
\value{
A named \code{\link[base]{list}}, with each element containing the
final \code{\link[brms]{brmsformula}} to be passed to
\code{\link[brms]{brm}}.
}
\description{
Checks the input formula according to
\code{\link[bayesnec:bayesnec-package]{bayesnec}} requirements and
expose the final \code{\link[brms]{brmsformula}} which is to be fitted via
package \pkg{brms}.
}
\examples{
library(bayesnec)
nec3param <- function(beta, nec, top, x) {
  top * exp(-exp(beta) * (x - nec) *
    ifelse(x - nec < 0, 0, 1))
}

data <- data.frame(x = seq(1, 20, length.out = 10), tr = 100, wght = c(1, 2),
                   group_1 = sample(c("a", "b"), 10, replace = TRUE),
                   group_2 = sample(c("c", "d"), 10, replace = TRUE))
data$y <- nec3param(beta = -0.2, nec = 4, top = 100, data$x)

# make one single model
f_1 <- "y | trials(tr) ~ crf(sqrt(x), \"nec3param\")"
make_brmsformula(f_1, data)
# make an entire class of models
f_2 <- y ~ crf(x, "ecx") + ogl(group_1) + pgl(group_2)
make_brmsformula(f_2, data)

}
\seealso{
\code{\link{bayesnecformula}},
\code{\link{check_formula}}
}
