% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot.R
\name{autoplot}
\alias{autoplot}
\alias{autoplot.bayesnecfit}
\alias{autoplot.bayesmanecfit}
\title{bayesnec standard ggplot2 plotting method}
\usage{
\method{autoplot}{bayesnecfit}(object, ..., nec = TRUE, ecx = FALSE, xform = identity)

\method{autoplot}{bayesmanecfit}(
  object,
  ...,
  nec = TRUE,
  ecx = FALSE,
  xform = identity,
  all_models = FALSE,
  plot = TRUE,
  ask = TRUE,
  newpage = TRUE,
  multi_facet = TRUE
)
}
\arguments{
\item{object}{An object of class \code{\link{bayesnecfit}} or
\code{\link{bayesmanecfit}}.}

\item{...}{Additional arguments to be passed to \code{\link{ggbnec_data}}.}

\item{nec}{Should NEC values be added to the plot? Defaults to TRUE.}

\item{ecx}{Should ECx values be added to the plot? Defaults to FALSE..}

\item{xform}{A function to apply to the returned estimated concentration
values.}

\item{all_models}{Should all individual models be plotted separately\
(defaults to FALSE) or should model averaged predictions be plotted instead?}

\item{plot}{Should output \code{\link[ggplot2]{ggplot}} output be plotted?
Only relevant if \code{all = TRUE} and \code{multi_facet = FALSE}.}

\item{ask}{Indicates if the user is prompted before a new page is plotted.
Only relevant if \code{plot = TRUE} and \code{multi_facet = FALSE}.}

\item{newpage}{Indicates if the first set of plots should be plotted to a
new page. Only relevant if \code{plot = TRUE} and
\code{multi_facet = FALSE}.}

\item{multi_facet}{Should all plots be plotted in one single panel via
facets? Defaults to TRUE.}
}
\value{
A \code{\link[ggplot2]{ggplot}} object.
}
\description{
\code{\link[bayesnec:bayesnec-package]{bayesnec}} standard \pkg{ggplot2}
plotting method.
}
\examples{
\dontrun{
library(brms)
nec4param <- pull_out(manec_example, "nec4param")
autoplot(nec4param)
autoplot(nec4param, nec = FALSE)
autoplot(nec4param, ecx = TRUE, ecx_val = 50)

# plot model averaged predictions
autoplot(manec_example)
# plot all panels together
autoplot(manec_example, ecx = TRUE, ecx_val = 50, all_models = TRUE)
}
\dontrun{
# plots multiple models, one at a time, with interactive prompt
autoplot(manec_example, ecx = TRUE, ecx_val = 50, all_models = TRUE,
         multi_facet = FALSE)
}
}
