% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smwrBase_group2row.R
\name{group2row}
\alias{group2row}
\title{Restructure Data}
\usage{
group2row(data, carryColumns, splitColumn, collectColumns)
}
\arguments{
\item{data}{a data frame containing the columns to be combined.}

\item{carryColumns}{the names of the columns that form a row in the output
dataset. Each unique combination of values in these columns will be a new row
in the output dataset.}

\item{splitColumn}{the name of a single column. For each unique value in
\code{splitColumn} and for each column in \code{collectColumns}, a new column
is created in the output.}

\item{collectColumns}{the names of the columns to be collected. See
\bold{Details}.}
}
\description{
Combine data from several rows into a single row based on common data in
selected columns.
}
\details{
The function \code{group2row} combines data from several rows into a single
row. Certain columns in the input dataset are said to be "collected." Other
columns may be "carried" into the output dataset by listing them in
\code{carryColumns}. A new row will be created for each unique combination of
values in the \code{carryColumns}. The output row consists of the carried
columns plus new columns that are named by the unique values in the
\code{splitColumn} concatenated with the names in the \code{collectColumns}.
The number of columns in the output data frame is equal to the number of
\code{carryColumns} plus the number of unique values in the
\code{splitColumn} times the number of names in the \code{collectColumns}.\cr

The strategy for collecting columns is to use a set of index values defined
by the \code{splitColumn}. The maximum number of input rows collected for
each output row is equal to the number of unique values defined in the
\code{splitColumn}. The \code{splitColumn} is used to identify a column from
the input data that contains output column information. If a row of input has
a value in this column that matches one of the index values, then that row's
data will be included in the output in the column positions corresponding to
the matched index. The index values are concatenated with the input column
names of the collected columns to derive output column names.\cr

Added from smwrBase.
}
\examples{
\dontrun{
library(smwrData)
data(QWstacked)
group2row(QWstacked, c("site_no", "sample_dt", "sample_tm"), "parm_cd", 
 c("result_va", "remark_cd"))
}
}
\keyword{internal}
\keyword{manip}
