% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smwrGraphs_timePlot.R
\docType{methods}
\name{timePlot}
\alias{timePlot}
\alias{timePlot,Date,numeric-method}
\alias{timePlot,POSIXt,numeric-method}
\alias{timePlot,numeric,numeric-method}
\alias{timePlot,integer,numeric-method}
\alias{timePlot,difftime,numeric-method}
\title{Time-series Plots}
\usage{
timePlot(x, y, Plot = list(), yaxis.log = FALSE, yaxis.rev = FALSE,
  yaxis.range = c(NA, NA), xaxis.range = range(x, na.rm = TRUE),
  ylabels = 7, xlabels = "Auto", xtitle = "", ytitle = "",
  caption = "", margin = c(NA, NA, NA, NA), ...)

\S4method{timePlot}{Date,numeric}(x, y, Plot = list(name = "", what =
  "lines", type = "solid", width = "standard", symbol = "circle", filled =
  TRUE, size = 0.09, color = "black"), yaxis.log = FALSE,
  yaxis.rev = FALSE, yaxis.range = c(NA, NA), xaxis.range = range(x,
  na.rm = TRUE), ylabels = 7, xlabels = "Auto", xtitle = "",
  ytitle = deparse(substitute(y)), caption = "", margin = c(NA, NA,
  NA, NA), ...)

\S4method{timePlot}{POSIXt,numeric}(x, y, Plot = list(name = "", what =
  "lines", type = "solid", width = "standard", symbol = "circle", filled =
  TRUE, size = 0.09, color = "black"), yaxis.log = FALSE,
  yaxis.rev = FALSE, yaxis.range = c(NA, NA), xaxis.range = range(x,
  na.rm = TRUE), ylabels = 7, xlabels = "Auto", xtitle = "",
  ytitle = deparse(substitute(y)), caption = "", margin = c(NA, NA,
  NA, NA), ...)

\S4method{timePlot}{numeric,numeric}(x, y, Plot = list(name = "", what =
  "lines", type = "solid", width = "standard", symbol = "circle", filled =
  TRUE, size = 0.09, color = "black"), yaxis.log = FALSE,
  yaxis.rev = FALSE, yaxis.range = c(NA, NA), xaxis.range = range(x,
  na.rm = TRUE), ylabels = 7, xlabels = "Auto", xtitle = "",
  ytitle = deparse(substitute(y)), caption = "", margin = c(NA, NA,
  NA, NA), ...)

\S4method{timePlot}{integer,numeric}(x, y, Plot = list(name = "", what =
  "points", type = "solid", width = "standard", symbol = "circle", filled =
  TRUE, size = 0.09, color = "black"), yaxis.log = FALSE,
  yaxis.rev = FALSE, yaxis.range = c(NA, NA), xaxis.range = range(x,
  na.rm = TRUE) + c(-1, 1), ylabels = 7, xlabels = "Auto",
  xtitle = "", ytitle = deparse(substitute(y)), caption = "",
  margin = c(NA, NA, NA, NA), xlabels.rotate = FALSE, ...)

\S4method{timePlot}{difftime,numeric}(x, y, Plot = list(name = "", what =
  "lines", type = "solid", width = "standard", symbol = "circle", filled =
  TRUE, size = 0.09, color = "black"), yaxis.log = FALSE,
  yaxis.rev = FALSE, yaxis.range = c(NA, NA), xaxis.range = range(x,
  na.rm = TRUE), ylabels = 7, xlabels = "Auto", xtitle = "Auto",
  ytitle = deparse(substitute(y)), caption = "", margin = c(NA, NA,
  NA, NA), ...)
}
\arguments{
\item{x}{the time/date data.}

\item{y}{the y-axis data.}

\item{Plot}{parameters defining the characteristics of the plot. See
\code{\link{setPlot}} for a description of the parameters.}

\item{yaxis.log}{logical, if \code{TRUE}, then log-transform the y axis.}

\item{yaxis.rev}{logical, if \code{TRUE}, then reverse the y axis.}

\item{yaxis.range}{set the range of the y-axis. See \bold{Details}.}

\item{xaxis.range}{set the range of the x-axis. Set at January 1 through
December 31 for \code{seasonPlot}.}

\item{ylabels}{set up y-axis labels. See \code{\link{linearPretty}} for
details.}

\item{xlabels}{set up x-axis labels. See \bold{Details} for details for
valid values.}

\item{xtitle}{the x-axis title (also called x-axis caption). Generally should
be blank as titles are typically set up by the axis labeling routines.}

\item{ytitle}{the y-axis title (also called y-axis caption).}

\item{caption}{the figure caption.}

\item{margin}{set the plot area margins, in units of lines of text. Generally
all NA or the output from \code{setGraph} if appropriate.}

\item{...}{arguments for specific methods.}

\item{xlabels.rotate}{logical, if \code{TRUE}, then rotate the x-axis labels 
so that they are perpendicular to the x-axis.}
}
\value{
Information about the graph.
}
\description{
Creates a plot of time-series data.
}
\details{
For the \code{timePlot} methods where the time/date data are of class "Date,"
"POSIXt," or "numeric," the values for \code{xlabels} must be one of
"hours," "days," "months," "years," "water years," or "Auto," which will 
select an appropriate axis labeling scheme based on the time span of the data. 
May also be a list of valid arguments to \code{datePretty} for finer control.

For the \code{timePlot} method where the time/date data are of class "integer," 
the value for \code{xlabels} must be one of "Auto," a number indicating the approximate
number of labels, or a list of valid arguments to \code{linearPretty} for finer control.

For the \code{timePlot} method where the time/date data are of class "difftime," 
the value for \code{xlabels} must be one of "Auto" or a number indicating the approximate
number of labels.\cr

For linear axes, the range can be set to virtually any pair of values. For 
log axes, the choice of range is more resticted---for less than one log-cycle,
powers of whole numbers can be used; from 1 to about 3 log cycles, the choces 
should be powers of 3 or 10; and for more than 3 log cycles, the range sould be 
expressed only in powers of 10.

Added from smwrGraphs.
}
\note{
The function \code{timePlot} produces a time-series plot. The function
\code{seasonPlot} produces a plot of the annual cycle. There is no function
in the smwrGraphs package that will automatically transform time/date data
to the correct seasonal value; use \code{dectime(x) - trunc(dectime(x))},
where \code{x} is the time/date variable.
}
\section{Methods}{
 \describe{

\item{signature(x = "Date", y = "numeric")}{ Create a
time-series plot for Date and numeric data. }
\item{signature(x ="POSIXt", y = "numeric")}{ Create a 
time-series plot for POSIXt and #' numeric data. } 
\item{signature(x = "numeric", y = "numeric")}{ Create a 
time-series plot for dates in decimal format and numeric data. }
\item{signature(x = "integer", y = "numeric")}{ Create a
time-series plot for annual summaries of numeric data. }
\item{signature(x = "difftime", y = "numeric")}{ Create a
time-series plot for difftime and numeric data. } }
}

\examples{
\dontrun{
# the months function is in lubridate
X <- as.Date("2001-01-15") + months(0:11)
set.seed(1)
Y <- runif(12)
setGD()
timePlot(X, Y)
# For more details of timePlot see
vignette(topic="DateAxisFormats", package="smwrGraphs")
vignette(topic="LineScatter", package="smwrGraphs")
demo(topic="AnnualFlowBarChart", package="smwrGraphs")
demo(topic="DurationHydrograph", package="smwrGraphs")
demo(topic="HydroPrecip", package="smwrGraphs")
demo(topic="RightAxisExample", package="smwrGraphs")
}
}
\keyword{hplot}
\keyword{internal}
\keyword{methods}
